@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.GroupProtectedEnvironmentApprovalRule
import com.pulumi.gitlab.kotlin.outputs.GroupProtectedEnvironmentDeployAccessLevel
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.gitlab.kotlin.outputs.GroupProtectedEnvironmentApprovalRule.Companion.toKotlin as groupProtectedEnvironmentApprovalRuleToKotlin
import com.pulumi.gitlab.kotlin.outputs.GroupProtectedEnvironmentDeployAccessLevel.Companion.toKotlin as groupProtectedEnvironmentDeployAccessLevelToKotlin

/**
 * Builder for [GroupProtectedEnvironment].
 */
@PulumiTagMarker
public class GroupProtectedEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupProtectedEnvironmentArgs = GroupProtectedEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupProtectedEnvironmentArgsBuilder.() -> Unit) {
        val builder = GroupProtectedEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupProtectedEnvironment {
        val builtJavaResource = com.pulumi.gitlab.GroupProtectedEnvironment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupProtectedEnvironment(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupProtectedEnvironment` resource allows to manage the lifecycle of a protected environment in a group.
 * > In order to use a user_id in the `deploy_access_levels` configuration,
 *    you need to make sure that users have access to the group with Maintainer role or higher.
 *    In order to use a group_id in the `deploy_access_levels` configuration,
 *    the group_id must be a sub-group under the given group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/group_protected_environments.html)
 * ## Import
 * GitLab group protected environments can be imported using an id made up of `groupId:environmentName`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupProtectedEnvironment:GroupProtectedEnvironment bar 123:production
 * ```
 */
public class GroupProtectedEnvironment internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupProtectedEnvironment,
) : KotlinCustomResource(javaResource, GroupProtectedEnvironmentMapper) {
    /**
     * Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    public val approvalRules: Output<List<GroupProtectedEnvironmentApprovalRule>>
        get() = javaResource.approvalRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> groupProtectedEnvironmentApprovalRuleToKotlin(args0) })
            })
        })

    /**
     * Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    public val deployAccessLevels: Output<List<GroupProtectedEnvironmentDeployAccessLevel>>
        get() = javaResource.deployAccessLevels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> groupProtectedEnvironmentDeployAccessLevelToKotlin(args0) })
            })
        })

    /**
     * The deployment tier of the environment.  Valid values are `production`, `staging`, `testing`, `development`, `other`.
     */
    public val environment: Output<String>
        get() = javaResource.environment().applyValue({ args0 -> args0 })

    /**
     * The ID or full path of the group which the protected environment is created against.
     */
    public val group: Output<String>
        get() = javaResource.group().applyValue({ args0 -> args0 })
}

public object GroupProtectedEnvironmentMapper : ResourceMapper<GroupProtectedEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupProtectedEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): GroupProtectedEnvironment =
        GroupProtectedEnvironment(javaResource as com.pulumi.gitlab.GroupProtectedEnvironment)
}

/**
 * @see [GroupProtectedEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupProtectedEnvironment].
 */
public suspend fun groupProtectedEnvironment(
    name: String,
    block: suspend GroupProtectedEnvironmentResourceBuilder.() -> Unit,
): GroupProtectedEnvironment {
    val builder = GroupProtectedEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupProtectedEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupProtectedEnvironment(name: String): GroupProtectedEnvironment {
    val builder = GroupProtectedEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
