@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupProtectedEnvironmentArgs.builder
import com.pulumi.gitlab.kotlin.inputs.GroupProtectedEnvironmentApprovalRuleArgs
import com.pulumi.gitlab.kotlin.inputs.GroupProtectedEnvironmentApprovalRuleArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GroupProtectedEnvironmentDeployAccessLevelArgs
import com.pulumi.gitlab.kotlin.inputs.GroupProtectedEnvironmentDeployAccessLevelArgsBuilder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupProtectedEnvironment` resource allows to manage the lifecycle of a protected environment in a group.
 * > In order to use a user_id in the `deploy_access_levels` configuration,
 *    you need to make sure that users have access to the group with Maintainer role or higher.
 *    In order to use a group_id in the `deploy_access_levels` configuration,
 *    the group_id must be a sub-group under the given group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/group_protected_environments.html)
 * ## Import
 * GitLab group protected environments can be imported using an id made up of `groupId:environmentName`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupProtectedEnvironment:GroupProtectedEnvironment bar 123:production
 * ```
 * @property approvalRules Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
 * @property deployAccessLevels Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
 * @property environment The deployment tier of the environment.  Valid values are `production`, `staging`, `testing`, `development`, `other`.
 * @property group The ID or full path of the group which the protected environment is created against.
 */
public data class GroupProtectedEnvironmentArgs(
    public val approvalRules: Output<List<GroupProtectedEnvironmentApprovalRuleArgs>>? = null,
    public val deployAccessLevels: Output<List<GroupProtectedEnvironmentDeployAccessLevelArgs>>? =
        null,
    public val environment: Output<String>? = null,
    public val group: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupProtectedEnvironmentArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupProtectedEnvironmentArgs =
        com.pulumi.gitlab.GroupProtectedEnvironmentArgs.builder()
            .approvalRules(
                approvalRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deployAccessLevels(
                deployAccessLevels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .environment(environment?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupProtectedEnvironmentArgs].
 */
@PulumiTagMarker
public class GroupProtectedEnvironmentArgsBuilder internal constructor() {
    private var approvalRules: Output<List<GroupProtectedEnvironmentApprovalRuleArgs>>? = null

    private var deployAccessLevels: Output<List<GroupProtectedEnvironmentDeployAccessLevelArgs>>? =
        null

    private var environment: Output<String>? = null

    private var group: Output<String>? = null

    /**
     * @param value Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("qmglajxoektcbgbb")
    public suspend fun approvalRules(`value`: Output<List<GroupProtectedEnvironmentApprovalRuleArgs>>) {
        this.approvalRules = value
    }

    @JvmName("tfmfvbymlfcunpyg")
    public suspend fun approvalRules(vararg values: Output<GroupProtectedEnvironmentApprovalRuleArgs>) {
        this.approvalRules = Output.all(values.asList())
    }

    /**
     * @param values Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("hrrntlpqlcwucokr")
    public suspend fun approvalRules(values: List<Output<GroupProtectedEnvironmentApprovalRuleArgs>>) {
        this.approvalRules = Output.all(values)
    }

    /**
     * @param value Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("cuhyxbhavktoekxu")
    public suspend fun deployAccessLevels(`value`: Output<List<GroupProtectedEnvironmentDeployAccessLevelArgs>>) {
        this.deployAccessLevels = value
    }

    @JvmName("iumyrnlvrewxjsme")
    public suspend fun deployAccessLevels(vararg values: Output<GroupProtectedEnvironmentDeployAccessLevelArgs>) {
        this.deployAccessLevels = Output.all(values.asList())
    }

    /**
     * @param values Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("ihlhxeggpkvkskwk")
    public suspend fun deployAccessLevels(values: List<Output<GroupProtectedEnvironmentDeployAccessLevelArgs>>) {
        this.deployAccessLevels = Output.all(values)
    }

    /**
     * @param value The deployment tier of the environment.  Valid values are `production`, `staging`, `testing`, `development`, `other`.
     */
    @JvmName("pkmxlufketaqxdpx")
    public suspend fun environment(`value`: Output<String>) {
        this.environment = value
    }

    /**
     * @param value The ID or full path of the group which the protected environment is created against.
     */
    @JvmName("memrsjtpnnfsmuxj")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("mirvyfhvniuyrhjx")
    public suspend fun approvalRules(`value`: List<GroupProtectedEnvironmentApprovalRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvalRules = mapped
    }

    /**
     * @param argument Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("tehibgixuocraypo")
    public suspend fun approvalRules(argument: List<suspend GroupProtectedEnvironmentApprovalRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupProtectedEnvironmentApprovalRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param argument Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("tkwuljkehskfwnbe")
    public suspend fun approvalRules(vararg argument: suspend GroupProtectedEnvironmentApprovalRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GroupProtectedEnvironmentApprovalRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param argument Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("glwsilormribogyg")
    public suspend fun approvalRules(argument: suspend GroupProtectedEnvironmentApprovalRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GroupProtectedEnvironmentApprovalRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param values Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("ufirwhyoaayqgvpt")
    public suspend fun approvalRules(vararg values: GroupProtectedEnvironmentApprovalRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.approvalRules = mapped
    }

    /**
     * @param value Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("mmffntsnwpwqkemq")
    public suspend fun deployAccessLevels(`value`: List<GroupProtectedEnvironmentDeployAccessLevelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("jswprlgmqqsvykgf")
    public suspend fun deployAccessLevels(argument: List<suspend GroupProtectedEnvironmentDeployAccessLevelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupProtectedEnvironmentDeployAccessLevelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.deployAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("fcvfwlveybvnjjvo")
    public suspend fun deployAccessLevels(vararg argument: suspend GroupProtectedEnvironmentDeployAccessLevelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GroupProtectedEnvironmentDeployAccessLevelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.deployAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("awbgvnyeeqmdfibf")
    public suspend fun deployAccessLevels(argument: suspend GroupProtectedEnvironmentDeployAccessLevelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GroupProtectedEnvironmentDeployAccessLevelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.deployAccessLevels = mapped
    }

    /**
     * @param values Array of access levels allowed to deploy, with each described by a hash. Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("jrinwgruxmbeusbk")
    public suspend fun deployAccessLevels(vararg values: GroupProtectedEnvironmentDeployAccessLevelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deployAccessLevels = mapped
    }

    /**
     * @param value The deployment tier of the environment.  Valid values are `production`, `staging`, `testing`, `development`, `other`.
     */
    @JvmName("syuttkfjvfevosul")
    public suspend fun environment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param value The ID or full path of the group which the protected environment is created against.
     */
    @JvmName("oujdnttxumbxvmwa")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    internal fun build(): GroupProtectedEnvironmentArgs = GroupProtectedEnvironmentArgs(
        approvalRules = approvalRules,
        deployAccessLevels = deployAccessLevels,
        environment = environment,
        group = group,
    )
}
