@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupSamlLinkArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupSamlLink` resource allows to manage the lifecycle of an SAML integration with a group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#saml-group-links)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * // Basic example
 * const test = new gitlab.GroupSamlLink("test", {
 *     group: "12345",
 *     accessLevel: "developer",
 *     samlGroupName: "samlgroupname1",
 * });
 * // Example using a Custom Role (Ultimate only)
 * // When using the custom role, the `access_level` must match the
 * // base role used to create the custom role.
 * const testCustomRole = new gitlab.GroupSamlLink("test_custom_role", {
 *     group: "12345",
 *     accessLevel: "developer",
 *     samlGroupName: "samlgroupname1",
 *     memberRoleId: 123,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * # Basic example
 * test = gitlab.GroupSamlLink("test",
 *     group="12345",
 *     access_level="developer",
 *     saml_group_name="samlgroupname1")
 * # Example using a Custom Role (Ultimate only)
 * # When using the custom role, the `access_level` must match the
 * # base role used to create the custom role.
 * test_custom_role = gitlab.GroupSamlLink("test_custom_role",
 *     group="12345",
 *     access_level="developer",
 *     saml_group_name="samlgroupname1",
 *     member_role_id=123)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Basic example
 *     var test = new GitLab.GroupSamlLink("test", new()
 *     {
 *         Group = "12345",
 *         AccessLevel = "developer",
 *         SamlGroupName = "samlgroupname1",
 *     });
 *     // Example using a Custom Role (Ultimate only)
 *     // When using the custom role, the `access_level` must match the
 *     // base role used to create the custom role.
 *     var testCustomRole = new GitLab.GroupSamlLink("test_custom_role", new()
 *     {
 *         Group = "12345",
 *         AccessLevel = "developer",
 *         SamlGroupName = "samlgroupname1",
 *         MemberRoleId = 123,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Basic example
 * 		_, err := gitlab.NewGroupSamlLink(ctx, "test", &gitlab.GroupSamlLinkArgs{
 * 			Group:         pulumi.String("12345"),
 * 			AccessLevel:   pulumi.String("developer"),
 * 			SamlGroupName: pulumi.String("samlgroupname1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Example using a Custom Role (Ultimate only)
 * 		// When using the custom role, the `access_level` must match the
 * 		// base role used to create the custom role.
 * 		_, err = gitlab.NewGroupSamlLink(ctx, "test_custom_role", &gitlab.GroupSamlLinkArgs{
 * 			Group:         pulumi.String("12345"),
 * 			AccessLevel:   pulumi.String("developer"),
 * 			SamlGroupName: pulumi.String("samlgroupname1"),
 * 			MemberRoleId:  pulumi.Int(123),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupSamlLink;
 * import com.pulumi.gitlab.GroupSamlLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Basic example
 *         var test = new GroupSamlLink("test", GroupSamlLinkArgs.builder()
 *             .group("12345")
 *             .accessLevel("developer")
 *             .samlGroupName("samlgroupname1")
 *             .build());
 *         // Example using a Custom Role (Ultimate only)
 *         // When using the custom role, the `access_level` must match the
 *         // base role used to create the custom role.
 *         var testCustomRole = new GroupSamlLink("testCustomRole", GroupSamlLinkArgs.builder()
 *             .group("12345")
 *             .accessLevel("developer")
 *             .samlGroupName("samlgroupname1")
 *             .memberRoleId(123)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Basic example
 *   test:
 *     type: gitlab:GroupSamlLink
 *     properties:
 *       group: '12345'
 *       accessLevel: developer
 *       samlGroupName: samlgroupname1
 *   # Example using a Custom Role (Ultimate only)
 *   # When using the custom role, the `access_level` must match the
 *   # base role used to create the custom role.
 *   testCustomRole:
 *     type: gitlab:GroupSamlLink
 *     name: test_custom_role
 *     properties:
 *       group: '12345'
 *       accessLevel: developer
 *       samlGroupName: samlgroupname1
 *       memberRoleId: 123
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab group saml links can be imported using an id made up of `group_id:saml_group_name`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupSamlLink:GroupSamlLink test "12345:samlgroupname1"
 * ```
 * @property accessLevel Access level for members of the SAML group. Valid values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
 * @property group The ID or path of the group to add the SAML Group Link to.
 * @property memberRoleId The ID of a custom member role. Only available for Ultimate instances. When using a custom role, the `access_level` must match the base role used to create the custom role.
 * @property samlGroupName The name of the SAML group.
 */
public data class GroupSamlLinkArgs(
    public val accessLevel: Output<String>? = null,
    public val group: Output<String>? = null,
    public val memberRoleId: Output<Int>? = null,
    public val samlGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupSamlLinkArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupSamlLinkArgs =
        com.pulumi.gitlab.GroupSamlLinkArgs.builder()
            .accessLevel(accessLevel?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .memberRoleId(memberRoleId?.applyValue({ args0 -> args0 }))
            .samlGroupName(samlGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupSamlLinkArgs].
 */
@PulumiTagMarker
public class GroupSamlLinkArgsBuilder internal constructor() {
    private var accessLevel: Output<String>? = null

    private var group: Output<String>? = null

    private var memberRoleId: Output<Int>? = null

    private var samlGroupName: Output<String>? = null

    /**
     * @param value Access level for members of the SAML group. Valid values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
     */
    @JvmName("ouwsmleqeabselaw")
    public suspend fun accessLevel(`value`: Output<String>) {
        this.accessLevel = value
    }

    /**
     * @param value The ID or path of the group to add the SAML Group Link to.
     */
    @JvmName("dipeahxtxupvewrw")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value The ID of a custom member role. Only available for Ultimate instances. When using a custom role, the `access_level` must match the base role used to create the custom role.
     */
    @JvmName("hluhwxrmgfholigf")
    public suspend fun memberRoleId(`value`: Output<Int>) {
        this.memberRoleId = value
    }

    /**
     * @param value The name of the SAML group.
     */
    @JvmName("ejvhvogbpjnqvmls")
    public suspend fun samlGroupName(`value`: Output<String>) {
        this.samlGroupName = value
    }

    /**
     * @param value Access level for members of the SAML group. Valid values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
     */
    @JvmName("stgbbeejmlxmsebx")
    public suspend fun accessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevel = mapped
    }

    /**
     * @param value The ID or path of the group to add the SAML Group Link to.
     */
    @JvmName("fsrkysojaxuxfdvg")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value The ID of a custom member role. Only available for Ultimate instances. When using a custom role, the `access_level` must match the base role used to create the custom role.
     */
    @JvmName("wottqehcieftvyxw")
    public suspend fun memberRoleId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberRoleId = mapped
    }

    /**
     * @param value The name of the SAML group.
     */
    @JvmName("ywvrjmllsbctajak")
    public suspend fun samlGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samlGroupName = mapped
    }

    internal fun build(): GroupSamlLinkArgs = GroupSamlLinkArgs(
        accessLevel = accessLevel,
        group = group,
        memberRoleId = memberRoleId,
        samlGroupName = samlGroupName,
    )
}
