@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupSecurityPolicyAttachment].
 */
@PulumiTagMarker
public class GroupSecurityPolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupSecurityPolicyAttachmentArgs = GroupSecurityPolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupSecurityPolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = GroupSecurityPolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupSecurityPolicyAttachment {
        val builtJavaResource = com.pulumi.gitlab.GroupSecurityPolicyAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupSecurityPolicyAttachment(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupSecurityPolicyAttachment` resource allows to attach a security policy project to a group.
 * **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/index.html#mutationsecuritypolicyprojectassign)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * // This resource can be used to attach a security policy to a pre-existing group
 * const foo = new gitlab.GroupSecurityPolicyAttachment("foo", {
 *     group: "1234",
 *     policyProject: "4567",
 * });
 * // Or you can use Terraform to create a new project, add a policy to that project,
 * // then attach that policy project to other groups.
 * const my_policy_project = new gitlab.Project("my-policy-project", {name: "security-policy-project"});
 * const policy_yml = new gitlab.RepositoryFile("policy-yml", {
 *     project: my_policy_project.id,
 *     filePath: ".gitlab/security-policies/my-policy.yml",
 *     branch: "master",
 *     encoding: "text",
 *     content: `---
 * approval_policy:
 * - name: test
 * description: test
 * enabled: true
 * rules:
 * - type: any_merge_request
 *     branch_type: protected
 *     commits: any
 * approval_settings:
 *     block_branch_modification: true
 *     prevent_pushing_and_force_pushing: true
 *     prevent_approval_by_author: true
 *     prevent_approval_by_commit_author: true
 *     remove_approvals_with_new_commit: true
 *     require_password_to_approve: false
 * fallback_behavior:
 *     fail: closed
 * actions:
 * - type: send_bot_message
 *     enabled: true
 * `,
 * });
 * const my_policy = new gitlab.GroupSecurityPolicyAttachment("my-policy", {
 *     group: "1234",
 *     policyProject: my_policy_project.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * # This resource can be used to attach a security policy to a pre-existing group
 * foo = gitlab.GroupSecurityPolicyAttachment("foo",
 *     group="1234",
 *     policy_project="4567")
 * # Or you can use Terraform to create a new project, add a policy to that project,
 * # then attach that policy project to other groups.
 * my_policy_project = gitlab.Project("my-policy-project", name="security-policy-project")
 * policy_yml = gitlab.RepositoryFile("policy-yml",
 *     project=my_policy_project.id,
 *     file_path=".gitlab/security-policies/my-policy.yml",
 *     branch="master",
 *     encoding="text",
 *     content="""---
 * approval_policy:
 * - name: test
 * description: test
 * enabled: true
 * rules:
 * - type: any_merge_request
 *     branch_type: protected
 *     commits: any
 * approval_settings:
 *     block_branch_modification: true
 *     prevent_pushing_and_force_pushing: true
 *     prevent_approval_by_author: true
 *     prevent_approval_by_commit_author: true
 *     remove_approvals_with_new_commit: true
 *     require_password_to_approve: false
 * fallback_behavior:
 *     fail: closed
 * actions:
 * - type: send_bot_message
 *     enabled: true
 * """)
 * my_policy = gitlab.GroupSecurityPolicyAttachment("my-policy",
 *     group="1234",
 *     policy_project=my_policy_project.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     // This resource can be used to attach a security policy to a pre-existing group
 *     var foo = new GitLab.GroupSecurityPolicyAttachment("foo", new()
 *     {
 *         Group = "1234",
 *         PolicyProject = "4567",
 *     });
 *     // Or you can use Terraform to create a new project, add a policy to that project,
 *     // then attach that policy project to other groups.
 *     var my_policy_project = new GitLab.Project("my-policy-project", new()
 *     {
 *         Name = "security-policy-project",
 *     });
 *     var policy_yml = new GitLab.RepositoryFile("policy-yml", new()
 *     {
 *         Project = my_policy_project.Id,
 *         FilePath = ".gitlab/security-policies/my-policy.yml",
 *         Branch = "master",
 *         Encoding = "text",
 *         Content = @"---
 * approval_policy:
 * - name: test
 * description: test
 * enabled: true
 * rules:
 * - type: any_merge_request
 *     branch_type: protected
 *     commits: any
 * approval_settings:
 *     block_branch_modification: true
 *     prevent_pushing_and_force_pushing: true
 *     prevent_approval_by_author: true
 *     prevent_approval_by_commit_author: true
 *     remove_approvals_with_new_commit: true
 *     require_password_to_approve: false
 * fallback_behavior:
 *     fail: closed
 * actions:
 * - type: send_bot_message
 *     enabled: true
 * ",
 *     });
 *     var my_policy = new GitLab.GroupSecurityPolicyAttachment("my-policy", new()
 *     {
 *         Group = "1234",
 *         PolicyProject = my_policy_project.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// This resource can be used to attach a security policy to a pre-existing group
 * 		_, err := gitlab.NewGroupSecurityPolicyAttachment(ctx, "foo", &gitlab.GroupSecurityPolicyAttachmentArgs{
 * 			Group:         pulumi.String("1234"),
 * 			PolicyProject: pulumi.String("4567"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Or you can use Terraform to create a new project, add a policy to that project,
 * 		// then attach that policy project to other groups.
 * 		_, err = gitlab.NewProject(ctx, "my-policy-project", &gitlab.ProjectArgs{
 * 			Name: pulumi.String("security-policy-project"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewRepositoryFile(ctx, "policy-yml", &gitlab.RepositoryFileArgs{
 * 			Project:  my_policy_project.ID(),
 * 			FilePath: pulumi.String(".gitlab/security-policies/my-policy.yml"),
 * 			Branch:   pulumi.String("master"),
 * 			Encoding: pulumi.String("text"),
 * 			Content: pulumi.String(`---
 * approval_policy:
 * - name: test
 * description: test
 * enabled: true
 * rules:
 * - type: any_merge_request
 *     branch_type: protected
 *     commits: any
 * approval_settings:
 *     block_branch_modification: true
 *     prevent_pushing_and_force_pushing: true
 *     prevent_approval_by_author: true
 *     prevent_approval_by_commit_author: true
 *     remove_approvals_with_new_commit: true
 *     require_password_to_approve: false
 * fallback_behavior:
 *     fail: closed
 * actions:
 * - type: send_bot_message
 *     enabled: true
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewGroupSecurityPolicyAttachment(ctx, "my-policy", &gitlab.GroupSecurityPolicyAttachmentArgs{
 * 			Group:         pulumi.String("1234"),
 * 			PolicyProject: my_policy_project.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupSecurityPolicyAttachment;
 * import com.pulumi.gitlab.GroupSecurityPolicyAttachmentArgs;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.RepositoryFile;
 * import com.pulumi.gitlab.RepositoryFileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // This resource can be used to attach a security policy to a pre-existing group
 *         var foo = new GroupSecurityPolicyAttachment("foo", GroupSecurityPolicyAttachmentArgs.builder()
 *             .group(1234)
 *             .policyProject(4567)
 *             .build());
 *         // Or you can use Terraform to create a new project, add a policy to that project,
 *         // then attach that policy project to other groups.
 *         var my_policy_project = new Project("my-policy-project", ProjectArgs.builder()
 *             .name("security-policy-project")
 *             .build());
 *         var policy_yml = new RepositoryFile("policy-yml", RepositoryFileArgs.builder()
 *             .project(my_policy_project.id())
 *             .filePath(".gitlab/security-policies/my-policy.yml")
 *             .branch("master")
 *             .encoding("text")
 *             .content("""
 * ---
 * approval_policy:
 * - name: test
 * description: test
 * enabled: true
 * rules:
 * - type: any_merge_request
 *     branch_type: protected
 *     commits: any
 * approval_settings:
 *     block_branch_modification: true
 *     prevent_pushing_and_force_pushing: true
 *     prevent_approval_by_author: true
 *     prevent_approval_by_commit_author: true
 *     remove_approvals_with_new_commit: true
 *     require_password_to_approve: false
 * fallback_behavior:
 *     fail: closed
 * actions:
 * - type: send_bot_message
 *     enabled: true
 *             """)
 *             .build());
 *         var my_policy = new GroupSecurityPolicyAttachment("my-policy", GroupSecurityPolicyAttachmentArgs.builder()
 *             .group(1234)
 *             .policyProject(my_policy_project.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # This resource can be used to attach a security policy to a pre-existing group
 *   foo:
 *     type: gitlab:GroupSecurityPolicyAttachment
 *     properties:
 *       group: 1234
 *       policyProject: 4567
 *   # Or you can use Terraform to create a new project, add a policy to that project,
 *   # then attach that policy project to other groups.
 *   my-policy-project:
 *     type: gitlab:Project
 *     properties:
 *       name: security-policy-project
 *   policy-yml:
 *     type: gitlab:RepositoryFile
 *     properties:
 *       project: ${["my-policy-project"].id}
 *       filePath: .gitlab/security-policies/my-policy.yml
 *       branch: master
 *       encoding: text
 *       content: |
 *         ---
 *         approval_policy:
 *         - name: test
 *         description: test
 *         enabled: true
 *         rules:
 *         - type: any_merge_request
 *             branch_type: protected
 *             commits: any
 *         approval_settings:
 *             block_branch_modification: true
 *             prevent_pushing_and_force_pushing: true
 *             prevent_approval_by_author: true
 *             prevent_approval_by_commit_author: true
 *             remove_approvals_with_new_commit: true
 *             require_password_to_approve: false
 *         fallback_behavior:
 *             fail: closed
 *         actions:
 *         - type: send_bot_message
 *             enabled: true
 *   my-policy:
 *     type: gitlab:GroupSecurityPolicyAttachment
 *     properties:
 *       group: 1234
 *       policyProject: ${["my-policy-project"].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab group security policy attachments can be imported using an id made up of `group:policy_project_id` where the policy project ID is the project ID of the policy project, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupSecurityPolicyAttachment:GroupSecurityPolicyAttachment foo 1:2
 * ```
 */
public class GroupSecurityPolicyAttachment internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupSecurityPolicyAttachment,
) : KotlinCustomResource(javaResource, GroupSecurityPolicyAttachmentMapper) {
    /**
     * The ID or Full Path of the group which will have the security policy project assigned to it.
     */
    public val group: Output<String>
        get() = javaResource.group().applyValue({ args0 -> args0 })

    /**
     * The GraphQL ID of the group to which the security policty project will be attached.
     */
    public val groupGraphqlId: Output<String>
        get() = javaResource.groupGraphqlId().applyValue({ args0 -> args0 })

    /**
     * The ID or Full Path of the security policy project.
     */
    public val policyProject: Output<String>
        get() = javaResource.policyProject().applyValue({ args0 -> args0 })

    /**
     * The GraphQL ID of the security policy project.
     */
    public val policyProjectGraphqlId: Output<String>
        get() = javaResource.policyProjectGraphqlId().applyValue({ args0 -> args0 })
}

public object GroupSecurityPolicyAttachmentMapper : ResourceMapper<GroupSecurityPolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupSecurityPolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): GroupSecurityPolicyAttachment =
        GroupSecurityPolicyAttachment(javaResource as com.pulumi.gitlab.GroupSecurityPolicyAttachment)
}

/**
 * @see [GroupSecurityPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupSecurityPolicyAttachment].
 */
public suspend fun groupSecurityPolicyAttachment(
    name: String,
    block: suspend GroupSecurityPolicyAttachmentResourceBuilder.() -> Unit,
): GroupSecurityPolicyAttachment {
    val builder = GroupSecurityPolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupSecurityPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupSecurityPolicyAttachment(name: String): GroupSecurityPolicyAttachment {
    val builder = GroupSecurityPolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
