@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupShareGroup].
 */
@PulumiTagMarker
public class GroupShareGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupShareGroupArgs = GroupShareGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupShareGroupArgsBuilder.() -> Unit) {
        val builder = GroupShareGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupShareGroup {
        val builtJavaResource = com.pulumi.gitlab.GroupShareGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupShareGroup(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupShareGroup` resource allows to manage the lifecycle of group shared with another group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#share-groups-with-groups)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const test = new gitlab.GroupShareGroup("test", {
 *     groupId: foo.id,
 *     shareGroupId: bar.id,
 *     groupAccess: "guest",
 *     expiresAt: "2099-01-01",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * test = gitlab.GroupShareGroup("test",
 *     group_id=foo["id"],
 *     share_group_id=bar["id"],
 *     group_access="guest",
 *     expires_at="2099-01-01")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new GitLab.GroupShareGroup("test", new()
 *     {
 *         GroupId = foo.Id,
 *         ShareGroupId = bar.Id,
 *         GroupAccess = "guest",
 *         ExpiresAt = "2099-01-01",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupShareGroup(ctx, "test", &gitlab.GroupShareGroupArgs{
 * 			GroupId:      pulumi.Any(foo.Id),
 * 			ShareGroupId: pulumi.Any(bar.Id),
 * 			GroupAccess:  pulumi.String("guest"),
 * 			ExpiresAt:    pulumi.String("2099-01-01"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupShareGroup;
 * import com.pulumi.gitlab.GroupShareGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new GroupShareGroup("test", GroupShareGroupArgs.builder()
 *             .groupId(foo.id())
 *             .shareGroupId(bar.id())
 *             .groupAccess("guest")
 *             .expiresAt("2099-01-01")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: gitlab:GroupShareGroup
 *     properties:
 *       groupId: ${foo.id}
 *       shareGroupId: ${bar.id}
 *       groupAccess: guest
 *       expiresAt: 2099-01-01
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab group shares can be imported using an id made up of `mainGroupId:shareGroupId`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupShareGroup:GroupShareGroup test 12345:1337
 * ```
 */
public class GroupShareGroup internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupShareGroup,
) : KotlinCustomResource(javaResource, GroupShareGroupMapper) {
    /**
     * Share expiration date. Format: `YYYY-MM-DD`
     */
    public val expiresAt: Output<String>?
        get() = javaResource.expiresAt().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The access level to grant the group. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    public val groupAccess: Output<String>
        get() = javaResource.groupAccess().applyValue({ args0 -> args0 })

    /**
     * The id of the main group to be shared.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The id of the additional group with which the main group will be shared.
     */
    public val shareGroupId: Output<Int>
        get() = javaResource.shareGroupId().applyValue({ args0 -> args0 })
}

public object GroupShareGroupMapper : ResourceMapper<GroupShareGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupShareGroup::class == javaResource::class

    override fun map(javaResource: Resource): GroupShareGroup = GroupShareGroup(
        javaResource as
            com.pulumi.gitlab.GroupShareGroup,
    )
}

/**
 * @see [GroupShareGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupShareGroup].
 */
public suspend fun groupShareGroup(
    name: String,
    block: suspend GroupShareGroupResourceBuilder.() -> Unit,
): GroupShareGroup {
    val builder = GroupShareGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupShareGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupShareGroup(name: String): GroupShareGroup {
    val builder = GroupShareGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
