@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupShareGroupArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupShareGroup` resource allows to manage the lifecycle of group shared with another group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#share-groups-with-groups)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const test = new gitlab.GroupShareGroup("test", {
 *     groupId: foo.id,
 *     shareGroupId: bar.id,
 *     groupAccess: "guest",
 *     expiresAt: "2099-01-01",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * test = gitlab.GroupShareGroup("test",
 *     group_id=foo["id"],
 *     share_group_id=bar["id"],
 *     group_access="guest",
 *     expires_at="2099-01-01")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new GitLab.GroupShareGroup("test", new()
 *     {
 *         GroupId = foo.Id,
 *         ShareGroupId = bar.Id,
 *         GroupAccess = "guest",
 *         ExpiresAt = "2099-01-01",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupShareGroup(ctx, "test", &gitlab.GroupShareGroupArgs{
 * 			GroupId:      pulumi.Any(foo.Id),
 * 			ShareGroupId: pulumi.Any(bar.Id),
 * 			GroupAccess:  pulumi.String("guest"),
 * 			ExpiresAt:    pulumi.String("2099-01-01"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupShareGroup;
 * import com.pulumi.gitlab.GroupShareGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new GroupShareGroup("test", GroupShareGroupArgs.builder()
 *             .groupId(foo.id())
 *             .shareGroupId(bar.id())
 *             .groupAccess("guest")
 *             .expiresAt("2099-01-01")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: gitlab:GroupShareGroup
 *     properties:
 *       groupId: ${foo.id}
 *       shareGroupId: ${bar.id}
 *       groupAccess: guest
 *       expiresAt: 2099-01-01
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab group shares can be imported using an id made up of `mainGroupId:shareGroupId`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupShareGroup:GroupShareGroup test 12345:1337
 * ```
 * @property expiresAt Share expiration date. Format: `YYYY-MM-DD`
 * @property groupAccess The access level to grant the group. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
 * @property groupId The id of the main group to be shared.
 * @property shareGroupId The id of the additional group with which the main group will be shared.
 */
public data class GroupShareGroupArgs(
    public val expiresAt: Output<String>? = null,
    public val groupAccess: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val shareGroupId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupShareGroupArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupShareGroupArgs =
        com.pulumi.gitlab.GroupShareGroupArgs.builder()
            .expiresAt(expiresAt?.applyValue({ args0 -> args0 }))
            .groupAccess(groupAccess?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .shareGroupId(shareGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupShareGroupArgs].
 */
@PulumiTagMarker
public class GroupShareGroupArgsBuilder internal constructor() {
    private var expiresAt: Output<String>? = null

    private var groupAccess: Output<String>? = null

    private var groupId: Output<String>? = null

    private var shareGroupId: Output<Int>? = null

    /**
     * @param value Share expiration date. Format: `YYYY-MM-DD`
     */
    @JvmName("rvjsroforkofkoei")
    public suspend fun expiresAt(`value`: Output<String>) {
        this.expiresAt = value
    }

    /**
     * @param value The access level to grant the group. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    @JvmName("yrhrukrksesxrpek")
    public suspend fun groupAccess(`value`: Output<String>) {
        this.groupAccess = value
    }

    /**
     * @param value The id of the main group to be shared.
     */
    @JvmName("cnbixpowtygksqmf")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The id of the additional group with which the main group will be shared.
     */
    @JvmName("jpvgurqrjbjehevi")
    public suspend fun shareGroupId(`value`: Output<Int>) {
        this.shareGroupId = value
    }

    /**
     * @param value Share expiration date. Format: `YYYY-MM-DD`
     */
    @JvmName("nypattsfutsjriqb")
    public suspend fun expiresAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiresAt = mapped
    }

    /**
     * @param value The access level to grant the group. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    @JvmName("iedcyluapfgphmbj")
    public suspend fun groupAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupAccess = mapped
    }

    /**
     * @param value The id of the main group to be shared.
     */
    @JvmName("cbvmnkgfwsghjfxd")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The id of the additional group with which the main group will be shared.
     */
    @JvmName("nxcdghrkvnumnivt")
    public suspend fun shareGroupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareGroupId = mapped
    }

    internal fun build(): GroupShareGroupArgs = GroupShareGroupArgs(
        expiresAt = expiresAt,
        groupAccess = groupAccess,
        groupId = groupId,
        shareGroupId = shareGroupId,
    )
}
