@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupVariable].
 */
@PulumiTagMarker
public class GroupVariableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupVariableArgs = GroupVariableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupVariableArgsBuilder.() -> Unit) {
        val builder = GroupVariableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupVariable {
        val builtJavaResource = com.pulumi.gitlab.GroupVariable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupVariable(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupVariable` resource allows to manage the lifecycle of a CI/CD variable for a group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/group_level_variables.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.GroupVariable("example", {
 *     group: "12345",
 *     key: "group_variable_key",
 *     value: "group_variable_value",
 *     "protected": false,
 *     masked: false,
 *     environmentScope: "*",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.GroupVariable("example",
 *     group="12345",
 *     key="group_variable_key",
 *     value="group_variable_value",
 *     protected=False,
 *     masked=False,
 *     environment_scope="*")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.GroupVariable("example", new()
 *     {
 *         Group = "12345",
 *         Key = "group_variable_key",
 *         Value = "group_variable_value",
 *         Protected = false,
 *         Masked = false,
 *         EnvironmentScope = "*",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupVariable(ctx, "example", &gitlab.GroupVariableArgs{
 * 			Group:            pulumi.String("12345"),
 * 			Key:              pulumi.String("group_variable_key"),
 * 			Value:            pulumi.String("group_variable_value"),
 * 			Protected:        pulumi.Bool(false),
 * 			Masked:           pulumi.Bool(false),
 * 			EnvironmentScope: pulumi.String("*"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupVariable;
 * import com.pulumi.gitlab.GroupVariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupVariable("example", GroupVariableArgs.builder()
 *             .group("12345")
 *             .key("group_variable_key")
 *             .value("group_variable_value")
 *             .protected_(false)
 *             .masked(false)
 *             .environmentScope("*")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:GroupVariable
 *     properties:
 *       group: '12345'
 *       key: group_variable_key
 *       value: group_variable_value
 *       protected: false
 *       masked: false
 *       environmentScope: '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab group variables can be imported using an id made up of `groupid:variablename:scope`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupVariable:GroupVariable example 12345:group_variable_key:*
 * ```
 */
public class GroupVariable internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupVariable,
) : KotlinCustomResource(javaResource, GroupVariableMapper) {
    /**
     * The description of the variable.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
     */
    public val environmentScope: Output<String>?
        get() = javaResource.environmentScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name or id of the group.
     */
    public val group: Output<String>
        get() = javaResource.group().applyValue({ args0 -> args0 })

    /**
     * The name of the variable.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
     */
    public val masked: Output<Boolean>?
        get() = javaResource.masked().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
     */
    public val `protected`: Output<Boolean>?
        get() = javaResource.protected_().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
     */
    public val raw: Output<Boolean>?
        get() = javaResource.raw().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The value of the variable.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })

    /**
     * The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
     */
    public val variableType: Output<String>?
        get() = javaResource.variableType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object GroupVariableMapper : ResourceMapper<GroupVariable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupVariable::class == javaResource::class

    override fun map(javaResource: Resource): GroupVariable = GroupVariable(
        javaResource as
            com.pulumi.gitlab.GroupVariable,
    )
}

/**
 * @see [GroupVariable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupVariable].
 */
public suspend fun groupVariable(
    name: String,
    block: suspend GroupVariableResourceBuilder.() -> Unit,
): GroupVariable {
    val builder = GroupVariableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupVariable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupVariable(name: String): GroupVariable {
    val builder = GroupVariableResourceBuilder()
    builder.name(name)
    return builder.build()
}
