@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupVariableArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupVariable` resource allows to manage the lifecycle of a CI/CD variable for a group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/group_level_variables.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.GroupVariable("example", {
 *     group: "12345",
 *     key: "group_variable_key",
 *     value: "group_variable_value",
 *     "protected": false,
 *     masked: false,
 *     environmentScope: "*",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.GroupVariable("example",
 *     group="12345",
 *     key="group_variable_key",
 *     value="group_variable_value",
 *     protected=False,
 *     masked=False,
 *     environment_scope="*")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.GroupVariable("example", new()
 *     {
 *         Group = "12345",
 *         Key = "group_variable_key",
 *         Value = "group_variable_value",
 *         Protected = false,
 *         Masked = false,
 *         EnvironmentScope = "*",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupVariable(ctx, "example", &gitlab.GroupVariableArgs{
 * 			Group:            pulumi.String("12345"),
 * 			Key:              pulumi.String("group_variable_key"),
 * 			Value:            pulumi.String("group_variable_value"),
 * 			Protected:        pulumi.Bool(false),
 * 			Masked:           pulumi.Bool(false),
 * 			EnvironmentScope: pulumi.String("*"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupVariable;
 * import com.pulumi.gitlab.GroupVariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupVariable("example", GroupVariableArgs.builder()
 *             .group("12345")
 *             .key("group_variable_key")
 *             .value("group_variable_value")
 *             .protected_(false)
 *             .masked(false)
 *             .environmentScope("*")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:GroupVariable
 *     properties:
 *       group: '12345'
 *       key: group_variable_key
 *       value: group_variable_value
 *       protected: false
 *       masked: false
 *       environmentScope: '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab group variables can be imported using an id made up of `groupid:variablename:scope`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupVariable:GroupVariable example 12345:group_variable_key:*
 * ```
 * @property description The description of the variable.
 * @property environmentScope The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
 * @property group The name or id of the group.
 * @property key The name of the variable.
 * @property masked If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
 * @property protected If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
 * @property raw Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
 * @property value The value of the variable.
 * @property variableType The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
 */
public data class GroupVariableArgs(
    public val description: Output<String>? = null,
    public val environmentScope: Output<String>? = null,
    public val group: Output<String>? = null,
    public val key: Output<String>? = null,
    public val masked: Output<Boolean>? = null,
    public val `protected`: Output<Boolean>? = null,
    public val raw: Output<Boolean>? = null,
    public val `value`: Output<String>? = null,
    public val variableType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupVariableArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupVariableArgs =
        com.pulumi.gitlab.GroupVariableArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentScope(environmentScope?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .masked(masked?.applyValue({ args0 -> args0 }))
            .protected_(`protected`?.applyValue({ args0 -> args0 }))
            .raw(raw?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .variableType(variableType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupVariableArgs].
 */
@PulumiTagMarker
public class GroupVariableArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var environmentScope: Output<String>? = null

    private var group: Output<String>? = null

    private var key: Output<String>? = null

    private var masked: Output<Boolean>? = null

    private var `protected`: Output<Boolean>? = null

    private var raw: Output<Boolean>? = null

    private var `value`: Output<String>? = null

    private var variableType: Output<String>? = null

    /**
     * @param value The description of the variable.
     */
    @JvmName("wfqigbjmwloopiqu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
     */
    @JvmName("vuupeoeajwllsypf")
    public suspend fun environmentScope(`value`: Output<String>) {
        this.environmentScope = value
    }

    /**
     * @param value The name or id of the group.
     */
    @JvmName("ugdalphdqixhqyqv")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value The name of the variable.
     */
    @JvmName("fjruxtgwscxjyqqn")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
     */
    @JvmName("fcxpedmkkkhrenje")
    public suspend fun masked(`value`: Output<Boolean>) {
        this.masked = value
    }

    /**
     * @param value If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
     */
    @JvmName("pooipsidyvskvecs")
    public suspend fun `protected`(`value`: Output<Boolean>) {
        this.`protected` = value
    }

    /**
     * @param value Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
     */
    @JvmName("nbussfrifysfadst")
    public suspend fun raw(`value`: Output<Boolean>) {
        this.raw = value
    }

    /**
     * @param value The value of the variable.
     */
    @JvmName("icgjixwghgpteskf")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
     */
    @JvmName("lmewmqfbeftjdakt")
    public suspend fun variableType(`value`: Output<String>) {
        this.variableType = value
    }

    /**
     * @param value The description of the variable.
     */
    @JvmName("qylsoacrrsqwbpkb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
     */
    @JvmName("cnspvkpdaxjlwnet")
    public suspend fun environmentScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentScope = mapped
    }

    /**
     * @param value The name or id of the group.
     */
    @JvmName("uvterynsnxwirdnq")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value The name of the variable.
     */
    @JvmName("qpojwlnojhthycjm")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
     */
    @JvmName("hoggxamxbvsjyrtr")
    public suspend fun masked(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masked = mapped
    }

    /**
     * @param value If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
     */
    @JvmName("lmajcjsqbmeoparc")
    public suspend fun `protected`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`protected` = mapped
    }

    /**
     * @param value Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
     */
    @JvmName("tjvssnisejuxwoly")
    public suspend fun raw(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raw = mapped
    }

    /**
     * @param value The value of the variable.
     */
    @JvmName("faejclhtklpuuylv")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
     */
    @JvmName("vwenhdygbjfdfvng")
    public suspend fun variableType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variableType = mapped
    }

    internal fun build(): GroupVariableArgs = GroupVariableArgs(
        description = description,
        environmentScope = environmentScope,
        group = group,
        key = key,
        masked = masked,
        `protected` = `protected`,
        raw = raw,
        `value` = `value`,
        variableType = variableType,
    )
}
