@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InstanceCluster].
 */
@PulumiTagMarker
public class InstanceClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceClusterArgs = InstanceClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceClusterArgsBuilder.() -> Unit) {
        val builder = InstanceClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InstanceCluster {
        val builtJavaResource = com.pulumi.gitlab.InstanceCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstanceCluster(builtJavaResource)
    }
}

/**
 * The `gitlab.InstanceCluster` resource allows to manage the lifecycle of an instance cluster.
 * > This is deprecated GitLab feature since 14.5
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/instance_clusters.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const bar = new gitlab.InstanceCluster("bar", {
 *     name: "bar-cluster",
 *     domain: "example.com",
 *     enabled: true,
 *     kubernetesApiUrl: "https://124.124.124",
 *     kubernetesToken: "some-token",
 *     kubernetesCaCert: "some-cert",
 *     kubernetesNamespace: "namespace",
 *     kubernetesAuthorizationType: "rbac",
 *     environmentScope: "*",
 *     managementProjectId: "123456",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * bar = gitlab.InstanceCluster("bar",
 *     name="bar-cluster",
 *     domain="example.com",
 *     enabled=True,
 *     kubernetes_api_url="https://124.124.124",
 *     kubernetes_token="some-token",
 *     kubernetes_ca_cert="some-cert",
 *     kubernetes_namespace="namespace",
 *     kubernetes_authorization_type="rbac",
 *     environment_scope="*",
 *     management_project_id="123456")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new GitLab.InstanceCluster("bar", new()
 *     {
 *         Name = "bar-cluster",
 *         Domain = "example.com",
 *         Enabled = true,
 *         KubernetesApiUrl = "https://124.124.124",
 *         KubernetesToken = "some-token",
 *         KubernetesCaCert = "some-cert",
 *         KubernetesNamespace = "namespace",
 *         KubernetesAuthorizationType = "rbac",
 *         EnvironmentScope = "*",
 *         ManagementProjectId = "123456",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewInstanceCluster(ctx, "bar", &gitlab.InstanceClusterArgs{
 * 			Name:                        pulumi.String("bar-cluster"),
 * 			Domain:                      pulumi.String("example.com"),
 * 			Enabled:                     pulumi.Bool(true),
 * 			KubernetesApiUrl:            pulumi.String("https://124.124.124"),
 * 			KubernetesToken:             pulumi.String("some-token"),
 * 			KubernetesCaCert:            pulumi.String("some-cert"),
 * 			KubernetesNamespace:         pulumi.String("namespace"),
 * 			KubernetesAuthorizationType: pulumi.String("rbac"),
 * 			EnvironmentScope:            pulumi.String("*"),
 * 			ManagementProjectId:         pulumi.String("123456"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.InstanceCluster;
 * import com.pulumi.gitlab.InstanceClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new InstanceCluster("bar", InstanceClusterArgs.builder()
 *             .name("bar-cluster")
 *             .domain("example.com")
 *             .enabled(true)
 *             .kubernetesApiUrl("https://124.124.124")
 *             .kubernetesToken("some-token")
 *             .kubernetesCaCert("some-cert")
 *             .kubernetesNamespace("namespace")
 *             .kubernetesAuthorizationType("rbac")
 *             .environmentScope("*")
 *             .managementProjectId("123456")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: gitlab:InstanceCluster
 *     properties:
 *       name: bar-cluster
 *       domain: example.com
 *       enabled: true
 *       kubernetesApiUrl: https://124.124.124
 *       kubernetesToken: some-token
 *       kubernetesCaCert: some-cert
 *       kubernetesNamespace: namespace
 *       kubernetesAuthorizationType: rbac
 *       environmentScope: '*'
 *       managementProjectId: '123456'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab instance clusters can be imported using a `clusterid`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/instanceCluster:InstanceCluster bar 123
 * ```
 */
public class InstanceCluster internal constructor(
    override val javaResource: com.pulumi.gitlab.InstanceCluster,
) : KotlinCustomResource(javaResource, InstanceClusterMapper) {
    /**
     * Cluster type.
     */
    public val clusterType: Output<String>
        get() = javaResource.clusterType().applyValue({ args0 -> args0 })

    /**
     * Create time.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The base domain of the cluster.
     */
    public val domain: Output<String>?
        get() = javaResource.domain().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Determines if cluster is active or not. Defaults to `true`. This attribute cannot be read.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The associated environment to the cluster. Defaults to `*`.
     */
    public val environmentScope: Output<String>?
        get() = javaResource.environmentScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URL to access the Kubernetes API.
     */
    public val kubernetesApiUrl: Output<String>
        get() = javaResource.kubernetesApiUrl().applyValue({ args0 -> args0 })

    /**
     * The cluster authorization type. Valid values are `rbac`, `abac`, `unknown_authorization`. Defaults to `rbac`.
     */
    public val kubernetesAuthorizationType: Output<String>?
        get() = javaResource.kubernetesAuthorizationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * TLS certificate (needed if API is using a self-signed TLS certificate).
     */
    public val kubernetesCaCert: Output<String>?
        get() = javaResource.kubernetesCaCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique namespace related to the instance.
     */
    public val kubernetesNamespace: Output<String>?
        get() = javaResource.kubernetesNamespace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The token to authenticate against Kubernetes. This attribute cannot be read.
     */
    public val kubernetesToken: Output<String>
        get() = javaResource.kubernetesToken().applyValue({ args0 -> args0 })

    /**
     * Determines if cluster is managed by gitlab or not. Defaults to `true`. This attribute cannot be read.
     */
    public val managed: Output<Boolean>?
        get() = javaResource.managed().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the management project for the cluster.
     */
    public val managementProjectId: Output<String>?
        get() = javaResource.managementProjectId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of cluster.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Platform type.
     */
    public val platformType: Output<String>
        get() = javaResource.platformType().applyValue({ args0 -> args0 })

    /**
     * Provider type.
     */
    public val providerType: Output<String>
        get() = javaResource.providerType().applyValue({ args0 -> args0 })
}

public object InstanceClusterMapper : ResourceMapper<InstanceCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.InstanceCluster::class == javaResource::class

    override fun map(javaResource: Resource): InstanceCluster = InstanceCluster(
        javaResource as
            com.pulumi.gitlab.InstanceCluster,
    )
}

/**
 * @see [InstanceCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceCluster].
 */
public suspend fun instanceCluster(
    name: String,
    block: suspend InstanceClusterResourceBuilder.() -> Unit,
): InstanceCluster {
    val builder = InstanceClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceCluster(name: String): InstanceCluster {
    val builder = InstanceClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
