@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.InstanceClusterArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.InstanceCluster` resource allows to manage the lifecycle of an instance cluster.
 * > This is deprecated GitLab feature since 14.5
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/instance_clusters.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const bar = new gitlab.InstanceCluster("bar", {
 *     name: "bar-cluster",
 *     domain: "example.com",
 *     enabled: true,
 *     kubernetesApiUrl: "https://124.124.124",
 *     kubernetesToken: "some-token",
 *     kubernetesCaCert: "some-cert",
 *     kubernetesNamespace: "namespace",
 *     kubernetesAuthorizationType: "rbac",
 *     environmentScope: "*",
 *     managementProjectId: "123456",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * bar = gitlab.InstanceCluster("bar",
 *     name="bar-cluster",
 *     domain="example.com",
 *     enabled=True,
 *     kubernetes_api_url="https://124.124.124",
 *     kubernetes_token="some-token",
 *     kubernetes_ca_cert="some-cert",
 *     kubernetes_namespace="namespace",
 *     kubernetes_authorization_type="rbac",
 *     environment_scope="*",
 *     management_project_id="123456")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new GitLab.InstanceCluster("bar", new()
 *     {
 *         Name = "bar-cluster",
 *         Domain = "example.com",
 *         Enabled = true,
 *         KubernetesApiUrl = "https://124.124.124",
 *         KubernetesToken = "some-token",
 *         KubernetesCaCert = "some-cert",
 *         KubernetesNamespace = "namespace",
 *         KubernetesAuthorizationType = "rbac",
 *         EnvironmentScope = "*",
 *         ManagementProjectId = "123456",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewInstanceCluster(ctx, "bar", &gitlab.InstanceClusterArgs{
 * 			Name:                        pulumi.String("bar-cluster"),
 * 			Domain:                      pulumi.String("example.com"),
 * 			Enabled:                     pulumi.Bool(true),
 * 			KubernetesApiUrl:            pulumi.String("https://124.124.124"),
 * 			KubernetesToken:             pulumi.String("some-token"),
 * 			KubernetesCaCert:            pulumi.String("some-cert"),
 * 			KubernetesNamespace:         pulumi.String("namespace"),
 * 			KubernetesAuthorizationType: pulumi.String("rbac"),
 * 			EnvironmentScope:            pulumi.String("*"),
 * 			ManagementProjectId:         pulumi.String("123456"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.InstanceCluster;
 * import com.pulumi.gitlab.InstanceClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new InstanceCluster("bar", InstanceClusterArgs.builder()
 *             .name("bar-cluster")
 *             .domain("example.com")
 *             .enabled(true)
 *             .kubernetesApiUrl("https://124.124.124")
 *             .kubernetesToken("some-token")
 *             .kubernetesCaCert("some-cert")
 *             .kubernetesNamespace("namespace")
 *             .kubernetesAuthorizationType("rbac")
 *             .environmentScope("*")
 *             .managementProjectId("123456")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: gitlab:InstanceCluster
 *     properties:
 *       name: bar-cluster
 *       domain: example.com
 *       enabled: true
 *       kubernetesApiUrl: https://124.124.124
 *       kubernetesToken: some-token
 *       kubernetesCaCert: some-cert
 *       kubernetesNamespace: namespace
 *       kubernetesAuthorizationType: rbac
 *       environmentScope: '*'
 *       managementProjectId: '123456'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab instance clusters can be imported using a `clusterid`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/instanceCluster:InstanceCluster bar 123
 * ```
 * @property domain The base domain of the cluster.
 * @property enabled Determines if cluster is active or not. Defaults to `true`. This attribute cannot be read.
 * @property environmentScope The associated environment to the cluster. Defaults to `*`.
 * @property kubernetesApiUrl The URL to access the Kubernetes API.
 * @property kubernetesAuthorizationType The cluster authorization type. Valid values are `rbac`, `abac`, `unknown_authorization`. Defaults to `rbac`.
 * @property kubernetesCaCert TLS certificate (needed if API is using a self-signed TLS certificate).
 * @property kubernetesNamespace The unique namespace related to the instance.
 * @property kubernetesToken The token to authenticate against Kubernetes. This attribute cannot be read.
 * @property managed Determines if cluster is managed by gitlab or not. Defaults to `true`. This attribute cannot be read.
 * @property managementProjectId The ID of the management project for the cluster.
 * @property name The name of cluster.
 */
public data class InstanceClusterArgs(
    public val domain: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val environmentScope: Output<String>? = null,
    public val kubernetesApiUrl: Output<String>? = null,
    public val kubernetesAuthorizationType: Output<String>? = null,
    public val kubernetesCaCert: Output<String>? = null,
    public val kubernetesNamespace: Output<String>? = null,
    public val kubernetesToken: Output<String>? = null,
    public val managed: Output<Boolean>? = null,
    public val managementProjectId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.InstanceClusterArgs> {
    override fun toJava(): com.pulumi.gitlab.InstanceClusterArgs =
        com.pulumi.gitlab.InstanceClusterArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .environmentScope(environmentScope?.applyValue({ args0 -> args0 }))
            .kubernetesApiUrl(kubernetesApiUrl?.applyValue({ args0 -> args0 }))
            .kubernetesAuthorizationType(kubernetesAuthorizationType?.applyValue({ args0 -> args0 }))
            .kubernetesCaCert(kubernetesCaCert?.applyValue({ args0 -> args0 }))
            .kubernetesNamespace(kubernetesNamespace?.applyValue({ args0 -> args0 }))
            .kubernetesToken(kubernetesToken?.applyValue({ args0 -> args0 }))
            .managed(managed?.applyValue({ args0 -> args0 }))
            .managementProjectId(managementProjectId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceClusterArgs].
 */
@PulumiTagMarker
public class InstanceClusterArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var environmentScope: Output<String>? = null

    private var kubernetesApiUrl: Output<String>? = null

    private var kubernetesAuthorizationType: Output<String>? = null

    private var kubernetesCaCert: Output<String>? = null

    private var kubernetesNamespace: Output<String>? = null

    private var kubernetesToken: Output<String>? = null

    private var managed: Output<Boolean>? = null

    private var managementProjectId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The base domain of the cluster.
     */
    @JvmName("tmfmhtlhscalkjur")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value Determines if cluster is active or not. Defaults to `true`. This attribute cannot be read.
     */
    @JvmName("mqkxwffhceluaqhc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The associated environment to the cluster. Defaults to `*`.
     */
    @JvmName("tocqxbwmnxdcbqqi")
    public suspend fun environmentScope(`value`: Output<String>) {
        this.environmentScope = value
    }

    /**
     * @param value The URL to access the Kubernetes API.
     */
    @JvmName("cmgqnogeiofphmhg")
    public suspend fun kubernetesApiUrl(`value`: Output<String>) {
        this.kubernetesApiUrl = value
    }

    /**
     * @param value The cluster authorization type. Valid values are `rbac`, `abac`, `unknown_authorization`. Defaults to `rbac`.
     */
    @JvmName("mhtqpractllyniwj")
    public suspend fun kubernetesAuthorizationType(`value`: Output<String>) {
        this.kubernetesAuthorizationType = value
    }

    /**
     * @param value TLS certificate (needed if API is using a self-signed TLS certificate).
     */
    @JvmName("xymsjontlbwithfi")
    public suspend fun kubernetesCaCert(`value`: Output<String>) {
        this.kubernetesCaCert = value
    }

    /**
     * @param value The unique namespace related to the instance.
     */
    @JvmName("gmdwkhvgnkjtnxij")
    public suspend fun kubernetesNamespace(`value`: Output<String>) {
        this.kubernetesNamespace = value
    }

    /**
     * @param value The token to authenticate against Kubernetes. This attribute cannot be read.
     */
    @JvmName("rysomnfrwaphgwki")
    public suspend fun kubernetesToken(`value`: Output<String>) {
        this.kubernetesToken = value
    }

    /**
     * @param value Determines if cluster is managed by gitlab or not. Defaults to `true`. This attribute cannot be read.
     */
    @JvmName("xejcduqydvdhgctw")
    public suspend fun managed(`value`: Output<Boolean>) {
        this.managed = value
    }

    /**
     * @param value The ID of the management project for the cluster.
     */
    @JvmName("qhbfjqnxecfjwlst")
    public suspend fun managementProjectId(`value`: Output<String>) {
        this.managementProjectId = value
    }

    /**
     * @param value The name of cluster.
     */
    @JvmName("fsgiggqijmyitlph")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The base domain of the cluster.
     */
    @JvmName("digesgxgdcsheuhx")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value Determines if cluster is active or not. Defaults to `true`. This attribute cannot be read.
     */
    @JvmName("vqxiqyhwdduehumx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The associated environment to the cluster. Defaults to `*`.
     */
    @JvmName("fihkultaiuurnlqu")
    public suspend fun environmentScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentScope = mapped
    }

    /**
     * @param value The URL to access the Kubernetes API.
     */
    @JvmName("uandutrbqxsropdq")
    public suspend fun kubernetesApiUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesApiUrl = mapped
    }

    /**
     * @param value The cluster authorization type. Valid values are `rbac`, `abac`, `unknown_authorization`. Defaults to `rbac`.
     */
    @JvmName("mkkbhbvntacdoffo")
    public suspend fun kubernetesAuthorizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesAuthorizationType = mapped
    }

    /**
     * @param value TLS certificate (needed if API is using a self-signed TLS certificate).
     */
    @JvmName("rnrafwyoviowrlie")
    public suspend fun kubernetesCaCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesCaCert = mapped
    }

    /**
     * @param value The unique namespace related to the instance.
     */
    @JvmName("ntoemtrbnvjmdxlr")
    public suspend fun kubernetesNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesNamespace = mapped
    }

    /**
     * @param value The token to authenticate against Kubernetes. This attribute cannot be read.
     */
    @JvmName("qvggrtvkhsfpddre")
    public suspend fun kubernetesToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesToken = mapped
    }

    /**
     * @param value Determines if cluster is managed by gitlab or not. Defaults to `true`. This attribute cannot be read.
     */
    @JvmName("qosnedkgetcaawxe")
    public suspend fun managed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managed = mapped
    }

    /**
     * @param value The ID of the management project for the cluster.
     */
    @JvmName("rfnkgsodcxynirbd")
    public suspend fun managementProjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementProjectId = mapped
    }

    /**
     * @param value The name of cluster.
     */
    @JvmName("hseqiboyuaqpyyij")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): InstanceClusterArgs = InstanceClusterArgs(
        domain = domain,
        enabled = enabled,
        environmentScope = environmentScope,
        kubernetesApiUrl = kubernetesApiUrl,
        kubernetesAuthorizationType = kubernetesAuthorizationType,
        kubernetesCaCert = kubernetesCaCert,
        kubernetesNamespace = kubernetesNamespace,
        kubernetesToken = kubernetesToken,
        managed = managed,
        managementProjectId = managementProjectId,
        name = name,
    )
}
