@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InstanceVariable].
 */
@PulumiTagMarker
public class InstanceVariableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceVariableArgs = InstanceVariableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceVariableArgsBuilder.() -> Unit) {
        val builder = InstanceVariableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InstanceVariable {
        val builtJavaResource = com.pulumi.gitlab.InstanceVariable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstanceVariable(builtJavaResource)
    }
}

/**
 * The `gitlab.InstanceVariable` resource allows to manage the lifecycle of an instance-level CI/CD variable.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/instance_level_ci_variables.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.InstanceVariable("example", {
 *     key: "instance_variable_key",
 *     value: "instance_variable_value",
 *     "protected": false,
 *     masked: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.InstanceVariable("example",
 *     key="instance_variable_key",
 *     value="instance_variable_value",
 *     protected=False,
 *     masked=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.InstanceVariable("example", new()
 *     {
 *         Key = "instance_variable_key",
 *         Value = "instance_variable_value",
 *         Protected = false,
 *         Masked = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewInstanceVariable(ctx, "example", &gitlab.InstanceVariableArgs{
 * 			Key:       pulumi.String("instance_variable_key"),
 * 			Value:     pulumi.String("instance_variable_value"),
 * 			Protected: pulumi.Bool(false),
 * 			Masked:    pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.InstanceVariable;
 * import com.pulumi.gitlab.InstanceVariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceVariable("example", InstanceVariableArgs.builder()
 *             .key("instance_variable_key")
 *             .value("instance_variable_value")
 *             .protected_(false)
 *             .masked(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:InstanceVariable
 *     properties:
 *       key: instance_variable_key
 *       value: instance_variable_value
 *       protected: false
 *       masked: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab instance variables can be imported using an id made up of `variablename`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/instanceVariable:InstanceVariable example instance_variable_key
 * ```
 */
public class InstanceVariable internal constructor(
    override val javaResource: com.pulumi.gitlab.InstanceVariable,
) : KotlinCustomResource(javaResource, InstanceVariableMapper) {
    /**
     * The description of the variable. Maximum of 255 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the variable.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
     */
    public val masked: Output<Boolean>?
        get() = javaResource.masked().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
     */
    public val `protected`: Output<Boolean>?
        get() = javaResource.protected_().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
     */
    public val raw: Output<Boolean>?
        get() = javaResource.raw().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The value of the variable.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })

    /**
     * The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
     */
    public val variableType: Output<String>?
        get() = javaResource.variableType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object InstanceVariableMapper : ResourceMapper<InstanceVariable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.InstanceVariable::class == javaResource::class

    override fun map(javaResource: Resource): InstanceVariable = InstanceVariable(
        javaResource as
            com.pulumi.gitlab.InstanceVariable,
    )
}

/**
 * @see [InstanceVariable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceVariable].
 */
public suspend fun instanceVariable(
    name: String,
    block: suspend InstanceVariableResourceBuilder.() -> Unit,
): InstanceVariable {
    val builder = InstanceVariableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceVariable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceVariable(name: String): InstanceVariable {
    val builder = InstanceVariableResourceBuilder()
    builder.name(name)
    return builder.build()
}
