@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.InstanceVariableArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.InstanceVariable` resource allows to manage the lifecycle of an instance-level CI/CD variable.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/instance_level_ci_variables.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.InstanceVariable("example", {
 *     key: "instance_variable_key",
 *     value: "instance_variable_value",
 *     "protected": false,
 *     masked: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.InstanceVariable("example",
 *     key="instance_variable_key",
 *     value="instance_variable_value",
 *     protected=False,
 *     masked=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.InstanceVariable("example", new()
 *     {
 *         Key = "instance_variable_key",
 *         Value = "instance_variable_value",
 *         Protected = false,
 *         Masked = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewInstanceVariable(ctx, "example", &gitlab.InstanceVariableArgs{
 * 			Key:       pulumi.String("instance_variable_key"),
 * 			Value:     pulumi.String("instance_variable_value"),
 * 			Protected: pulumi.Bool(false),
 * 			Masked:    pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.InstanceVariable;
 * import com.pulumi.gitlab.InstanceVariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceVariable("example", InstanceVariableArgs.builder()
 *             .key("instance_variable_key")
 *             .value("instance_variable_value")
 *             .protected_(false)
 *             .masked(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:InstanceVariable
 *     properties:
 *       key: instance_variable_key
 *       value: instance_variable_value
 *       protected: false
 *       masked: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab instance variables can be imported using an id made up of `variablename`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/instanceVariable:InstanceVariable example instance_variable_key
 * ```
 * @property description The description of the variable. Maximum of 255 characters.
 * @property key The name of the variable.
 * @property masked If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
 * @property protected If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
 * @property raw Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
 * @property value The value of the variable.
 * @property variableType The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
 */
public data class InstanceVariableArgs(
    public val description: Output<String>? = null,
    public val key: Output<String>? = null,
    public val masked: Output<Boolean>? = null,
    public val `protected`: Output<Boolean>? = null,
    public val raw: Output<Boolean>? = null,
    public val `value`: Output<String>? = null,
    public val variableType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.InstanceVariableArgs> {
    override fun toJava(): com.pulumi.gitlab.InstanceVariableArgs =
        com.pulumi.gitlab.InstanceVariableArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .masked(masked?.applyValue({ args0 -> args0 }))
            .protected_(`protected`?.applyValue({ args0 -> args0 }))
            .raw(raw?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .variableType(variableType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceVariableArgs].
 */
@PulumiTagMarker
public class InstanceVariableArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var key: Output<String>? = null

    private var masked: Output<Boolean>? = null

    private var `protected`: Output<Boolean>? = null

    private var raw: Output<Boolean>? = null

    private var `value`: Output<String>? = null

    private var variableType: Output<String>? = null

    /**
     * @param value The description of the variable. Maximum of 255 characters.
     */
    @JvmName("hvhdqmcfmqpjpnfa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the variable.
     */
    @JvmName("cdylrctbpqsxppkd")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
     */
    @JvmName("gxyprcoagsmiollt")
    public suspend fun masked(`value`: Output<Boolean>) {
        this.masked = value
    }

    /**
     * @param value If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
     */
    @JvmName("iijmswxyjfwnxreq")
    public suspend fun `protected`(`value`: Output<Boolean>) {
        this.`protected` = value
    }

    /**
     * @param value Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
     */
    @JvmName("dqescyntodboredb")
    public suspend fun raw(`value`: Output<Boolean>) {
        this.raw = value
    }

    /**
     * @param value The value of the variable.
     */
    @JvmName("qusdonwyxxvrcrqw")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
     */
    @JvmName("oeonlhxvvvplgoeh")
    public suspend fun variableType(`value`: Output<String>) {
        this.variableType = value
    }

    /**
     * @param value The description of the variable. Maximum of 255 characters.
     */
    @JvmName("xcruddwlxdkmkpwy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the variable.
     */
    @JvmName("nslokbmcamqtxlps")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
     */
    @JvmName("qjdjosrulyfootty")
    public suspend fun masked(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masked = mapped
    }

    /**
     * @param value If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
     */
    @JvmName("vmncqqpqblqdnnsm")
    public suspend fun `protected`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`protected` = mapped
    }

    /**
     * @param value Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
     */
    @JvmName("gxcqlgiyddmkdkjv")
    public suspend fun raw(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raw = mapped
    }

    /**
     * @param value The value of the variable.
     */
    @JvmName("gppteankkwmxdhfh")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
     */
    @JvmName("oyhnabfxyhyolyiw")
    public suspend fun variableType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variableType = mapped
    }

    internal fun build(): InstanceVariableArgs = InstanceVariableArgs(
        description = description,
        key = key,
        masked = masked,
        `protected` = `protected`,
        raw = raw,
        `value` = `value`,
        variableType = variableType,
    )
}
