@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IntegrationCustomIssueTracker].
 */
@PulumiTagMarker
public class IntegrationCustomIssueTrackerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationCustomIssueTrackerArgs = IntegrationCustomIssueTrackerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationCustomIssueTrackerArgsBuilder.() -> Unit) {
        val builder = IntegrationCustomIssueTrackerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationCustomIssueTracker {
        val builtJavaResource = com.pulumi.gitlab.IntegrationCustomIssueTracker(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationCustomIssueTracker(builtJavaResource)
    }
}

/**
 * The `gitlab.IntegrationCustomIssueTracker` resource allows to manage the lifecycle of a project integration with Custom Issue Tracker.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#custom-issue-tracker)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const tracker = new gitlab.IntegrationCustomIssueTracker("tracker", {
 *     project: awesomeProject.id,
 *     projectUrl: "https://customtracker.com/issues",
 *     issuesUrl: "https://customtracker.com/TEST-:id",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * tracker = gitlab.IntegrationCustomIssueTracker("tracker",
 *     project=awesome_project.id,
 *     project_url="https://customtracker.com/issues",
 *     issues_url="https://customtracker.com/TEST-:id")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var tracker = new GitLab.IntegrationCustomIssueTracker("tracker", new()
 *     {
 *         Project = awesomeProject.Id,
 *         ProjectUrl = "https://customtracker.com/issues",
 *         IssuesUrl = "https://customtracker.com/TEST-:id",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationCustomIssueTracker(ctx, "tracker", &gitlab.IntegrationCustomIssueTrackerArgs{
 * 			Project:    awesomeProject.ID(),
 * 			ProjectUrl: pulumi.String("https://customtracker.com/issues"),
 * 			IssuesUrl:  pulumi.String("https://customtracker.com/TEST-:id"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationCustomIssueTracker;
 * import com.pulumi.gitlab.IntegrationCustomIssueTrackerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var tracker = new IntegrationCustomIssueTracker("tracker", IntegrationCustomIssueTrackerArgs.builder()
 *             .project(awesomeProject.id())
 *             .projectUrl("https://customtracker.com/issues")
 *             .issuesUrl("https://customtracker.com/TEST-:id")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   tracker:
 *     type: gitlab:IntegrationCustomIssueTracker
 *     properties:
 *       project: ${awesomeProject.id}
 *       projectUrl: https://customtracker.com/issues
 *       issuesUrl: https://customtracker.com/TEST-:id
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_integration_custom_issue_tracker state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/integrationCustomIssueTracker:IntegrationCustomIssueTracker tracker 1
 * ```
 */
public class IntegrationCustomIssueTracker internal constructor(
    override val javaResource: com.pulumi.gitlab.IntegrationCustomIssueTracker,
) : KotlinCustomResource(javaResource, IntegrationCustomIssueTrackerMapper) {
    /**
     * Whether the integration is active.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * The ISO8601 date/time that this integration was activated at in UTC.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The URL to view an issue in the external issue tracker. Must contain :id.
     */
    public val issuesUrl: Output<String>
        get() = javaResource.issuesUrl().applyValue({ args0 -> args0 })

    /**
     * The ID or full path of the project for the custom issue tracker.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The URL to the project in the external issue tracker.
     */
    public val projectUrl: Output<String>
        get() = javaResource.projectUrl().applyValue({ args0 -> args0 })

    /**
     * The name of the integration in lowercase, shortened to 63 bytes, and with everything except 0-9 and a-z replaced with -. No leading / trailing -. Use in URLs, host names and domain names.
     */
    public val slug: Output<String>
        get() = javaResource.slug().applyValue({ args0 -> args0 })

    /**
     * The ISO8601 date/time that this integration was last updated at in UTC.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object IntegrationCustomIssueTrackerMapper : ResourceMapper<IntegrationCustomIssueTracker> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.IntegrationCustomIssueTracker::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationCustomIssueTracker =
        IntegrationCustomIssueTracker(javaResource as com.pulumi.gitlab.IntegrationCustomIssueTracker)
}

/**
 * @see [IntegrationCustomIssueTracker].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationCustomIssueTracker].
 */
public suspend fun integrationCustomIssueTracker(
    name: String,
    block: suspend IntegrationCustomIssueTrackerResourceBuilder.() -> Unit,
): IntegrationCustomIssueTracker {
    val builder = IntegrationCustomIssueTrackerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationCustomIssueTracker].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationCustomIssueTracker(name: String): IntegrationCustomIssueTracker {
    val builder = IntegrationCustomIssueTrackerResourceBuilder()
    builder.name(name)
    return builder.build()
}
