@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IntegrationEmailsOnPush].
 */
@PulumiTagMarker
public class IntegrationEmailsOnPushResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationEmailsOnPushArgs = IntegrationEmailsOnPushArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationEmailsOnPushArgsBuilder.() -> Unit) {
        val builder = IntegrationEmailsOnPushArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationEmailsOnPush {
        val builtJavaResource = com.pulumi.gitlab.IntegrationEmailsOnPush(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationEmailsOnPush(builtJavaResource)
    }
}

/**
 * The `gitlab.IntegrationEmailsOnPush` resource allows to manage the lifecycle of a project integration with Emails on Push Service.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#emails-on-push)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const emails = new gitlab.IntegrationEmailsOnPush("emails", {
 *     project: awesomeProject.id,
 *     recipients: "myrecipient@example.com myotherrecipient@example.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * emails = gitlab.IntegrationEmailsOnPush("emails",
 *     project=awesome_project.id,
 *     recipients="myrecipient@example.com myotherrecipient@example.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var emails = new GitLab.IntegrationEmailsOnPush("emails", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Recipients = "myrecipient@example.com myotherrecipient@example.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationEmailsOnPush(ctx, "emails", &gitlab.IntegrationEmailsOnPushArgs{
 * 			Project:    awesomeProject.ID(),
 * 			Recipients: pulumi.String("myrecipient@example.com myotherrecipient@example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationEmailsOnPush;
 * import com.pulumi.gitlab.IntegrationEmailsOnPushArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var emails = new IntegrationEmailsOnPush("emails", IntegrationEmailsOnPushArgs.builder()
 *             .project(awesomeProject.id())
 *             .recipients("myrecipient@example.com myotherrecipient@example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   emails:
 *     type: gitlab:IntegrationEmailsOnPush
 *     properties:
 *       project: ${awesomeProject.id}
 *       recipients: myrecipient@example.com myotherrecipient@example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_integration_emails_on_push state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/integrationEmailsOnPush:IntegrationEmailsOnPush emails 1
 * ```
 */
public class IntegrationEmailsOnPush internal constructor(
    override val javaResource: com.pulumi.gitlab.IntegrationEmailsOnPush,
) : KotlinCustomResource(javaResource, IntegrationEmailsOnPushMapper) {
    /**
     * Whether the integration is active.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * Branches to send notifications for. Valid options are `all`, `default`, `protected`, `default_and_protected`. Notifications are always fired for tag pushes.
     */
    public val branchesToBeNotified: Output<String>?
        get() = javaResource.branchesToBeNotified().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ISO8601 date/time that this integration was activated at in UTC.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Disable code diffs.
     */
    public val disableDiffs: Output<Boolean>?
        get() = javaResource.disableDiffs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID or full-path of the project you want to activate integration on.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for push events.
     */
    public val pushEvents: Output<Boolean>?
        get() = javaResource.pushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Emails separated by whitespace.
     */
    public val recipients: Output<String>
        get() = javaResource.recipients().applyValue({ args0 -> args0 })

    /**
     * Send from committer.
     */
    public val sendFromCommitterEmail: Output<Boolean>?
        get() = javaResource.sendFromCommitterEmail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the integration in lowercase, shortened to 63 bytes, and with everything except 0-9 and a-z replaced with -. No leading / trailing -. Use in URLs, host names and domain names.
     */
    public val slug: Output<String>
        get() = javaResource.slug().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for tag push events.
     */
    public val tagPushEvents: Output<Boolean>?
        get() = javaResource.tagPushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Title of the integration.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The ISO8601 date/time that this integration was last updated at in UTC.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object IntegrationEmailsOnPushMapper : ResourceMapper<IntegrationEmailsOnPush> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.IntegrationEmailsOnPush::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationEmailsOnPush =
        IntegrationEmailsOnPush(javaResource as com.pulumi.gitlab.IntegrationEmailsOnPush)
}

/**
 * @see [IntegrationEmailsOnPush].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationEmailsOnPush].
 */
public suspend fun integrationEmailsOnPush(
    name: String,
    block: suspend IntegrationEmailsOnPushResourceBuilder.() -> Unit,
): IntegrationEmailsOnPush {
    val builder = IntegrationEmailsOnPushResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationEmailsOnPush].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationEmailsOnPush(name: String): IntegrationEmailsOnPush {
    val builder = IntegrationEmailsOnPushResourceBuilder()
    builder.name(name)
    return builder.build()
}
