@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IntegrationExternalWiki].
 */
@PulumiTagMarker
public class IntegrationExternalWikiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationExternalWikiArgs = IntegrationExternalWikiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationExternalWikiArgsBuilder.() -> Unit) {
        val builder = IntegrationExternalWikiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationExternalWiki {
        val builtJavaResource = com.pulumi.gitlab.IntegrationExternalWiki(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationExternalWiki(builtJavaResource)
    }
}

/**
 * The `gitlab.IntegrationExternalWiki` resource allows to manage the lifecycle of a project integration with External Wiki Service.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#external-wiki)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const wiki = new gitlab.IntegrationExternalWiki("wiki", {
 *     project: awesomeProject.id,
 *     externalWikiUrl: "https://MyAwesomeExternalWikiURL.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * wiki = gitlab.IntegrationExternalWiki("wiki",
 *     project=awesome_project.id,
 *     external_wiki_url="https://MyAwesomeExternalWikiURL.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var wiki = new GitLab.IntegrationExternalWiki("wiki", new()
 *     {
 *         Project = awesomeProject.Id,
 *         ExternalWikiUrl = "https://MyAwesomeExternalWikiURL.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationExternalWiki(ctx, "wiki", &gitlab.IntegrationExternalWikiArgs{
 * 			Project:         awesomeProject.ID(),
 * 			ExternalWikiUrl: pulumi.String("https://MyAwesomeExternalWikiURL.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationExternalWiki;
 * import com.pulumi.gitlab.IntegrationExternalWikiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var wiki = new IntegrationExternalWiki("wiki", IntegrationExternalWikiArgs.builder()
 *             .project(awesomeProject.id())
 *             .externalWikiUrl("https://MyAwesomeExternalWikiURL.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   wiki:
 *     type: gitlab:IntegrationExternalWiki
 *     properties:
 *       project: ${awesomeProject.id}
 *       externalWikiUrl: https://MyAwesomeExternalWikiURL.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_integration_external_wiki state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/integrationExternalWiki:IntegrationExternalWiki wiki 1
 * ```
 */
public class IntegrationExternalWiki internal constructor(
    override val javaResource: com.pulumi.gitlab.IntegrationExternalWiki,
) : KotlinCustomResource(javaResource, IntegrationExternalWikiMapper) {
    /**
     * Whether the integration is active.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * The ISO8601 date/time that this integration was activated at in UTC.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The URL of the external wiki.
     */
    public val externalWikiUrl: Output<String>
        get() = javaResource.externalWikiUrl().applyValue({ args0 -> args0 })

    /**
     * ID of the project you want to activate integration on.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The name of the integration in lowercase, shortened to 63 bytes, and with everything except 0-9 and a-z replaced with -. No leading / trailing -. Use in URLs, host names and domain names.
     */
    public val slug: Output<String>
        get() = javaResource.slug().applyValue({ args0 -> args0 })

    /**
     * Title of the integration.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The ISO8601 date/time that this integration was last updated at in UTC.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object IntegrationExternalWikiMapper : ResourceMapper<IntegrationExternalWiki> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.IntegrationExternalWiki::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationExternalWiki =
        IntegrationExternalWiki(javaResource as com.pulumi.gitlab.IntegrationExternalWiki)
}

/**
 * @see [IntegrationExternalWiki].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationExternalWiki].
 */
public suspend fun integrationExternalWiki(
    name: String,
    block: suspend IntegrationExternalWikiResourceBuilder.() -> Unit,
): IntegrationExternalWiki {
    val builder = IntegrationExternalWikiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationExternalWiki].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationExternalWiki(name: String): IntegrationExternalWiki {
    val builder = IntegrationExternalWikiResourceBuilder()
    builder.name(name)
    return builder.build()
}
