@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IntegrationJenkins].
 */
@PulumiTagMarker
public class IntegrationJenkinsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationJenkinsArgs = IntegrationJenkinsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationJenkinsArgsBuilder.() -> Unit) {
        val builder = IntegrationJenkinsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationJenkins {
        val builtJavaResource = com.pulumi.gitlab.IntegrationJenkins(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationJenkins(builtJavaResource)
    }
}

/**
 * The `gitlab.IntegrationJenkins` resource allows to manage the lifecycle of a project integration with Jenkins.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#jenkins)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const jenkins = new gitlab.IntegrationJenkins("jenkins", {
 *     project: awesomeProject.id,
 *     jenkinsUrl: "http://jenkins.example.com",
 *     projectName: "my_project_name",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * jenkins = gitlab.IntegrationJenkins("jenkins",
 *     project=awesome_project.id,
 *     jenkins_url="http://jenkins.example.com",
 *     project_name="my_project_name")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var jenkins = new GitLab.IntegrationJenkins("jenkins", new()
 *     {
 *         Project = awesomeProject.Id,
 *         JenkinsUrl = "http://jenkins.example.com",
 *         ProjectName = "my_project_name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationJenkins(ctx, "jenkins", &gitlab.IntegrationJenkinsArgs{
 * 			Project:     awesomeProject.ID(),
 * 			JenkinsUrl:  pulumi.String("http://jenkins.example.com"),
 * 			ProjectName: pulumi.String("my_project_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationJenkins;
 * import com.pulumi.gitlab.IntegrationJenkinsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var jenkins = new IntegrationJenkins("jenkins", IntegrationJenkinsArgs.builder()
 *             .project(awesomeProject.id())
 *             .jenkinsUrl("http://jenkins.example.com")
 *             .projectName("my_project_name")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   jenkins:
 *     type: gitlab:IntegrationJenkins
 *     properties:
 *       project: ${awesomeProject.id}
 *       jenkinsUrl: http://jenkins.example.com
 *       projectName: my_project_name
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ```sh
 * $ pulumi import gitlab:index/integrationJenkins:IntegrationJenkins You can import a gitlab_integration_jenkins state using `<resource> <project_id>`:
 * ```
 * ```sh
 * $ pulumi import gitlab:index/integrationJenkins:IntegrationJenkins jenkins 1
 * ```
 */
public class IntegrationJenkins internal constructor(
    override val javaResource: com.pulumi.gitlab.IntegrationJenkins,
) : KotlinCustomResource(javaResource, IntegrationJenkinsMapper) {
    /**
     * Whether the integration is active.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * Enable SSL verification. Defaults to `true` (enabled).
     */
    public val enableSslVerification: Output<Boolean>
        get() = javaResource.enableSslVerification().applyValue({ args0 -> args0 })

    /**
     * Jenkins URL like `http://jenkins.example.com`
     */
    public val jenkinsUrl: Output<String>
        get() = javaResource.jenkinsUrl().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for merge request events.
     */
    public val mergeRequestEvents: Output<Boolean>
        get() = javaResource.mergeRequestEvents().applyValue({ args0 -> args0 })

    /**
     * Password for authentication with the Jenkins server, if authentication is required by the server.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ID of the project you want to activate integration on.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The URL-friendly project name. Example: `my_project_name`.
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for push events.
     */
    public val pushEvents: Output<Boolean>
        get() = javaResource.pushEvents().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for tag push events.
     */
    public val tagPushEvents: Output<Boolean>
        get() = javaResource.tagPushEvents().applyValue({ args0 -> args0 })

    /**
     * Username for authentication with the Jenkins server, if authentication is required by the server.
     */
    public val username: Output<String>?
        get() = javaResource.username().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object IntegrationJenkinsMapper : ResourceMapper<IntegrationJenkins> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.IntegrationJenkins::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationJenkins = IntegrationJenkins(
        javaResource as
            com.pulumi.gitlab.IntegrationJenkins,
    )
}

/**
 * @see [IntegrationJenkins].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationJenkins].
 */
public suspend fun integrationJenkins(
    name: String,
    block: suspend IntegrationJenkinsResourceBuilder.() -> Unit,
): IntegrationJenkins {
    val builder = IntegrationJenkinsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationJenkins].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationJenkins(name: String): IntegrationJenkins {
    val builder = IntegrationJenkinsResourceBuilder()
    builder.name(name)
    return builder.build()
}
