@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.IntegrationJenkinsArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.IntegrationJenkins` resource allows to manage the lifecycle of a project integration with Jenkins.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#jenkins)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const jenkins = new gitlab.IntegrationJenkins("jenkins", {
 *     project: awesomeProject.id,
 *     jenkinsUrl: "http://jenkins.example.com",
 *     projectName: "my_project_name",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * jenkins = gitlab.IntegrationJenkins("jenkins",
 *     project=awesome_project.id,
 *     jenkins_url="http://jenkins.example.com",
 *     project_name="my_project_name")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var jenkins = new GitLab.IntegrationJenkins("jenkins", new()
 *     {
 *         Project = awesomeProject.Id,
 *         JenkinsUrl = "http://jenkins.example.com",
 *         ProjectName = "my_project_name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationJenkins(ctx, "jenkins", &gitlab.IntegrationJenkinsArgs{
 * 			Project:     awesomeProject.ID(),
 * 			JenkinsUrl:  pulumi.String("http://jenkins.example.com"),
 * 			ProjectName: pulumi.String("my_project_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationJenkins;
 * import com.pulumi.gitlab.IntegrationJenkinsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var jenkins = new IntegrationJenkins("jenkins", IntegrationJenkinsArgs.builder()
 *             .project(awesomeProject.id())
 *             .jenkinsUrl("http://jenkins.example.com")
 *             .projectName("my_project_name")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   jenkins:
 *     type: gitlab:IntegrationJenkins
 *     properties:
 *       project: ${awesomeProject.id}
 *       jenkinsUrl: http://jenkins.example.com
 *       projectName: my_project_name
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ```sh
 * $ pulumi import gitlab:index/integrationJenkins:IntegrationJenkins You can import a gitlab_integration_jenkins state using `<resource> <project_id>`:
 * ```
 * ```sh
 * $ pulumi import gitlab:index/integrationJenkins:IntegrationJenkins jenkins 1
 * ```
 * @property enableSslVerification Enable SSL verification. Defaults to `true` (enabled).
 * @property jenkinsUrl Jenkins URL like `http://jenkins.example.com`
 * @property mergeRequestEvents Enable notifications for merge request events.
 * @property password Password for authentication with the Jenkins server, if authentication is required by the server.
 * @property project ID of the project you want to activate integration on.
 * @property projectName The URL-friendly project name. Example: `my_project_name`.
 * @property pushEvents Enable notifications for push events.
 * @property tagPushEvents Enable notifications for tag push events.
 * @property username Username for authentication with the Jenkins server, if authentication is required by the server.
 */
public data class IntegrationJenkinsArgs(
    public val enableSslVerification: Output<Boolean>? = null,
    public val jenkinsUrl: Output<String>? = null,
    public val mergeRequestEvents: Output<Boolean>? = null,
    public val password: Output<String>? = null,
    public val project: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val pushEvents: Output<Boolean>? = null,
    public val tagPushEvents: Output<Boolean>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.IntegrationJenkinsArgs> {
    override fun toJava(): com.pulumi.gitlab.IntegrationJenkinsArgs =
        com.pulumi.gitlab.IntegrationJenkinsArgs.builder()
            .enableSslVerification(enableSslVerification?.applyValue({ args0 -> args0 }))
            .jenkinsUrl(jenkinsUrl?.applyValue({ args0 -> args0 }))
            .mergeRequestEvents(mergeRequestEvents?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .pushEvents(pushEvents?.applyValue({ args0 -> args0 }))
            .tagPushEvents(tagPushEvents?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationJenkinsArgs].
 */
@PulumiTagMarker
public class IntegrationJenkinsArgsBuilder internal constructor() {
    private var enableSslVerification: Output<Boolean>? = null

    private var jenkinsUrl: Output<String>? = null

    private var mergeRequestEvents: Output<Boolean>? = null

    private var password: Output<String>? = null

    private var project: Output<String>? = null

    private var projectName: Output<String>? = null

    private var pushEvents: Output<Boolean>? = null

    private var tagPushEvents: Output<Boolean>? = null

    private var username: Output<String>? = null

    /**
     * @param value Enable SSL verification. Defaults to `true` (enabled).
     */
    @JvmName("woabvkqvkwnnqfcq")
    public suspend fun enableSslVerification(`value`: Output<Boolean>) {
        this.enableSslVerification = value
    }

    /**
     * @param value Jenkins URL like `http://jenkins.example.com`
     */
    @JvmName("ajydywjwhryuyjfp")
    public suspend fun jenkinsUrl(`value`: Output<String>) {
        this.jenkinsUrl = value
    }

    /**
     * @param value Enable notifications for merge request events.
     */
    @JvmName("axxcmjrwblcqqkqh")
    public suspend fun mergeRequestEvents(`value`: Output<Boolean>) {
        this.mergeRequestEvents = value
    }

    /**
     * @param value Password for authentication with the Jenkins server, if authentication is required by the server.
     */
    @JvmName("bljptdsklbhbsxqd")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value ID of the project you want to activate integration on.
     */
    @JvmName("vbypflbtrsucrwrl")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The URL-friendly project name. Example: `my_project_name`.
     */
    @JvmName("fbjqggcakkglpxmi")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Enable notifications for push events.
     */
    @JvmName("fkxnugouddiaqose")
    public suspend fun pushEvents(`value`: Output<Boolean>) {
        this.pushEvents = value
    }

    /**
     * @param value Enable notifications for tag push events.
     */
    @JvmName("kxhbskgnhwtajiom")
    public suspend fun tagPushEvents(`value`: Output<Boolean>) {
        this.tagPushEvents = value
    }

    /**
     * @param value Username for authentication with the Jenkins server, if authentication is required by the server.
     */
    @JvmName("exylkcatmxnmixxv")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Enable SSL verification. Defaults to `true` (enabled).
     */
    @JvmName("ocbsowyxlsgihvir")
    public suspend fun enableSslVerification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSslVerification = mapped
    }

    /**
     * @param value Jenkins URL like `http://jenkins.example.com`
     */
    @JvmName("ujdegavqggchvgqx")
    public suspend fun jenkinsUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jenkinsUrl = mapped
    }

    /**
     * @param value Enable notifications for merge request events.
     */
    @JvmName("vrykbwwkjwcpxrsh")
    public suspend fun mergeRequestEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestEvents = mapped
    }

    /**
     * @param value Password for authentication with the Jenkins server, if authentication is required by the server.
     */
    @JvmName("lbchekowsksujouv")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value ID of the project you want to activate integration on.
     */
    @JvmName("fjttbysoqdqeskha")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The URL-friendly project name. Example: `my_project_name`.
     */
    @JvmName("odnqjpvedmkhotia")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Enable notifications for push events.
     */
    @JvmName("yurtdadqptvodfuy")
    public suspend fun pushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEvents = mapped
    }

    /**
     * @param value Enable notifications for tag push events.
     */
    @JvmName("stmqkdcmhakexxfo")
    public suspend fun tagPushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagPushEvents = mapped
    }

    /**
     * @param value Username for authentication with the Jenkins server, if authentication is required by the server.
     */
    @JvmName("ygedpvohfyrgrjot")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): IntegrationJenkinsArgs = IntegrationJenkinsArgs(
        enableSslVerification = enableSslVerification,
        jenkinsUrl = jenkinsUrl,
        mergeRequestEvents = mergeRequestEvents,
        password = password,
        project = project,
        projectName = projectName,
        pushEvents = pushEvents,
        tagPushEvents = tagPushEvents,
        username = username,
    )
}
