@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IntegrationMattermost].
 */
@PulumiTagMarker
public class IntegrationMattermostResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationMattermostArgs = IntegrationMattermostArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationMattermostArgsBuilder.() -> Unit) {
        val builder = IntegrationMattermostArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationMattermost {
        val builtJavaResource = com.pulumi.gitlab.IntegrationMattermost(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationMattermost(builtJavaResource)
    }
}

/**
 * The `gitlab.IntegrationMattermost` resource allows to manage the lifecycle of a project integration with Mattermost.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#mattermost-notifications)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const mattermost = new gitlab.IntegrationMattermost("mattermost", {
 *     project: awesomeProject.id,
 *     webhook: "https://webhook.com",
 *     username: "myuser",
 *     pushEvents: true,
 *     pushChannel: "push_chan",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * mattermost = gitlab.IntegrationMattermost("mattermost",
 *     project=awesome_project.id,
 *     webhook="https://webhook.com",
 *     username="myuser",
 *     push_events=True,
 *     push_channel="push_chan")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var mattermost = new GitLab.IntegrationMattermost("mattermost", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Webhook = "https://webhook.com",
 *         Username = "myuser",
 *         PushEvents = true,
 *         PushChannel = "push_chan",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationMattermost(ctx, "mattermost", &gitlab.IntegrationMattermostArgs{
 * 			Project:     awesomeProject.ID(),
 * 			Webhook:     pulumi.String("https://webhook.com"),
 * 			Username:    pulumi.String("myuser"),
 * 			PushEvents:  pulumi.Bool(true),
 * 			PushChannel: pulumi.String("push_chan"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationMattermost;
 * import com.pulumi.gitlab.IntegrationMattermostArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var mattermost = new IntegrationMattermost("mattermost", IntegrationMattermostArgs.builder()
 *             .project(awesomeProject.id())
 *             .webhook("https://webhook.com")
 *             .username("myuser")
 *             .pushEvents(true)
 *             .pushChannel("push_chan")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   mattermost:
 *     type: gitlab:IntegrationMattermost
 *     properties:
 *       project: ${awesomeProject.id}
 *       webhook: https://webhook.com
 *       username: myuser
 *       pushEvents: true
 *       pushChannel: push_chan
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_integration_mattermost.mattermost state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/integrationMattermost:IntegrationMattermost mattermost 1
 * ```
 */
public class IntegrationMattermost internal constructor(
    override val javaResource: com.pulumi.gitlab.IntegrationMattermost,
) : KotlinCustomResource(javaResource, IntegrationMattermostMapper) {
    /**
     * Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
     */
    public val branchesToBeNotified: Output<String>
        get() = javaResource.branchesToBeNotified().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive confidential issue events notifications.
     */
    public val confidentialIssueChannel: Output<String>?
        get() = javaResource.confidentialIssueChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for confidential issues events.
     */
    public val confidentialIssuesEvents: Output<Boolean>
        get() = javaResource.confidentialIssuesEvents().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive confidential note events notifications.
     */
    public val confidentialNoteChannel: Output<String>?
        get() = javaResource.confidentialNoteChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for confidential note events.
     */
    public val confidentialNoteEvents: Output<Boolean>
        get() = javaResource.confidentialNoteEvents().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive issue events notifications.
     */
    public val issueChannel: Output<String>?
        get() = javaResource.issueChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for issues events.
     */
    public val issuesEvents: Output<Boolean>
        get() = javaResource.issuesEvents().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive merge request events notifications.
     */
    public val mergeRequestChannel: Output<String>?
        get() = javaResource.mergeRequestChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for merge requests events.
     */
    public val mergeRequestsEvents: Output<Boolean>
        get() = javaResource.mergeRequestsEvents().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive note events notifications.
     */
    public val noteChannel: Output<String>?
        get() = javaResource.noteChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for note events.
     */
    public val noteEvents: Output<Boolean>
        get() = javaResource.noteEvents().applyValue({ args0 -> args0 })

    /**
     * Send notifications for broken pipelines.
     */
    public val notifyOnlyBrokenPipelines: Output<Boolean>
        get() = javaResource.notifyOnlyBrokenPipelines().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive pipeline events notifications.
     */
    public val pipelineChannel: Output<String>?
        get() = javaResource.pipelineChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for pipeline events.
     */
    public val pipelineEvents: Output<Boolean>
        get() = javaResource.pipelineEvents().applyValue({ args0 -> args0 })

    /**
     * ID of the project you want to activate integration on.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive push events notifications.
     */
    public val pushChannel: Output<String>?
        get() = javaResource.pushChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for push events.
     */
    public val pushEvents: Output<Boolean>
        get() = javaResource.pushEvents().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive tag push events notifications.
     */
    public val tagPushChannel: Output<String>?
        get() = javaResource.tagPushChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for tag push events.
     */
    public val tagPushEvents: Output<Boolean>
        get() = javaResource.tagPushEvents().applyValue({ args0 -> args0 })

    /**
     * Username to use.
     */
    public val username: Output<String>?
        get() = javaResource.username().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Webhook URL (Example, https://mattermost.yourdomain.com/hooks/...). This value cannot be imported.
     */
    public val webhook: Output<String>
        get() = javaResource.webhook().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive wiki page events notifications.
     */
    public val wikiPageChannel: Output<String>?
        get() = javaResource.wikiPageChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for wiki page events.
     */
    public val wikiPageEvents: Output<Boolean>
        get() = javaResource.wikiPageEvents().applyValue({ args0 -> args0 })
}

public object IntegrationMattermostMapper : ResourceMapper<IntegrationMattermost> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.IntegrationMattermost::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationMattermost =
        IntegrationMattermost(javaResource as com.pulumi.gitlab.IntegrationMattermost)
}

/**
 * @see [IntegrationMattermost].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationMattermost].
 */
public suspend fun integrationMattermost(
    name: String,
    block: suspend IntegrationMattermostResourceBuilder.() -> Unit,
): IntegrationMattermost {
    val builder = IntegrationMattermostResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationMattermost].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationMattermost(name: String): IntegrationMattermost {
    val builder = IntegrationMattermostResourceBuilder()
    builder.name(name)
    return builder.build()
}
