@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.IntegrationMattermostArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.IntegrationMattermost` resource allows to manage the lifecycle of a project integration with Mattermost.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#mattermost-notifications)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const mattermost = new gitlab.IntegrationMattermost("mattermost", {
 *     project: awesomeProject.id,
 *     webhook: "https://webhook.com",
 *     username: "myuser",
 *     pushEvents: true,
 *     pushChannel: "push_chan",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * mattermost = gitlab.IntegrationMattermost("mattermost",
 *     project=awesome_project.id,
 *     webhook="https://webhook.com",
 *     username="myuser",
 *     push_events=True,
 *     push_channel="push_chan")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var mattermost = new GitLab.IntegrationMattermost("mattermost", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Webhook = "https://webhook.com",
 *         Username = "myuser",
 *         PushEvents = true,
 *         PushChannel = "push_chan",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationMattermost(ctx, "mattermost", &gitlab.IntegrationMattermostArgs{
 * 			Project:     awesomeProject.ID(),
 * 			Webhook:     pulumi.String("https://webhook.com"),
 * 			Username:    pulumi.String("myuser"),
 * 			PushEvents:  pulumi.Bool(true),
 * 			PushChannel: pulumi.String("push_chan"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationMattermost;
 * import com.pulumi.gitlab.IntegrationMattermostArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var mattermost = new IntegrationMattermost("mattermost", IntegrationMattermostArgs.builder()
 *             .project(awesomeProject.id())
 *             .webhook("https://webhook.com")
 *             .username("myuser")
 *             .pushEvents(true)
 *             .pushChannel("push_chan")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   mattermost:
 *     type: gitlab:IntegrationMattermost
 *     properties:
 *       project: ${awesomeProject.id}
 *       webhook: https://webhook.com
 *       username: myuser
 *       pushEvents: true
 *       pushChannel: push_chan
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_integration_mattermost.mattermost state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/integrationMattermost:IntegrationMattermost mattermost 1
 * ```
 * @property branchesToBeNotified Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
 * @property confidentialIssueChannel The name of the channel to receive confidential issue events notifications.
 * @property confidentialIssuesEvents Enable notifications for confidential issues events.
 * @property confidentialNoteChannel The name of the channel to receive confidential note events notifications.
 * @property confidentialNoteEvents Enable notifications for confidential note events.
 * @property issueChannel The name of the channel to receive issue events notifications.
 * @property issuesEvents Enable notifications for issues events.
 * @property mergeRequestChannel The name of the channel to receive merge request events notifications.
 * @property mergeRequestsEvents Enable notifications for merge requests events.
 * @property noteChannel The name of the channel to receive note events notifications.
 * @property noteEvents Enable notifications for note events.
 * @property notifyOnlyBrokenPipelines Send notifications for broken pipelines.
 * @property pipelineChannel The name of the channel to receive pipeline events notifications.
 * @property pipelineEvents Enable notifications for pipeline events.
 * @property project ID of the project you want to activate integration on.
 * @property pushChannel The name of the channel to receive push events notifications.
 * @property pushEvents Enable notifications for push events.
 * @property tagPushChannel The name of the channel to receive tag push events notifications.
 * @property tagPushEvents Enable notifications for tag push events.
 * @property username Username to use.
 * @property webhook Webhook URL (Example, https://mattermost.yourdomain.com/hooks/...). This value cannot be imported.
 * @property wikiPageChannel The name of the channel to receive wiki page events notifications.
 * @property wikiPageEvents Enable notifications for wiki page events.
 */
public data class IntegrationMattermostArgs(
    public val branchesToBeNotified: Output<String>? = null,
    public val confidentialIssueChannel: Output<String>? = null,
    public val confidentialIssuesEvents: Output<Boolean>? = null,
    public val confidentialNoteChannel: Output<String>? = null,
    public val confidentialNoteEvents: Output<Boolean>? = null,
    public val issueChannel: Output<String>? = null,
    public val issuesEvents: Output<Boolean>? = null,
    public val mergeRequestChannel: Output<String>? = null,
    public val mergeRequestsEvents: Output<Boolean>? = null,
    public val noteChannel: Output<String>? = null,
    public val noteEvents: Output<Boolean>? = null,
    public val notifyOnlyBrokenPipelines: Output<Boolean>? = null,
    public val pipelineChannel: Output<String>? = null,
    public val pipelineEvents: Output<Boolean>? = null,
    public val project: Output<String>? = null,
    public val pushChannel: Output<String>? = null,
    public val pushEvents: Output<Boolean>? = null,
    public val tagPushChannel: Output<String>? = null,
    public val tagPushEvents: Output<Boolean>? = null,
    public val username: Output<String>? = null,
    public val webhook: Output<String>? = null,
    public val wikiPageChannel: Output<String>? = null,
    public val wikiPageEvents: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.IntegrationMattermostArgs> {
    override fun toJava(): com.pulumi.gitlab.IntegrationMattermostArgs =
        com.pulumi.gitlab.IntegrationMattermostArgs.builder()
            .branchesToBeNotified(branchesToBeNotified?.applyValue({ args0 -> args0 }))
            .confidentialIssueChannel(confidentialIssueChannel?.applyValue({ args0 -> args0 }))
            .confidentialIssuesEvents(confidentialIssuesEvents?.applyValue({ args0 -> args0 }))
            .confidentialNoteChannel(confidentialNoteChannel?.applyValue({ args0 -> args0 }))
            .confidentialNoteEvents(confidentialNoteEvents?.applyValue({ args0 -> args0 }))
            .issueChannel(issueChannel?.applyValue({ args0 -> args0 }))
            .issuesEvents(issuesEvents?.applyValue({ args0 -> args0 }))
            .mergeRequestChannel(mergeRequestChannel?.applyValue({ args0 -> args0 }))
            .mergeRequestsEvents(mergeRequestsEvents?.applyValue({ args0 -> args0 }))
            .noteChannel(noteChannel?.applyValue({ args0 -> args0 }))
            .noteEvents(noteEvents?.applyValue({ args0 -> args0 }))
            .notifyOnlyBrokenPipelines(notifyOnlyBrokenPipelines?.applyValue({ args0 -> args0 }))
            .pipelineChannel(pipelineChannel?.applyValue({ args0 -> args0 }))
            .pipelineEvents(pipelineEvents?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .pushChannel(pushChannel?.applyValue({ args0 -> args0 }))
            .pushEvents(pushEvents?.applyValue({ args0 -> args0 }))
            .tagPushChannel(tagPushChannel?.applyValue({ args0 -> args0 }))
            .tagPushEvents(tagPushEvents?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 }))
            .webhook(webhook?.applyValue({ args0 -> args0 }))
            .wikiPageChannel(wikiPageChannel?.applyValue({ args0 -> args0 }))
            .wikiPageEvents(wikiPageEvents?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationMattermostArgs].
 */
@PulumiTagMarker
public class IntegrationMattermostArgsBuilder internal constructor() {
    private var branchesToBeNotified: Output<String>? = null

    private var confidentialIssueChannel: Output<String>? = null

    private var confidentialIssuesEvents: Output<Boolean>? = null

    private var confidentialNoteChannel: Output<String>? = null

    private var confidentialNoteEvents: Output<Boolean>? = null

    private var issueChannel: Output<String>? = null

    private var issuesEvents: Output<Boolean>? = null

    private var mergeRequestChannel: Output<String>? = null

    private var mergeRequestsEvents: Output<Boolean>? = null

    private var noteChannel: Output<String>? = null

    private var noteEvents: Output<Boolean>? = null

    private var notifyOnlyBrokenPipelines: Output<Boolean>? = null

    private var pipelineChannel: Output<String>? = null

    private var pipelineEvents: Output<Boolean>? = null

    private var project: Output<String>? = null

    private var pushChannel: Output<String>? = null

    private var pushEvents: Output<Boolean>? = null

    private var tagPushChannel: Output<String>? = null

    private var tagPushEvents: Output<Boolean>? = null

    private var username: Output<String>? = null

    private var webhook: Output<String>? = null

    private var wikiPageChannel: Output<String>? = null

    private var wikiPageEvents: Output<Boolean>? = null

    /**
     * @param value Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
     */
    @JvmName("ndgjoaotxmvjjssp")
    public suspend fun branchesToBeNotified(`value`: Output<String>) {
        this.branchesToBeNotified = value
    }

    /**
     * @param value The name of the channel to receive confidential issue events notifications.
     */
    @JvmName("prybmjdacrgcobto")
    public suspend fun confidentialIssueChannel(`value`: Output<String>) {
        this.confidentialIssueChannel = value
    }

    /**
     * @param value Enable notifications for confidential issues events.
     */
    @JvmName("hlbmwijsbahgjjed")
    public suspend fun confidentialIssuesEvents(`value`: Output<Boolean>) {
        this.confidentialIssuesEvents = value
    }

    /**
     * @param value The name of the channel to receive confidential note events notifications.
     */
    @JvmName("tcofwjmtahvxkiwd")
    public suspend fun confidentialNoteChannel(`value`: Output<String>) {
        this.confidentialNoteChannel = value
    }

    /**
     * @param value Enable notifications for confidential note events.
     */
    @JvmName("rnupnhrpnsopsjab")
    public suspend fun confidentialNoteEvents(`value`: Output<Boolean>) {
        this.confidentialNoteEvents = value
    }

    /**
     * @param value The name of the channel to receive issue events notifications.
     */
    @JvmName("vqoloatuexitbiky")
    public suspend fun issueChannel(`value`: Output<String>) {
        this.issueChannel = value
    }

    /**
     * @param value Enable notifications for issues events.
     */
    @JvmName("ilohuljbtkodjxpm")
    public suspend fun issuesEvents(`value`: Output<Boolean>) {
        this.issuesEvents = value
    }

    /**
     * @param value The name of the channel to receive merge request events notifications.
     */
    @JvmName("qevlyegkyugenwdo")
    public suspend fun mergeRequestChannel(`value`: Output<String>) {
        this.mergeRequestChannel = value
    }

    /**
     * @param value Enable notifications for merge requests events.
     */
    @JvmName("ibylcqxhlpgorafx")
    public suspend fun mergeRequestsEvents(`value`: Output<Boolean>) {
        this.mergeRequestsEvents = value
    }

    /**
     * @param value The name of the channel to receive note events notifications.
     */
    @JvmName("asyjeoahilavwfks")
    public suspend fun noteChannel(`value`: Output<String>) {
        this.noteChannel = value
    }

    /**
     * @param value Enable notifications for note events.
     */
    @JvmName("pweriewqxohdjerf")
    public suspend fun noteEvents(`value`: Output<Boolean>) {
        this.noteEvents = value
    }

    /**
     * @param value Send notifications for broken pipelines.
     */
    @JvmName("ntrrtoasknjqmouw")
    public suspend fun notifyOnlyBrokenPipelines(`value`: Output<Boolean>) {
        this.notifyOnlyBrokenPipelines = value
    }

    /**
     * @param value The name of the channel to receive pipeline events notifications.
     */
    @JvmName("kvsbmwjkuijetqya")
    public suspend fun pipelineChannel(`value`: Output<String>) {
        this.pipelineChannel = value
    }

    /**
     * @param value Enable notifications for pipeline events.
     */
    @JvmName("insmicrmlxfakxrk")
    public suspend fun pipelineEvents(`value`: Output<Boolean>) {
        this.pipelineEvents = value
    }

    /**
     * @param value ID of the project you want to activate integration on.
     */
    @JvmName("wdyyonvhuthqkdqw")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The name of the channel to receive push events notifications.
     */
    @JvmName("jxqjpcvcgwmiovlc")
    public suspend fun pushChannel(`value`: Output<String>) {
        this.pushChannel = value
    }

    /**
     * @param value Enable notifications for push events.
     */
    @JvmName("fafrlsifcgvkvbhj")
    public suspend fun pushEvents(`value`: Output<Boolean>) {
        this.pushEvents = value
    }

    /**
     * @param value The name of the channel to receive tag push events notifications.
     */
    @JvmName("ehkugrytiwbcibbd")
    public suspend fun tagPushChannel(`value`: Output<String>) {
        this.tagPushChannel = value
    }

    /**
     * @param value Enable notifications for tag push events.
     */
    @JvmName("cqpcnhfvhkgxsnam")
    public suspend fun tagPushEvents(`value`: Output<Boolean>) {
        this.tagPushEvents = value
    }

    /**
     * @param value Username to use.
     */
    @JvmName("ymrblsoaervixlfy")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Webhook URL (Example, https://mattermost.yourdomain.com/hooks/...). This value cannot be imported.
     */
    @JvmName("qhvrpxwbcwpjptcs")
    public suspend fun webhook(`value`: Output<String>) {
        this.webhook = value
    }

    /**
     * @param value The name of the channel to receive wiki page events notifications.
     */
    @JvmName("ypngwyanlmfrsjeb")
    public suspend fun wikiPageChannel(`value`: Output<String>) {
        this.wikiPageChannel = value
    }

    /**
     * @param value Enable notifications for wiki page events.
     */
    @JvmName("wybwkwmymxosylbg")
    public suspend fun wikiPageEvents(`value`: Output<Boolean>) {
        this.wikiPageEvents = value
    }

    /**
     * @param value Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
     */
    @JvmName("bgjtuhkgqpwmyinj")
    public suspend fun branchesToBeNotified(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchesToBeNotified = mapped
    }

    /**
     * @param value The name of the channel to receive confidential issue events notifications.
     */
    @JvmName("fsyqxueuernnnkht")
    public suspend fun confidentialIssueChannel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialIssueChannel = mapped
    }

    /**
     * @param value Enable notifications for confidential issues events.
     */
    @JvmName("domafwclmngeawms")
    public suspend fun confidentialIssuesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialIssuesEvents = mapped
    }

    /**
     * @param value The name of the channel to receive confidential note events notifications.
     */
    @JvmName("qpyrcekvuvclvoob")
    public suspend fun confidentialNoteChannel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialNoteChannel = mapped
    }

    /**
     * @param value Enable notifications for confidential note events.
     */
    @JvmName("golfbvtgbhscgyvd")
    public suspend fun confidentialNoteEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialNoteEvents = mapped
    }

    /**
     * @param value The name of the channel to receive issue events notifications.
     */
    @JvmName("fqrxabtmwikooytr")
    public suspend fun issueChannel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issueChannel = mapped
    }

    /**
     * @param value Enable notifications for issues events.
     */
    @JvmName("uhdrfjtlfixlnmoa")
    public suspend fun issuesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuesEvents = mapped
    }

    /**
     * @param value The name of the channel to receive merge request events notifications.
     */
    @JvmName("olwcmsbdetkcmvgm")
    public suspend fun mergeRequestChannel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestChannel = mapped
    }

    /**
     * @param value Enable notifications for merge requests events.
     */
    @JvmName("qlfsrapchrpplvrd")
    public suspend fun mergeRequestsEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestsEvents = mapped
    }

    /**
     * @param value The name of the channel to receive note events notifications.
     */
    @JvmName("kgkuowebbqscywxn")
    public suspend fun noteChannel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteChannel = mapped
    }

    /**
     * @param value Enable notifications for note events.
     */
    @JvmName("mxonqvidylgahjpg")
    public suspend fun noteEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteEvents = mapped
    }

    /**
     * @param value Send notifications for broken pipelines.
     */
    @JvmName("bbcoegwdijtvndnd")
    public suspend fun notifyOnlyBrokenPipelines(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyOnlyBrokenPipelines = mapped
    }

    /**
     * @param value The name of the channel to receive pipeline events notifications.
     */
    @JvmName("crrnecorsrqrlmlg")
    public suspend fun pipelineChannel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineChannel = mapped
    }

    /**
     * @param value Enable notifications for pipeline events.
     */
    @JvmName("jgbdxxsukeqfyctd")
    public suspend fun pipelineEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineEvents = mapped
    }

    /**
     * @param value ID of the project you want to activate integration on.
     */
    @JvmName("qpvxxahxoxypfsgp")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The name of the channel to receive push events notifications.
     */
    @JvmName("jamapmmaydswsctm")
    public suspend fun pushChannel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushChannel = mapped
    }

    /**
     * @param value Enable notifications for push events.
     */
    @JvmName("fpuqdnskwwardrvh")
    public suspend fun pushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEvents = mapped
    }

    /**
     * @param value The name of the channel to receive tag push events notifications.
     */
    @JvmName("sogbefhxnvkvtbtj")
    public suspend fun tagPushChannel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagPushChannel = mapped
    }

    /**
     * @param value Enable notifications for tag push events.
     */
    @JvmName("ovrfckmagqvvudxr")
    public suspend fun tagPushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagPushEvents = mapped
    }

    /**
     * @param value Username to use.
     */
    @JvmName("fapdenhivkovtmay")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    /**
     * @param value Webhook URL (Example, https://mattermost.yourdomain.com/hooks/...). This value cannot be imported.
     */
    @JvmName("kvnanuptoegniipq")
    public suspend fun webhook(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhook = mapped
    }

    /**
     * @param value The name of the channel to receive wiki page events notifications.
     */
    @JvmName("wfrnveuxuqmynsyq")
    public suspend fun wikiPageChannel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wikiPageChannel = mapped
    }

    /**
     * @param value Enable notifications for wiki page events.
     */
    @JvmName("icyhnvutlkuvlgvh")
    public suspend fun wikiPageEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wikiPageEvents = mapped
    }

    internal fun build(): IntegrationMattermostArgs = IntegrationMattermostArgs(
        branchesToBeNotified = branchesToBeNotified,
        confidentialIssueChannel = confidentialIssueChannel,
        confidentialIssuesEvents = confidentialIssuesEvents,
        confidentialNoteChannel = confidentialNoteChannel,
        confidentialNoteEvents = confidentialNoteEvents,
        issueChannel = issueChannel,
        issuesEvents = issuesEvents,
        mergeRequestChannel = mergeRequestChannel,
        mergeRequestsEvents = mergeRequestsEvents,
        noteChannel = noteChannel,
        noteEvents = noteEvents,
        notifyOnlyBrokenPipelines = notifyOnlyBrokenPipelines,
        pipelineChannel = pipelineChannel,
        pipelineEvents = pipelineEvents,
        project = project,
        pushChannel = pushChannel,
        pushEvents = pushEvents,
        tagPushChannel = tagPushChannel,
        tagPushEvents = tagPushEvents,
        username = username,
        webhook = webhook,
        wikiPageChannel = wikiPageChannel,
        wikiPageEvents = wikiPageEvents,
    )
}
