@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IntegrationMicrosoftTeams].
 */
@PulumiTagMarker
public class IntegrationMicrosoftTeamsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationMicrosoftTeamsArgs = IntegrationMicrosoftTeamsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationMicrosoftTeamsArgsBuilder.() -> Unit) {
        val builder = IntegrationMicrosoftTeamsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationMicrosoftTeams {
        val builtJavaResource = com.pulumi.gitlab.IntegrationMicrosoftTeams(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationMicrosoftTeams(builtJavaResource)
    }
}

/**
 * The `gitlab.IntegrationMicrosoftTeams` resource allows to manage the lifecycle of a project integration with Microsoft Teams.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#microsoft-teams)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const teams = new gitlab.IntegrationMicrosoftTeams("teams", {
 *     project: awesomeProject.id,
 *     webhook: "https://testurl.com/?token=XYZ",
 *     pushEvents: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * teams = gitlab.IntegrationMicrosoftTeams("teams",
 *     project=awesome_project.id,
 *     webhook="https://testurl.com/?token=XYZ",
 *     push_events=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var teams = new GitLab.IntegrationMicrosoftTeams("teams", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Webhook = "https://testurl.com/?token=XYZ",
 *         PushEvents = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationMicrosoftTeams(ctx, "teams", &gitlab.IntegrationMicrosoftTeamsArgs{
 * 			Project:    awesomeProject.ID(),
 * 			Webhook:    pulumi.String("https://testurl.com/?token=XYZ"),
 * 			PushEvents: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationMicrosoftTeams;
 * import com.pulumi.gitlab.IntegrationMicrosoftTeamsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var teams = new IntegrationMicrosoftTeams("teams", IntegrationMicrosoftTeamsArgs.builder()
 *             .project(awesomeProject.id())
 *             .webhook("https://testurl.com/?token=XYZ")
 *             .pushEvents(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   teams:
 *     type: gitlab:IntegrationMicrosoftTeams
 *     properties:
 *       project: ${awesomeProject.id}
 *       webhook: https://testurl.com/?token=XYZ
 *       pushEvents: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_integration_microsoft_teams state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/integrationMicrosoftTeams:IntegrationMicrosoftTeams teams 1
 * ```
 */
public class IntegrationMicrosoftTeams internal constructor(
    override val javaResource: com.pulumi.gitlab.IntegrationMicrosoftTeams,
) : KotlinCustomResource(javaResource, IntegrationMicrosoftTeamsMapper) {
    /**
     * Whether the integration is active.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * Branches to send notifications for. Valid options are “all”, “default”, “protected”, and “default*and*protected”. The default value is “default”
     */
    public val branchesToBeNotified: Output<String>?
        get() = javaResource.branchesToBeNotified().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for confidential issue events
     */
    public val confidentialIssuesEvents: Output<Boolean>?
        get() = javaResource.confidentialIssuesEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for confidential note events
     */
    public val confidentialNoteEvents: Output<Boolean>?
        get() = javaResource.confidentialNoteEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Create time.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for issue events
     */
    public val issuesEvents: Output<Boolean>?
        get() = javaResource.issuesEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for merge request events
     */
    public val mergeRequestsEvents: Output<Boolean>?
        get() = javaResource.mergeRequestsEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for note events
     */
    public val noteEvents: Output<Boolean>?
        get() = javaResource.noteEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Send notifications for broken pipelines
     */
    public val notifyOnlyBrokenPipelines: Output<Boolean>?
        get() = javaResource.notifyOnlyBrokenPipelines().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for pipeline events
     */
    public val pipelineEvents: Output<Boolean>?
        get() = javaResource.pipelineEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the project you want to activate integration on.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for push events
     */
    public val pushEvents: Output<Boolean>?
        get() = javaResource.pushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for tag push events
     */
    public val tagPushEvents: Output<Boolean>?
        get() = javaResource.tagPushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Update time.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })

    /**
     * The Microsoft Teams webhook (Example, https://outlook.office.com/webhook/...). This value cannot be imported.
     */
    public val webhook: Output<String>
        get() = javaResource.webhook().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for wiki page events
     */
    public val wikiPageEvents: Output<Boolean>?
        get() = javaResource.wikiPageEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object IntegrationMicrosoftTeamsMapper : ResourceMapper<IntegrationMicrosoftTeams> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.IntegrationMicrosoftTeams::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationMicrosoftTeams =
        IntegrationMicrosoftTeams(javaResource as com.pulumi.gitlab.IntegrationMicrosoftTeams)
}

/**
 * @see [IntegrationMicrosoftTeams].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationMicrosoftTeams].
 */
public suspend fun integrationMicrosoftTeams(
    name: String,
    block: suspend IntegrationMicrosoftTeamsResourceBuilder.() -> Unit,
): IntegrationMicrosoftTeams {
    val builder = IntegrationMicrosoftTeamsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationMicrosoftTeams].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationMicrosoftTeams(name: String): IntegrationMicrosoftTeams {
    val builder = IntegrationMicrosoftTeamsResourceBuilder()
    builder.name(name)
    return builder.build()
}
