@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.IntegrationMicrosoftTeamsArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.IntegrationMicrosoftTeams` resource allows to manage the lifecycle of a project integration with Microsoft Teams.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#microsoft-teams)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const teams = new gitlab.IntegrationMicrosoftTeams("teams", {
 *     project: awesomeProject.id,
 *     webhook: "https://testurl.com/?token=XYZ",
 *     pushEvents: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * teams = gitlab.IntegrationMicrosoftTeams("teams",
 *     project=awesome_project.id,
 *     webhook="https://testurl.com/?token=XYZ",
 *     push_events=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var teams = new GitLab.IntegrationMicrosoftTeams("teams", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Webhook = "https://testurl.com/?token=XYZ",
 *         PushEvents = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationMicrosoftTeams(ctx, "teams", &gitlab.IntegrationMicrosoftTeamsArgs{
 * 			Project:    awesomeProject.ID(),
 * 			Webhook:    pulumi.String("https://testurl.com/?token=XYZ"),
 * 			PushEvents: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationMicrosoftTeams;
 * import com.pulumi.gitlab.IntegrationMicrosoftTeamsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var teams = new IntegrationMicrosoftTeams("teams", IntegrationMicrosoftTeamsArgs.builder()
 *             .project(awesomeProject.id())
 *             .webhook("https://testurl.com/?token=XYZ")
 *             .pushEvents(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   teams:
 *     type: gitlab:IntegrationMicrosoftTeams
 *     properties:
 *       project: ${awesomeProject.id}
 *       webhook: https://testurl.com/?token=XYZ
 *       pushEvents: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_integration_microsoft_teams state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/integrationMicrosoftTeams:IntegrationMicrosoftTeams teams 1
 * ```
 * @property branchesToBeNotified Branches to send notifications for. Valid options are “all”, “default”, “protected”, and “default*and*protected”. The default value is “default”
 * @property confidentialIssuesEvents Enable notifications for confidential issue events
 * @property confidentialNoteEvents Enable notifications for confidential note events
 * @property issuesEvents Enable notifications for issue events
 * @property mergeRequestsEvents Enable notifications for merge request events
 * @property noteEvents Enable notifications for note events
 * @property notifyOnlyBrokenPipelines Send notifications for broken pipelines
 * @property pipelineEvents Enable notifications for pipeline events
 * @property project ID of the project you want to activate integration on.
 * @property pushEvents Enable notifications for push events
 * @property tagPushEvents Enable notifications for tag push events
 * @property webhook The Microsoft Teams webhook (Example, https://outlook.office.com/webhook/...). This value cannot be imported.
 * @property wikiPageEvents Enable notifications for wiki page events
 */
public data class IntegrationMicrosoftTeamsArgs(
    public val branchesToBeNotified: Output<String>? = null,
    public val confidentialIssuesEvents: Output<Boolean>? = null,
    public val confidentialNoteEvents: Output<Boolean>? = null,
    public val issuesEvents: Output<Boolean>? = null,
    public val mergeRequestsEvents: Output<Boolean>? = null,
    public val noteEvents: Output<Boolean>? = null,
    public val notifyOnlyBrokenPipelines: Output<Boolean>? = null,
    public val pipelineEvents: Output<Boolean>? = null,
    public val project: Output<String>? = null,
    public val pushEvents: Output<Boolean>? = null,
    public val tagPushEvents: Output<Boolean>? = null,
    public val webhook: Output<String>? = null,
    public val wikiPageEvents: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.IntegrationMicrosoftTeamsArgs> {
    override fun toJava(): com.pulumi.gitlab.IntegrationMicrosoftTeamsArgs =
        com.pulumi.gitlab.IntegrationMicrosoftTeamsArgs.builder()
            .branchesToBeNotified(branchesToBeNotified?.applyValue({ args0 -> args0 }))
            .confidentialIssuesEvents(confidentialIssuesEvents?.applyValue({ args0 -> args0 }))
            .confidentialNoteEvents(confidentialNoteEvents?.applyValue({ args0 -> args0 }))
            .issuesEvents(issuesEvents?.applyValue({ args0 -> args0 }))
            .mergeRequestsEvents(mergeRequestsEvents?.applyValue({ args0 -> args0 }))
            .noteEvents(noteEvents?.applyValue({ args0 -> args0 }))
            .notifyOnlyBrokenPipelines(notifyOnlyBrokenPipelines?.applyValue({ args0 -> args0 }))
            .pipelineEvents(pipelineEvents?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .pushEvents(pushEvents?.applyValue({ args0 -> args0 }))
            .tagPushEvents(tagPushEvents?.applyValue({ args0 -> args0 }))
            .webhook(webhook?.applyValue({ args0 -> args0 }))
            .wikiPageEvents(wikiPageEvents?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationMicrosoftTeamsArgs].
 */
@PulumiTagMarker
public class IntegrationMicrosoftTeamsArgsBuilder internal constructor() {
    private var branchesToBeNotified: Output<String>? = null

    private var confidentialIssuesEvents: Output<Boolean>? = null

    private var confidentialNoteEvents: Output<Boolean>? = null

    private var issuesEvents: Output<Boolean>? = null

    private var mergeRequestsEvents: Output<Boolean>? = null

    private var noteEvents: Output<Boolean>? = null

    private var notifyOnlyBrokenPipelines: Output<Boolean>? = null

    private var pipelineEvents: Output<Boolean>? = null

    private var project: Output<String>? = null

    private var pushEvents: Output<Boolean>? = null

    private var tagPushEvents: Output<Boolean>? = null

    private var webhook: Output<String>? = null

    private var wikiPageEvents: Output<Boolean>? = null

    /**
     * @param value Branches to send notifications for. Valid options are “all”, “default”, “protected”, and “default*and*protected”. The default value is “default”
     */
    @JvmName("lrxklrrsyocmpmtb")
    public suspend fun branchesToBeNotified(`value`: Output<String>) {
        this.branchesToBeNotified = value
    }

    /**
     * @param value Enable notifications for confidential issue events
     */
    @JvmName("gusdmmnsuoksfmor")
    public suspend fun confidentialIssuesEvents(`value`: Output<Boolean>) {
        this.confidentialIssuesEvents = value
    }

    /**
     * @param value Enable notifications for confidential note events
     */
    @JvmName("bvrrypolebnfwglu")
    public suspend fun confidentialNoteEvents(`value`: Output<Boolean>) {
        this.confidentialNoteEvents = value
    }

    /**
     * @param value Enable notifications for issue events
     */
    @JvmName("fevtmaghiggnofml")
    public suspend fun issuesEvents(`value`: Output<Boolean>) {
        this.issuesEvents = value
    }

    /**
     * @param value Enable notifications for merge request events
     */
    @JvmName("hidobubpqgfsyvon")
    public suspend fun mergeRequestsEvents(`value`: Output<Boolean>) {
        this.mergeRequestsEvents = value
    }

    /**
     * @param value Enable notifications for note events
     */
    @JvmName("qpkivmgwsttepbfj")
    public suspend fun noteEvents(`value`: Output<Boolean>) {
        this.noteEvents = value
    }

    /**
     * @param value Send notifications for broken pipelines
     */
    @JvmName("kjtqywjasbmworxw")
    public suspend fun notifyOnlyBrokenPipelines(`value`: Output<Boolean>) {
        this.notifyOnlyBrokenPipelines = value
    }

    /**
     * @param value Enable notifications for pipeline events
     */
    @JvmName("lgbsytgvwacntifa")
    public suspend fun pipelineEvents(`value`: Output<Boolean>) {
        this.pipelineEvents = value
    }

    /**
     * @param value ID of the project you want to activate integration on.
     */
    @JvmName("voabngomwsplywwq")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Enable notifications for push events
     */
    @JvmName("uekymhyrjqglfdie")
    public suspend fun pushEvents(`value`: Output<Boolean>) {
        this.pushEvents = value
    }

    /**
     * @param value Enable notifications for tag push events
     */
    @JvmName("ckkpmcaudgsurxax")
    public suspend fun tagPushEvents(`value`: Output<Boolean>) {
        this.tagPushEvents = value
    }

    /**
     * @param value The Microsoft Teams webhook (Example, https://outlook.office.com/webhook/...). This value cannot be imported.
     */
    @JvmName("iaxalhvislxdugyo")
    public suspend fun webhook(`value`: Output<String>) {
        this.webhook = value
    }

    /**
     * @param value Enable notifications for wiki page events
     */
    @JvmName("xkjnspiegiohawtm")
    public suspend fun wikiPageEvents(`value`: Output<Boolean>) {
        this.wikiPageEvents = value
    }

    /**
     * @param value Branches to send notifications for. Valid options are “all”, “default”, “protected”, and “default*and*protected”. The default value is “default”
     */
    @JvmName("lssggmgbjwbcdsom")
    public suspend fun branchesToBeNotified(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchesToBeNotified = mapped
    }

    /**
     * @param value Enable notifications for confidential issue events
     */
    @JvmName("pgstuajqqufhwogq")
    public suspend fun confidentialIssuesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialIssuesEvents = mapped
    }

    /**
     * @param value Enable notifications for confidential note events
     */
    @JvmName("kksfhxymjuckrkxo")
    public suspend fun confidentialNoteEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialNoteEvents = mapped
    }

    /**
     * @param value Enable notifications for issue events
     */
    @JvmName("bkjqvxrkptxnxxga")
    public suspend fun issuesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuesEvents = mapped
    }

    /**
     * @param value Enable notifications for merge request events
     */
    @JvmName("uhglopmytwsexffr")
    public suspend fun mergeRequestsEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestsEvents = mapped
    }

    /**
     * @param value Enable notifications for note events
     */
    @JvmName("hbegtyklvmukjwci")
    public suspend fun noteEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteEvents = mapped
    }

    /**
     * @param value Send notifications for broken pipelines
     */
    @JvmName("omxmyxwaovbovloq")
    public suspend fun notifyOnlyBrokenPipelines(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyOnlyBrokenPipelines = mapped
    }

    /**
     * @param value Enable notifications for pipeline events
     */
    @JvmName("cjphvflbiuspdxme")
    public suspend fun pipelineEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineEvents = mapped
    }

    /**
     * @param value ID of the project you want to activate integration on.
     */
    @JvmName("hfiuewadwljbpdsb")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Enable notifications for push events
     */
    @JvmName("uckgbiyqejevusgu")
    public suspend fun pushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEvents = mapped
    }

    /**
     * @param value Enable notifications for tag push events
     */
    @JvmName("dtncfnwxtaoghjkf")
    public suspend fun tagPushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagPushEvents = mapped
    }

    /**
     * @param value The Microsoft Teams webhook (Example, https://outlook.office.com/webhook/...). This value cannot be imported.
     */
    @JvmName("owkfylouiqgmrcpo")
    public suspend fun webhook(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhook = mapped
    }

    /**
     * @param value Enable notifications for wiki page events
     */
    @JvmName("uycicrdvvqgeiwcr")
    public suspend fun wikiPageEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wikiPageEvents = mapped
    }

    internal fun build(): IntegrationMicrosoftTeamsArgs = IntegrationMicrosoftTeamsArgs(
        branchesToBeNotified = branchesToBeNotified,
        confidentialIssuesEvents = confidentialIssuesEvents,
        confidentialNoteEvents = confidentialNoteEvents,
        issuesEvents = issuesEvents,
        mergeRequestsEvents = mergeRequestsEvents,
        noteEvents = noteEvents,
        notifyOnlyBrokenPipelines = notifyOnlyBrokenPipelines,
        pipelineEvents = pipelineEvents,
        project = project,
        pushEvents = pushEvents,
        tagPushEvents = tagPushEvents,
        webhook = webhook,
        wikiPageEvents = wikiPageEvents,
    )
}
