@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [IntegrationPipelinesEmail].
 */
@PulumiTagMarker
public class IntegrationPipelinesEmailResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationPipelinesEmailArgs = IntegrationPipelinesEmailArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationPipelinesEmailArgsBuilder.() -> Unit) {
        val builder = IntegrationPipelinesEmailArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationPipelinesEmail {
        val builtJavaResource = com.pulumi.gitlab.IntegrationPipelinesEmail(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationPipelinesEmail(builtJavaResource)
    }
}

/**
 * The `gitlab.IntegrationPipelinesEmail` resource allows to manage the lifecycle of a project integration with Pipeline Emails Service.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#pipeline-emails)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const email = new gitlab.IntegrationPipelinesEmail("email", {
 *     project: awesomeProject.id,
 *     recipients: ["gitlab@user&#46;create"],
 *     notifyOnlyBrokenPipelines: true,
 *     branchesToBeNotified: "all",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * email = gitlab.IntegrationPipelinesEmail("email",
 *     project=awesome_project.id,
 *     recipients=["gitlab@user&#46;create"],
 *     notify_only_broken_pipelines=True,
 *     branches_to_be_notified="all")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var email = new GitLab.IntegrationPipelinesEmail("email", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Recipients = new[]
 *         {
 *             "gitlab@user.create",
 *         },
 *         NotifyOnlyBrokenPipelines = true,
 *         BranchesToBeNotified = "all",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationPipelinesEmail(ctx, "email", &gitlab.IntegrationPipelinesEmailArgs{
 * 			Project: awesomeProject.ID(),
 * 			Recipients: pulumi.StringArray{
 * 				pulumi.String("gitlab@user.create"),
 * 			},
 * 			NotifyOnlyBrokenPipelines: pulumi.Bool(true),
 * 			BranchesToBeNotified:      pulumi.String("all"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationPipelinesEmail;
 * import com.pulumi.gitlab.IntegrationPipelinesEmailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var email = new IntegrationPipelinesEmail("email", IntegrationPipelinesEmailArgs.builder()
 *             .project(awesomeProject.id())
 *             .recipients("gitlab@user.create")
 *             .notifyOnlyBrokenPipelines(true)
 *             .branchesToBeNotified("all")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   email:
 *     type: gitlab:IntegrationPipelinesEmail
 *     properties:
 *       project: ${awesomeProject.id}
 *       recipients:
 *         - gitlab@user.create
 *       notifyOnlyBrokenPipelines: true
 *       branchesToBeNotified: all
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_integration_pipelines_email state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/integrationPipelinesEmail:IntegrationPipelinesEmail email 1
 * ```
 */
public class IntegrationPipelinesEmail internal constructor(
    override val javaResource: com.pulumi.gitlab.IntegrationPipelinesEmail,
) : KotlinCustomResource(javaResource, IntegrationPipelinesEmailMapper) {
    /**
     * Branches to send notifications for. Valid options are `all`, `default`, `protected`, and `default_and_protected`. Default is `default`
     */
    public val branchesToBeNotified: Output<String>?
        get() = javaResource.branchesToBeNotified().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Notify only broken pipelines. Default is true.
     */
    public val notifyOnlyBrokenPipelines: Output<Boolean>?
        get() = javaResource.notifyOnlyBrokenPipelines().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the project you want to activate integration on.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * ) email addresses where notifications are sent.
     */
    public val recipients: Output<List<String>>
        get() = javaResource.recipients().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object IntegrationPipelinesEmailMapper : ResourceMapper<IntegrationPipelinesEmail> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.IntegrationPipelinesEmail::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationPipelinesEmail =
        IntegrationPipelinesEmail(javaResource as com.pulumi.gitlab.IntegrationPipelinesEmail)
}

/**
 * @see [IntegrationPipelinesEmail].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationPipelinesEmail].
 */
public suspend fun integrationPipelinesEmail(
    name: String,
    block: suspend IntegrationPipelinesEmailResourceBuilder.() -> Unit,
): IntegrationPipelinesEmail {
    val builder = IntegrationPipelinesEmailResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationPipelinesEmail].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationPipelinesEmail(name: String): IntegrationPipelinesEmail {
    val builder = IntegrationPipelinesEmailResourceBuilder()
    builder.name(name)
    return builder.build()
}
