@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IntegrationSlack].
 */
@PulumiTagMarker
public class IntegrationSlackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationSlackArgs = IntegrationSlackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationSlackArgsBuilder.() -> Unit) {
        val builder = IntegrationSlackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationSlack {
        val builtJavaResource = com.pulumi.gitlab.IntegrationSlack(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationSlack(builtJavaResource)
    }
}

/**
 * The `gitlab.IntegrationSlack` resource allows to manage the lifecycle of a project integration with Slack.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#slack-notifications)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const slack = new gitlab.IntegrationSlack("slack", {
 *     project: awesomeProject.id,
 *     webhook: "https://webhook.com",
 *     username: "myuser",
 *     pushEvents: true,
 *     pushChannel: "push_chan",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * slack = gitlab.IntegrationSlack("slack",
 *     project=awesome_project.id,
 *     webhook="https://webhook.com",
 *     username="myuser",
 *     push_events=True,
 *     push_channel="push_chan")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var slack = new GitLab.IntegrationSlack("slack", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Webhook = "https://webhook.com",
 *         Username = "myuser",
 *         PushEvents = true,
 *         PushChannel = "push_chan",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationSlack(ctx, "slack", &gitlab.IntegrationSlackArgs{
 * 			Project:     awesomeProject.ID(),
 * 			Webhook:     pulumi.String("https://webhook.com"),
 * 			Username:    pulumi.String("myuser"),
 * 			PushEvents:  pulumi.Bool(true),
 * 			PushChannel: pulumi.String("push_chan"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationSlack;
 * import com.pulumi.gitlab.IntegrationSlackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var slack = new IntegrationSlack("slack", IntegrationSlackArgs.builder()
 *             .project(awesomeProject.id())
 *             .webhook("https://webhook.com")
 *             .username("myuser")
 *             .pushEvents(true)
 *             .pushChannel("push_chan")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   slack:
 *     type: gitlab:IntegrationSlack
 *     properties:
 *       project: ${awesomeProject.id}
 *       webhook: https://webhook.com
 *       username: myuser
 *       pushEvents: true
 *       pushChannel: push_chan
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_integration_slack.slack state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/integrationSlack:IntegrationSlack slack 1
 * ```
 */
public class IntegrationSlack internal constructor(
    override val javaResource: com.pulumi.gitlab.IntegrationSlack,
) : KotlinCustomResource(javaResource, IntegrationSlackMapper) {
    /**
     * Branches to send notifications for. Valid options are "all", "default", "protected", and "default*and*protected".
     */
    public val branchesToBeNotified: Output<String>
        get() = javaResource.branchesToBeNotified().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive confidential issue events notifications.
     */
    public val confidentialIssueChannel: Output<String>?
        get() = javaResource.confidentialIssueChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for confidential issues events.
     */
    public val confidentialIssuesEvents: Output<Boolean>
        get() = javaResource.confidentialIssuesEvents().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive confidential note events notifications.
     */
    public val confidentialNoteChannel: Output<String>
        get() = javaResource.confidentialNoteChannel().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for confidential note events.
     */
    public val confidentialNoteEvents: Output<Boolean>
        get() = javaResource.confidentialNoteEvents().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive issue events notifications.
     */
    public val issueChannel: Output<String>?
        get() = javaResource.issueChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for issues events.
     */
    public val issuesEvents: Output<Boolean>
        get() = javaResource.issuesEvents().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for job events. **ATTENTION**: This attribute is currently not being submitted to the GitLab API, due to https://github.com/xanzy/go-gitlab/issues/1354.
     */
    public val jobEvents: Output<Boolean>
        get() = javaResource.jobEvents().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive merge request events notifications.
     */
    public val mergeRequestChannel: Output<String>?
        get() = javaResource.mergeRequestChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for merge requests events.
     */
    public val mergeRequestsEvents: Output<Boolean>
        get() = javaResource.mergeRequestsEvents().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive note events notifications.
     */
    public val noteChannel: Output<String>?
        get() = javaResource.noteChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for note events.
     */
    public val noteEvents: Output<Boolean>
        get() = javaResource.noteEvents().applyValue({ args0 -> args0 })

    /**
     * Send notifications for broken pipelines.
     */
    public val notifyOnlyBrokenPipelines: Output<Boolean>
        get() = javaResource.notifyOnlyBrokenPipelines().applyValue({ args0 -> args0 })

    /**
     * This parameter has been replaced with `branches_to_be_notified`.
     */
    @Deprecated(
        message = """
  use 'branches_to_be_notified' argument instead
  """,
    )
    public val notifyOnlyDefaultBranch: Output<Boolean>
        get() = javaResource.notifyOnlyDefaultBranch().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive pipeline events notifications.
     */
    public val pipelineChannel: Output<String>?
        get() = javaResource.pipelineChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for pipeline events.
     */
    public val pipelineEvents: Output<Boolean>
        get() = javaResource.pipelineEvents().applyValue({ args0 -> args0 })

    /**
     * ID of the project you want to activate integration on.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive push events notifications.
     */
    public val pushChannel: Output<String>?
        get() = javaResource.pushChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for push events.
     */
    public val pushEvents: Output<Boolean>
        get() = javaResource.pushEvents().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive tag push events notifications.
     */
    public val tagPushChannel: Output<String>?
        get() = javaResource.tagPushChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for tag push events.
     */
    public val tagPushEvents: Output<Boolean>
        get() = javaResource.tagPushEvents().applyValue({ args0 -> args0 })

    /**
     * Username to use.
     */
    public val username: Output<String>?
        get() = javaResource.username().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Webhook URL (Example, https://hooks.slack.com/services/...). This value cannot be imported.
     */
    public val webhook: Output<String>
        get() = javaResource.webhook().applyValue({ args0 -> args0 })

    /**
     * The name of the channel to receive wiki page events notifications.
     */
    public val wikiPageChannel: Output<String>?
        get() = javaResource.wikiPageChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for wiki page events.
     */
    public val wikiPageEvents: Output<Boolean>
        get() = javaResource.wikiPageEvents().applyValue({ args0 -> args0 })
}

public object IntegrationSlackMapper : ResourceMapper<IntegrationSlack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.IntegrationSlack::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationSlack = IntegrationSlack(
        javaResource as
            com.pulumi.gitlab.IntegrationSlack,
    )
}

/**
 * @see [IntegrationSlack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationSlack].
 */
public suspend fun integrationSlack(
    name: String,
    block: suspend IntegrationSlackResourceBuilder.() -> Unit,
): IntegrationSlack {
    val builder = IntegrationSlackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationSlack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationSlack(name: String): IntegrationSlack {
    val builder = IntegrationSlackResourceBuilder()
    builder.name(name)
    return builder.build()
}
