@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IntegrationTelegram].
 */
@PulumiTagMarker
public class IntegrationTelegramResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationTelegramArgs = IntegrationTelegramArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationTelegramArgsBuilder.() -> Unit) {
        val builder = IntegrationTelegramArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationTelegram {
        val builtJavaResource = com.pulumi.gitlab.IntegrationTelegram(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationTelegram(builtJavaResource)
    }
}

/**
 * The `gitlab.IntegrationTelegram` resource allows to manage the lifecycle of a project integration with Telegram.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#telegram)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const _default = new gitlab.IntegrationTelegram("default", {
 *     token: "123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11",
 *     room: "-1000000000000000",
 *     notifyOnlyBrokenPipelines: false,
 *     branchesToBeNotified: "all",
 *     pushEvents: false,
 *     issuesEvents: false,
 *     confidentialIssuesEvents: false,
 *     mergeRequestsEvents: false,
 *     tagPushEvents: false,
 *     noteEvents: false,
 *     confidentialNoteEvents: false,
 *     pipelineEvents: false,
 *     wikiPageEvents: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * default = gitlab.IntegrationTelegram("default",
 *     token="123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11",
 *     room="-1000000000000000",
 *     notify_only_broken_pipelines=False,
 *     branches_to_be_notified="all",
 *     push_events=False,
 *     issues_events=False,
 *     confidential_issues_events=False,
 *     merge_requests_events=False,
 *     tag_push_events=False,
 *     note_events=False,
 *     confidential_note_events=False,
 *     pipeline_events=False,
 *     wiki_page_events=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var @default = new GitLab.IntegrationTelegram("default", new()
 *     {
 *         Token = "123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11",
 *         Room = "-1000000000000000",
 *         NotifyOnlyBrokenPipelines = false,
 *         BranchesToBeNotified = "all",
 *         PushEvents = false,
 *         IssuesEvents = false,
 *         ConfidentialIssuesEvents = false,
 *         MergeRequestsEvents = false,
 *         TagPushEvents = false,
 *         NoteEvents = false,
 *         ConfidentialNoteEvents = false,
 *         PipelineEvents = false,
 *         WikiPageEvents = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationTelegram(ctx, "default", &gitlab.IntegrationTelegramArgs{
 * 			Token:                     pulumi.String("123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11"),
 * 			Room:                      pulumi.String("-1000000000000000"),
 * 			NotifyOnlyBrokenPipelines: pulumi.Bool(false),
 * 			BranchesToBeNotified:      pulumi.String("all"),
 * 			PushEvents:                pulumi.Bool(false),
 * 			IssuesEvents:              pulumi.Bool(false),
 * 			ConfidentialIssuesEvents:  pulumi.Bool(false),
 * 			MergeRequestsEvents:       pulumi.Bool(false),
 * 			TagPushEvents:             pulumi.Bool(false),
 * 			NoteEvents:                pulumi.Bool(false),
 * 			ConfidentialNoteEvents:    pulumi.Bool(false),
 * 			PipelineEvents:            pulumi.Bool(false),
 * 			WikiPageEvents:            pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationTelegram;
 * import com.pulumi.gitlab.IntegrationTelegramArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var default_ = new IntegrationTelegram("default", IntegrationTelegramArgs.builder()
 *             .token("123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11")
 *             .room("-1000000000000000")
 *             .notifyOnlyBrokenPipelines(false)
 *             .branchesToBeNotified("all")
 *             .pushEvents(false)
 *             .issuesEvents(false)
 *             .confidentialIssuesEvents(false)
 *             .mergeRequestsEvents(false)
 *             .tagPushEvents(false)
 *             .noteEvents(false)
 *             .confidentialNoteEvents(false)
 *             .pipelineEvents(false)
 *             .wikiPageEvents(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   default:
 *     type: gitlab:IntegrationTelegram
 *     properties:
 *       token: 123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11
 *       room: '-1000000000000000'
 *       notifyOnlyBrokenPipelines: false
 *       branchesToBeNotified: all
 *       pushEvents: false
 *       issuesEvents: false
 *       confidentialIssuesEvents: false
 *       mergeRequestsEvents: false
 *       tagPushEvents: false
 *       noteEvents: false
 *       confidentialNoteEvents: false
 *       pipelineEvents: false
 *       wikiPageEvents: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_integration_telegram state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/integrationTelegram:IntegrationTelegram default 1
 * ```
 */
public class IntegrationTelegram internal constructor(
    override val javaResource: com.pulumi.gitlab.IntegrationTelegram,
) : KotlinCustomResource(javaResource, IntegrationTelegramMapper) {
    /**
     * Branches to send notifications for (introduced in GitLab 16.5). Update of this attribute was not supported before Gitlab 16.11 due to API bug. Valid options are `all`, `default`, `protected`, `default_and_protected`.
     */
    public val branchesToBeNotified: Output<String>
        get() = javaResource.branchesToBeNotified().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for confidential issues events.
     */
    public val confidentialIssuesEvents: Output<Boolean>
        get() = javaResource.confidentialIssuesEvents().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for confidential note events.
     */
    public val confidentialNoteEvents: Output<Boolean>
        get() = javaResource.confidentialNoteEvents().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for issues events.
     */
    public val issuesEvents: Output<Boolean>
        get() = javaResource.issuesEvents().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for merge requests events.
     */
    public val mergeRequestsEvents: Output<Boolean>
        get() = javaResource.mergeRequestsEvents().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for note events.
     */
    public val noteEvents: Output<Boolean>
        get() = javaResource.noteEvents().applyValue({ args0 -> args0 })

    /**
     * Send notifications for broken pipelines.
     */
    public val notifyOnlyBrokenPipelines: Output<Boolean>
        get() = javaResource.notifyOnlyBrokenPipelines().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for pipeline events.
     */
    public val pipelineEvents: Output<Boolean>
        get() = javaResource.pipelineEvents().applyValue({ args0 -> args0 })

    /**
     * The ID or full path of the project to integrate with Telegram.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for push events.
     */
    public val pushEvents: Output<Boolean>
        get() = javaResource.pushEvents().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for the target chat or the username of the target channel (in the format `@channelusername`)
     */
    public val room: Output<String>
        get() = javaResource.room().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for tag push events.
     */
    public val tagPushEvents: Output<Boolean>
        get() = javaResource.tagPushEvents().applyValue({ args0 -> args0 })

    /**
     * The Telegram bot token.
     */
    public val token: Output<String>
        get() = javaResource.token().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for wiki page events.
     */
    public val wikiPageEvents: Output<Boolean>
        get() = javaResource.wikiPageEvents().applyValue({ args0 -> args0 })
}

public object IntegrationTelegramMapper : ResourceMapper<IntegrationTelegram> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.IntegrationTelegram::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationTelegram = IntegrationTelegram(
        javaResource
            as com.pulumi.gitlab.IntegrationTelegram,
    )
}

/**
 * @see [IntegrationTelegram].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationTelegram].
 */
public suspend fun integrationTelegram(
    name: String,
    block: suspend IntegrationTelegramResourceBuilder.() -> Unit,
): IntegrationTelegram {
    val builder = IntegrationTelegramResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationTelegram].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationTelegram(name: String): IntegrationTelegram {
    val builder = IntegrationTelegramResourceBuilder()
    builder.name(name)
    return builder.build()
}
