@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.IntegrationTelegramArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.IntegrationTelegram` resource allows to manage the lifecycle of a project integration with Telegram.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#telegram)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const _default = new gitlab.IntegrationTelegram("default", {
 *     token: "123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11",
 *     room: "-1000000000000000",
 *     notifyOnlyBrokenPipelines: false,
 *     branchesToBeNotified: "all",
 *     pushEvents: false,
 *     issuesEvents: false,
 *     confidentialIssuesEvents: false,
 *     mergeRequestsEvents: false,
 *     tagPushEvents: false,
 *     noteEvents: false,
 *     confidentialNoteEvents: false,
 *     pipelineEvents: false,
 *     wikiPageEvents: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * default = gitlab.IntegrationTelegram("default",
 *     token="123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11",
 *     room="-1000000000000000",
 *     notify_only_broken_pipelines=False,
 *     branches_to_be_notified="all",
 *     push_events=False,
 *     issues_events=False,
 *     confidential_issues_events=False,
 *     merge_requests_events=False,
 *     tag_push_events=False,
 *     note_events=False,
 *     confidential_note_events=False,
 *     pipeline_events=False,
 *     wiki_page_events=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var @default = new GitLab.IntegrationTelegram("default", new()
 *     {
 *         Token = "123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11",
 *         Room = "-1000000000000000",
 *         NotifyOnlyBrokenPipelines = false,
 *         BranchesToBeNotified = "all",
 *         PushEvents = false,
 *         IssuesEvents = false,
 *         ConfidentialIssuesEvents = false,
 *         MergeRequestsEvents = false,
 *         TagPushEvents = false,
 *         NoteEvents = false,
 *         ConfidentialNoteEvents = false,
 *         PipelineEvents = false,
 *         WikiPageEvents = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewIntegrationTelegram(ctx, "default", &gitlab.IntegrationTelegramArgs{
 * 			Token:                     pulumi.String("123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11"),
 * 			Room:                      pulumi.String("-1000000000000000"),
 * 			NotifyOnlyBrokenPipelines: pulumi.Bool(false),
 * 			BranchesToBeNotified:      pulumi.String("all"),
 * 			PushEvents:                pulumi.Bool(false),
 * 			IssuesEvents:              pulumi.Bool(false),
 * 			ConfidentialIssuesEvents:  pulumi.Bool(false),
 * 			MergeRequestsEvents:       pulumi.Bool(false),
 * 			TagPushEvents:             pulumi.Bool(false),
 * 			NoteEvents:                pulumi.Bool(false),
 * 			ConfidentialNoteEvents:    pulumi.Bool(false),
 * 			PipelineEvents:            pulumi.Bool(false),
 * 			WikiPageEvents:            pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.IntegrationTelegram;
 * import com.pulumi.gitlab.IntegrationTelegramArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var default_ = new IntegrationTelegram("default", IntegrationTelegramArgs.builder()
 *             .token("123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11")
 *             .room("-1000000000000000")
 *             .notifyOnlyBrokenPipelines(false)
 *             .branchesToBeNotified("all")
 *             .pushEvents(false)
 *             .issuesEvents(false)
 *             .confidentialIssuesEvents(false)
 *             .mergeRequestsEvents(false)
 *             .tagPushEvents(false)
 *             .noteEvents(false)
 *             .confidentialNoteEvents(false)
 *             .pipelineEvents(false)
 *             .wikiPageEvents(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   default:
 *     type: gitlab:IntegrationTelegram
 *     properties:
 *       token: 123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11
 *       room: '-1000000000000000'
 *       notifyOnlyBrokenPipelines: false
 *       branchesToBeNotified: all
 *       pushEvents: false
 *       issuesEvents: false
 *       confidentialIssuesEvents: false
 *       mergeRequestsEvents: false
 *       tagPushEvents: false
 *       noteEvents: false
 *       confidentialNoteEvents: false
 *       pipelineEvents: false
 *       wikiPageEvents: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_integration_telegram state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/integrationTelegram:IntegrationTelegram default 1
 * ```
 * @property branchesToBeNotified Branches to send notifications for (introduced in GitLab 16.5). Update of this attribute was not supported before Gitlab 16.11 due to API bug. Valid options are `all`, `default`, `protected`, `default_and_protected`.
 * @property confidentialIssuesEvents Enable notifications for confidential issues events.
 * @property confidentialNoteEvents Enable notifications for confidential note events.
 * @property issuesEvents Enable notifications for issues events.
 * @property mergeRequestsEvents Enable notifications for merge requests events.
 * @property noteEvents Enable notifications for note events.
 * @property notifyOnlyBrokenPipelines Send notifications for broken pipelines.
 * @property pipelineEvents Enable notifications for pipeline events.
 * @property project The ID or full path of the project to integrate with Telegram.
 * @property pushEvents Enable notifications for push events.
 * @property room Unique identifier for the target chat or the username of the target channel (in the format `@channelusername`)
 * @property tagPushEvents Enable notifications for tag push events.
 * @property token The Telegram bot token.
 * @property wikiPageEvents Enable notifications for wiki page events.
 */
public data class IntegrationTelegramArgs(
    public val branchesToBeNotified: Output<String>? = null,
    public val confidentialIssuesEvents: Output<Boolean>? = null,
    public val confidentialNoteEvents: Output<Boolean>? = null,
    public val issuesEvents: Output<Boolean>? = null,
    public val mergeRequestsEvents: Output<Boolean>? = null,
    public val noteEvents: Output<Boolean>? = null,
    public val notifyOnlyBrokenPipelines: Output<Boolean>? = null,
    public val pipelineEvents: Output<Boolean>? = null,
    public val project: Output<String>? = null,
    public val pushEvents: Output<Boolean>? = null,
    public val room: Output<String>? = null,
    public val tagPushEvents: Output<Boolean>? = null,
    public val token: Output<String>? = null,
    public val wikiPageEvents: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.IntegrationTelegramArgs> {
    override fun toJava(): com.pulumi.gitlab.IntegrationTelegramArgs =
        com.pulumi.gitlab.IntegrationTelegramArgs.builder()
            .branchesToBeNotified(branchesToBeNotified?.applyValue({ args0 -> args0 }))
            .confidentialIssuesEvents(confidentialIssuesEvents?.applyValue({ args0 -> args0 }))
            .confidentialNoteEvents(confidentialNoteEvents?.applyValue({ args0 -> args0 }))
            .issuesEvents(issuesEvents?.applyValue({ args0 -> args0 }))
            .mergeRequestsEvents(mergeRequestsEvents?.applyValue({ args0 -> args0 }))
            .noteEvents(noteEvents?.applyValue({ args0 -> args0 }))
            .notifyOnlyBrokenPipelines(notifyOnlyBrokenPipelines?.applyValue({ args0 -> args0 }))
            .pipelineEvents(pipelineEvents?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .pushEvents(pushEvents?.applyValue({ args0 -> args0 }))
            .room(room?.applyValue({ args0 -> args0 }))
            .tagPushEvents(tagPushEvents?.applyValue({ args0 -> args0 }))
            .token(token?.applyValue({ args0 -> args0 }))
            .wikiPageEvents(wikiPageEvents?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationTelegramArgs].
 */
@PulumiTagMarker
public class IntegrationTelegramArgsBuilder internal constructor() {
    private var branchesToBeNotified: Output<String>? = null

    private var confidentialIssuesEvents: Output<Boolean>? = null

    private var confidentialNoteEvents: Output<Boolean>? = null

    private var issuesEvents: Output<Boolean>? = null

    private var mergeRequestsEvents: Output<Boolean>? = null

    private var noteEvents: Output<Boolean>? = null

    private var notifyOnlyBrokenPipelines: Output<Boolean>? = null

    private var pipelineEvents: Output<Boolean>? = null

    private var project: Output<String>? = null

    private var pushEvents: Output<Boolean>? = null

    private var room: Output<String>? = null

    private var tagPushEvents: Output<Boolean>? = null

    private var token: Output<String>? = null

    private var wikiPageEvents: Output<Boolean>? = null

    /**
     * @param value Branches to send notifications for (introduced in GitLab 16.5). Update of this attribute was not supported before Gitlab 16.11 due to API bug. Valid options are `all`, `default`, `protected`, `default_and_protected`.
     */
    @JvmName("geunjxvxhkygrrog")
    public suspend fun branchesToBeNotified(`value`: Output<String>) {
        this.branchesToBeNotified = value
    }

    /**
     * @param value Enable notifications for confidential issues events.
     */
    @JvmName("ruqydnjeltimpien")
    public suspend fun confidentialIssuesEvents(`value`: Output<Boolean>) {
        this.confidentialIssuesEvents = value
    }

    /**
     * @param value Enable notifications for confidential note events.
     */
    @JvmName("twbuvddxqinenavg")
    public suspend fun confidentialNoteEvents(`value`: Output<Boolean>) {
        this.confidentialNoteEvents = value
    }

    /**
     * @param value Enable notifications for issues events.
     */
    @JvmName("pgliflfewnefwtky")
    public suspend fun issuesEvents(`value`: Output<Boolean>) {
        this.issuesEvents = value
    }

    /**
     * @param value Enable notifications for merge requests events.
     */
    @JvmName("bmdapvmlgqbfotfx")
    public suspend fun mergeRequestsEvents(`value`: Output<Boolean>) {
        this.mergeRequestsEvents = value
    }

    /**
     * @param value Enable notifications for note events.
     */
    @JvmName("cafopaklgxwuytdl")
    public suspend fun noteEvents(`value`: Output<Boolean>) {
        this.noteEvents = value
    }

    /**
     * @param value Send notifications for broken pipelines.
     */
    @JvmName("jxhliilppiqdrkgu")
    public suspend fun notifyOnlyBrokenPipelines(`value`: Output<Boolean>) {
        this.notifyOnlyBrokenPipelines = value
    }

    /**
     * @param value Enable notifications for pipeline events.
     */
    @JvmName("xwmwuiepwlhepqsc")
    public suspend fun pipelineEvents(`value`: Output<Boolean>) {
        this.pipelineEvents = value
    }

    /**
     * @param value The ID or full path of the project to integrate with Telegram.
     */
    @JvmName("vqxdsrhrigtxmuxy")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Enable notifications for push events.
     */
    @JvmName("shrgwwreoqikwqmj")
    public suspend fun pushEvents(`value`: Output<Boolean>) {
        this.pushEvents = value
    }

    /**
     * @param value Unique identifier for the target chat or the username of the target channel (in the format `@channelusername`)
     */
    @JvmName("teywpgpmatxqhpgf")
    public suspend fun room(`value`: Output<String>) {
        this.room = value
    }

    /**
     * @param value Enable notifications for tag push events.
     */
    @JvmName("xfoayrepwcklrcbi")
    public suspend fun tagPushEvents(`value`: Output<Boolean>) {
        this.tagPushEvents = value
    }

    /**
     * @param value The Telegram bot token.
     */
    @JvmName("egdjlqrejwxjmliw")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value Enable notifications for wiki page events.
     */
    @JvmName("oyoospamtxnpwetp")
    public suspend fun wikiPageEvents(`value`: Output<Boolean>) {
        this.wikiPageEvents = value
    }

    /**
     * @param value Branches to send notifications for (introduced in GitLab 16.5). Update of this attribute was not supported before Gitlab 16.11 due to API bug. Valid options are `all`, `default`, `protected`, `default_and_protected`.
     */
    @JvmName("qiuppnpbsdscsqus")
    public suspend fun branchesToBeNotified(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchesToBeNotified = mapped
    }

    /**
     * @param value Enable notifications for confidential issues events.
     */
    @JvmName("idqglswvoyvyjwhb")
    public suspend fun confidentialIssuesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialIssuesEvents = mapped
    }

    /**
     * @param value Enable notifications for confidential note events.
     */
    @JvmName("nmnqbquvsaodhymd")
    public suspend fun confidentialNoteEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialNoteEvents = mapped
    }

    /**
     * @param value Enable notifications for issues events.
     */
    @JvmName("oyovsqpbswmyneaf")
    public suspend fun issuesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuesEvents = mapped
    }

    /**
     * @param value Enable notifications for merge requests events.
     */
    @JvmName("utxfinonugatmvyb")
    public suspend fun mergeRequestsEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestsEvents = mapped
    }

    /**
     * @param value Enable notifications for note events.
     */
    @JvmName("cfdigpktcebraddt")
    public suspend fun noteEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteEvents = mapped
    }

    /**
     * @param value Send notifications for broken pipelines.
     */
    @JvmName("lvanyppjatluwkep")
    public suspend fun notifyOnlyBrokenPipelines(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyOnlyBrokenPipelines = mapped
    }

    /**
     * @param value Enable notifications for pipeline events.
     */
    @JvmName("mfmueuklggqqskgt")
    public suspend fun pipelineEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineEvents = mapped
    }

    /**
     * @param value The ID or full path of the project to integrate with Telegram.
     */
    @JvmName("ugrryoyuxxmpinik")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Enable notifications for push events.
     */
    @JvmName("tltodcaegflnlrki")
    public suspend fun pushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEvents = mapped
    }

    /**
     * @param value Unique identifier for the target chat or the username of the target channel (in the format `@channelusername`)
     */
    @JvmName("kqvmmwffkwokqqhf")
    public suspend fun room(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.room = mapped
    }

    /**
     * @param value Enable notifications for tag push events.
     */
    @JvmName("lnsyjfqxkjadvuni")
    public suspend fun tagPushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagPushEvents = mapped
    }

    /**
     * @param value The Telegram bot token.
     */
    @JvmName("xbeyeirfuxucxcyn")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    /**
     * @param value Enable notifications for wiki page events.
     */
    @JvmName("conidfonlxoltkxe")
    public suspend fun wikiPageEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wikiPageEvents = mapped
    }

    internal fun build(): IntegrationTelegramArgs = IntegrationTelegramArgs(
        branchesToBeNotified = branchesToBeNotified,
        confidentialIssuesEvents = confidentialIssuesEvents,
        confidentialNoteEvents = confidentialNoteEvents,
        issuesEvents = issuesEvents,
        mergeRequestsEvents = mergeRequestsEvents,
        noteEvents = noteEvents,
        notifyOnlyBrokenPipelines = notifyOnlyBrokenPipelines,
        pipelineEvents = pipelineEvents,
        project = project,
        pushEvents = pushEvents,
        room = room,
        tagPushEvents = tagPushEvents,
        token = token,
        wikiPageEvents = wikiPageEvents,
    )
}
