@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Label].
 */
@PulumiTagMarker
public class LabelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LabelArgs = LabelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LabelArgsBuilder.() -> Unit) {
        val builder = LabelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Label {
        val builtJavaResource = com.pulumi.gitlab.Label(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Label(builtJavaResource)
    }
}

/**
 * The `gitlab.Label` resource allows to manage the lifecycle of a project label.
 * > This resource is deprecated. use `gitlab.ProjectLabel`instead!
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/labels.html#project-labels)
 */
public class Label internal constructor(
    override val javaResource: com.pulumi.gitlab.Label,
) : KotlinCustomResource(javaResource, LabelMapper) {
    /**
     * The color of the label given in 6-digit hex notation with leading '#' sign (e.g. #FFAABB) or one of the [CSS color names](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_keywords).
     */
    public val color: Output<String>
        get() = javaResource.color().applyValue({ args0 -> args0 })

    /**
     * The description of the label.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of the project label.
     */
    public val labelId: Output<Int>
        get() = javaResource.labelId().applyValue({ args0 -> args0 })

    /**
     * The name of the label.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name or id of the project to add the label to.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })
}

public object LabelMapper : ResourceMapper<Label> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.Label::class == javaResource::class

    override fun map(javaResource: Resource): Label = Label(javaResource as com.pulumi.gitlab.Label)
}

/**
 * @see [Label].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Label].
 */
public suspend fun label(name: String, block: suspend LabelResourceBuilder.() -> Unit): Label {
    val builder = LabelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Label].
 * @param name The _unique_ name of the resulting resource.
 */
public fun label(name: String): Label {
    val builder = LabelResourceBuilder()
    builder.name(name)
    return builder.build()
}
