@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.LabelArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.Label` resource allows to manage the lifecycle of a project label.
 * > This resource is deprecated. use `gitlab.ProjectLabel`instead!
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/labels.html#project-labels)
 * @property color The color of the label given in 6-digit hex notation with leading '#' sign (e.g. #FFAABB) or one of the [CSS color names](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_keywords).
 * @property description The description of the label.
 * @property name The name of the label.
 * @property project The name or id of the project to add the label to.
 */
public data class LabelArgs(
    public val color: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.LabelArgs> {
    override fun toJava(): com.pulumi.gitlab.LabelArgs = com.pulumi.gitlab.LabelArgs.builder()
        .color(color?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabelArgs].
 */
@PulumiTagMarker
public class LabelArgsBuilder internal constructor() {
    private var color: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value The color of the label given in 6-digit hex notation with leading '#' sign (e.g. #FFAABB) or one of the [CSS color names](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_keywords).
     */
    @JvmName("cfhldyrxriscyoox")
    public suspend fun color(`value`: Output<String>) {
        this.color = value
    }

    /**
     * @param value The description of the label.
     */
    @JvmName("mxfcwsyrdgtcoovo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the label.
     */
    @JvmName("nacbolsnveffutld")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name or id of the project to add the label to.
     */
    @JvmName("yibnthinedgslagv")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The color of the label given in 6-digit hex notation with leading '#' sign (e.g. #FFAABB) or one of the [CSS color names](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_keywords).
     */
    @JvmName("xvbwmnolfxoahcxe")
    public suspend fun color(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.color = mapped
    }

    /**
     * @param value The description of the label.
     */
    @JvmName("hehmgvdcrxkhtrox")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the label.
     */
    @JvmName("ixlofruocbflivvg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name or id of the project to add the label to.
     */
    @JvmName("kpwnrxorihkpilnx")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): LabelArgs = LabelArgs(
        color = color,
        description = description,
        name = name,
        project = project,
    )
}
