@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.MemberRoleArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.MemberRole` resource allows to manage the lifecycle of a custom member role.
 * Custom roles allow an organization to create user roles with the precise privileges and permissions required for that organization’s needs.
 * > This resource requires an Ultimate license.
 * > Most custom roles are considered billable users that use a seat. [Custom roles billing and seat usage](https://docs.gitlab.com/ee/user/custom_roles.html#billing-and-seat-usage)
 * > There can be only 10 custom roles on your instance or namespace. See [issue 450929](https://gitlab.com/gitlab-org/gitlab/-/issues/450929) for more details.
 * **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#mutationmemberrolecreate)
 * @property baseAccessLevel The base access level for the custom role. Valid values are: `DEVELOPER`, `GUEST`, `MAINTAINER`, `MINIMAL_ACCESS`, `OWNER`, `REPORTER`
 * @property description Description for the member role.
 * @property enabledPermissions All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_CODE`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
 * @property groupPath Full path of the namespace to create the member role in. **Required for SAAS** **Not allowed for self-managed**
 * @property name Name for the member role.
 */
public data class MemberRoleArgs(
    public val baseAccessLevel: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enabledPermissions: Output<List<String>>? = null,
    public val groupPath: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.MemberRoleArgs> {
    override fun toJava(): com.pulumi.gitlab.MemberRoleArgs =
        com.pulumi.gitlab.MemberRoleArgs.builder()
            .baseAccessLevel(baseAccessLevel?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enabledPermissions(enabledPermissions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .groupPath(groupPath?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MemberRoleArgs].
 */
@PulumiTagMarker
public class MemberRoleArgsBuilder internal constructor() {
    private var baseAccessLevel: Output<String>? = null

    private var description: Output<String>? = null

    private var enabledPermissions: Output<List<String>>? = null

    private var groupPath: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The base access level for the custom role. Valid values are: `DEVELOPER`, `GUEST`, `MAINTAINER`, `MINIMAL_ACCESS`, `OWNER`, `REPORTER`
     */
    @JvmName("rdcmbkcaxrgiyvpa")
    public suspend fun baseAccessLevel(`value`: Output<String>) {
        this.baseAccessLevel = value
    }

    /**
     * @param value Description for the member role.
     */
    @JvmName("kqejuxovhdwhpxgs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_CODE`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
     */
    @JvmName("bdtxobcsjgoptmbk")
    public suspend fun enabledPermissions(`value`: Output<List<String>>) {
        this.enabledPermissions = value
    }

    @JvmName("aoqroirlanosvuhl")
    public suspend fun enabledPermissions(vararg values: Output<String>) {
        this.enabledPermissions = Output.all(values.asList())
    }

    /**
     * @param values All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_CODE`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
     */
    @JvmName("dspyaebegenvbsxu")
    public suspend fun enabledPermissions(values: List<Output<String>>) {
        this.enabledPermissions = Output.all(values)
    }

    /**
     * @param value Full path of the namespace to create the member role in. **Required for SAAS** **Not allowed for self-managed**
     */
    @JvmName("bgtqcfqrrromfkya")
    public suspend fun groupPath(`value`: Output<String>) {
        this.groupPath = value
    }

    /**
     * @param value Name for the member role.
     */
    @JvmName("cyrmlrhkevlqbpun")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The base access level for the custom role. Valid values are: `DEVELOPER`, `GUEST`, `MAINTAINER`, `MINIMAL_ACCESS`, `OWNER`, `REPORTER`
     */
    @JvmName("ukbabhnvofcwmjdn")
    public suspend fun baseAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseAccessLevel = mapped
    }

    /**
     * @param value Description for the member role.
     */
    @JvmName("mktybywsgwsjpbkb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_CODE`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
     */
    @JvmName("ljpsdteuodmmpjwk")
    public suspend fun enabledPermissions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledPermissions = mapped
    }

    /**
     * @param values All permissions enabled for the custom role. Valid values are: `ADMIN_CICD_VARIABLES`, `ADMIN_COMPLIANCE_FRAMEWORK`, `ADMIN_GROUP_MEMBER`, `ADMIN_INTEGRATIONS`, `ADMIN_MERGE_REQUEST`, `ADMIN_PUSH_RULES`, `ADMIN_RUNNERS`, `ADMIN_TERRAFORM_STATE`, `ADMIN_VULNERABILITY`, `ADMIN_WEB_HOOK`, `ARCHIVE_PROJECT`, `MANAGE_DEPLOY_TOKENS`, `MANAGE_GROUP_ACCESS_TOKENS`, `MANAGE_MERGE_REQUEST_SETTINGS`, `MANAGE_PROJECT_ACCESS_TOKENS`, `MANAGE_SECURITY_POLICY_LINK`, `READ_CODE`, `READ_CRM_CONTACT`, `READ_DEPENDENCY`, `READ_RUNNERS`, `READ_VULNERABILITY`, `REMOVE_GROUP`, `REMOVE_PROJECT`
     */
    @JvmName("xsqausrisuvojwhi")
    public suspend fun enabledPermissions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledPermissions = mapped
    }

    /**
     * @param value Full path of the namespace to create the member role in. **Required for SAAS** **Not allowed for self-managed**
     */
    @JvmName("leektuumuflpbkvc")
    public suspend fun groupPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupPath = mapped
    }

    /**
     * @param value Name for the member role.
     */
    @JvmName("mpsxxlbldqlhktfn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): MemberRoleArgs = MemberRoleArgs(
        baseAccessLevel = baseAccessLevel,
        description = description,
        enabledPermissions = enabledPermissions,
        groupPath = groupPath,
        name = name,
    )
}
