@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.PagesDomainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.PagesDomain` resource allows connecting custom domains and TLS certificates in GitLab Pages.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/pages_domains.html)
 * ## Import
 * GitLab pages domain can be imported using an id made up of `projectId:domain` _without_ the http protocol, e.g.
 * ```sh
 * $ pulumi import gitlab:index/pagesDomain:PagesDomain this 123:example.com
 * ```
 * @property autoSslEnabled Enables [automatic generation](https://docs.gitlab.com/ee/user/project/pages/custom_domains_ssl_tls_certification/lets_encrypt_integration.html) of SSL certificates issued by Let’s Encrypt for custom domains. When this is set to "true", certificate can't be provided.
 * @property certificate The certificate in PEM format with intermediates following in most specific to least specific order.
 * @property domain The custom domain indicated by the user.
 * @property expired Whether the certificate is expired.
 * @property key The certificate key in PEM format.
 * @property project The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding) owned by the authenticated user.
 */
public data class PagesDomainArgs(
    public val autoSslEnabled: Output<Boolean>? = null,
    public val certificate: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val expired: Output<Boolean>? = null,
    public val key: Output<String>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.PagesDomainArgs> {
    override fun toJava(): com.pulumi.gitlab.PagesDomainArgs =
        com.pulumi.gitlab.PagesDomainArgs.builder()
            .autoSslEnabled(autoSslEnabled?.applyValue({ args0 -> args0 }))
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .expired(expired?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PagesDomainArgs].
 */
@PulumiTagMarker
public class PagesDomainArgsBuilder internal constructor() {
    private var autoSslEnabled: Output<Boolean>? = null

    private var certificate: Output<String>? = null

    private var domain: Output<String>? = null

    private var expired: Output<Boolean>? = null

    private var key: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value Enables [automatic generation](https://docs.gitlab.com/ee/user/project/pages/custom_domains_ssl_tls_certification/lets_encrypt_integration.html) of SSL certificates issued by Let’s Encrypt for custom domains. When this is set to "true", certificate can't be provided.
     */
    @JvmName("uieyuwqiqmrcjfhf")
    public suspend fun autoSslEnabled(`value`: Output<Boolean>) {
        this.autoSslEnabled = value
    }

    /**
     * @param value The certificate in PEM format with intermediates following in most specific to least specific order.
     */
    @JvmName("talfstusfvwqfxew")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value The custom domain indicated by the user.
     */
    @JvmName("vhwhweranjcfjuth")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value Whether the certificate is expired.
     */
    @JvmName("ektklnjosadlqcjq")
    public suspend fun expired(`value`: Output<Boolean>) {
        this.expired = value
    }

    /**
     * @param value The certificate key in PEM format.
     */
    @JvmName("yhuuabrhhtngfnbb")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding) owned by the authenticated user.
     */
    @JvmName("toceeoryxbbxpaqd")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Enables [automatic generation](https://docs.gitlab.com/ee/user/project/pages/custom_domains_ssl_tls_certification/lets_encrypt_integration.html) of SSL certificates issued by Let’s Encrypt for custom domains. When this is set to "true", certificate can't be provided.
     */
    @JvmName("ilcnqknltxeojdyg")
    public suspend fun autoSslEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoSslEnabled = mapped
    }

    /**
     * @param value The certificate in PEM format with intermediates following in most specific to least specific order.
     */
    @JvmName("ajpcmfhrxsnkdvcg")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value The custom domain indicated by the user.
     */
    @JvmName("iuskwydebrxwajet")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value Whether the certificate is expired.
     */
    @JvmName("ilxntkncrokgihep")
    public suspend fun expired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expired = mapped
    }

    /**
     * @param value The certificate key in PEM format.
     */
    @JvmName("kejbsbodqcyjbfyq")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding) owned by the authenticated user.
     */
    @JvmName("ygnhjwmlkkwlmuio")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): PagesDomainArgs = PagesDomainArgs(
        autoSslEnabled = autoSslEnabled,
        certificate = certificate,
        domain = domain,
        expired = expired,
        key = key,
        project = project,
    )
}
