@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PipelineSchedule].
 */
@PulumiTagMarker
public class PipelineScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineScheduleArgs = PipelineScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineScheduleArgsBuilder.() -> Unit) {
        val builder = PipelineScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PipelineSchedule {
        val builtJavaResource = com.pulumi.gitlab.PipelineSchedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PipelineSchedule(builtJavaResource)
    }
}

/**
 * The `gitlab.PipelineSchedule` resource allows to manage the lifecycle of a scheduled pipeline.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/pipeline_schedules.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.PipelineSchedule("example", {
 *     project: "12345",
 *     description: "Used to schedule builds",
 *     ref: "refs/heads/main",
 *     cron: "0 1 * * *",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.PipelineSchedule("example",
 *     project="12345",
 *     description="Used to schedule builds",
 *     ref="refs/heads/main",
 *     cron="0 1 * * *")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.PipelineSchedule("example", new()
 *     {
 *         Project = "12345",
 *         Description = "Used to schedule builds",
 *         Ref = "refs/heads/main",
 *         Cron = "0 1 * * *",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewPipelineSchedule(ctx, "example", &gitlab.PipelineScheduleArgs{
 * 			Project:     pulumi.String("12345"),
 * 			Description: pulumi.String("Used to schedule builds"),
 * 			Ref:         pulumi.String("refs/heads/main"),
 * 			Cron:        pulumi.String("0 1 * * *"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.PipelineSchedule;
 * import com.pulumi.gitlab.PipelineScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PipelineSchedule("example", PipelineScheduleArgs.builder()
 *             .project("12345")
 *             .description("Used to schedule builds")
 *             .ref("refs/heads/main")
 *             .cron("0 1 * * *")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:PipelineSchedule
 *     properties:
 *       project: '12345'
 *       description: Used to schedule builds
 *       ref: refs/heads/main
 *       cron: 0 1 * * *
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab pipeline schedules can be imported using an id made up of `{project_id}:{pipeline_schedule_id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/pipelineSchedule:PipelineSchedule test 1:3
 * ```
 */
public class PipelineSchedule internal constructor(
    override val javaResource: com.pulumi.gitlab.PipelineSchedule,
) : KotlinCustomResource(javaResource, PipelineScheduleMapper) {
    /**
     * The activation of pipeline schedule. If false is set, the pipeline schedule will deactivated initially.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * The cron (e.g. `0 1 * * *`).
     */
    public val cron: Output<String>
        get() = javaResource.cron().applyValue({ args0 -> args0 })

    /**
     * The timezone.
     */
    public val cronTimezone: Output<String>
        get() = javaResource.cronTimezone().applyValue({ args0 -> args0 })

    /**
     * The description of the pipeline schedule.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The ID of the user that owns the pipeline schedule.
     */
    public val owner: Output<Int>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * The pipeline schedule id.
     */
    public val pipelineScheduleId: Output<Int>
        get() = javaResource.pipelineScheduleId().applyValue({ args0 -> args0 })

    /**
     * The name or id of the project to add the schedule to.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The branch/tag name to be triggered. This must be the full branch reference, for example: `refs/heads/main`, not `main`.
     */
    public val ref: Output<String>
        get() = javaResource.ref().applyValue({ args0 -> args0 })

    public val takeOwnership: Output<Boolean>
        get() = javaResource.takeOwnership().applyValue({ args0 -> args0 })
}

public object PipelineScheduleMapper : ResourceMapper<PipelineSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.PipelineSchedule::class == javaResource::class

    override fun map(javaResource: Resource): PipelineSchedule = PipelineSchedule(
        javaResource as
            com.pulumi.gitlab.PipelineSchedule,
    )
}

/**
 * @see [PipelineSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PipelineSchedule].
 */
public suspend fun pipelineSchedule(
    name: String,
    block: suspend PipelineScheduleResourceBuilder.() -> Unit,
): PipelineSchedule {
    val builder = PipelineScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PipelineSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipelineSchedule(name: String): PipelineSchedule {
    val builder = PipelineScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
