@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PipelineScheduleVariable].
 */
@PulumiTagMarker
public class PipelineScheduleVariableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineScheduleVariableArgs = PipelineScheduleVariableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineScheduleVariableArgsBuilder.() -> Unit) {
        val builder = PipelineScheduleVariableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PipelineScheduleVariable {
        val builtJavaResource = com.pulumi.gitlab.PipelineScheduleVariable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PipelineScheduleVariable(builtJavaResource)
    }
}

/**
 * The `gitlab.PipelineScheduleVariable` resource allows to manage the lifecycle of a variable for a pipeline schedule.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/pipeline_schedules.html#pipeline-schedule-variables)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.PipelineSchedule("example", {
 *     project: "12345",
 *     description: "Used to schedule builds",
 *     ref: "master",
 *     cron: "0 1 * * *",
 * });
 * const examplePipelineScheduleVariable = new gitlab.PipelineScheduleVariable("example", {
 *     project: example.project,
 *     pipelineScheduleId: example.pipelineScheduleId,
 *     key: "EXAMPLE_KEY",
 *     value: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.PipelineSchedule("example",
 *     project="12345",
 *     description="Used to schedule builds",
 *     ref="master",
 *     cron="0 1 * * *")
 * example_pipeline_schedule_variable = gitlab.PipelineScheduleVariable("example",
 *     project=example.project,
 *     pipeline_schedule_id=example.pipeline_schedule_id,
 *     key="EXAMPLE_KEY",
 *     value="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.PipelineSchedule("example", new()
 *     {
 *         Project = "12345",
 *         Description = "Used to schedule builds",
 *         Ref = "master",
 *         Cron = "0 1 * * *",
 *     });
 *     var examplePipelineScheduleVariable = new GitLab.PipelineScheduleVariable("example", new()
 *     {
 *         Project = example.Project,
 *         PipelineScheduleId = example.PipelineScheduleId,
 *         Key = "EXAMPLE_KEY",
 *         Value = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := gitlab.NewPipelineSchedule(ctx, "example", &gitlab.PipelineScheduleArgs{
 * 			Project:     pulumi.String("12345"),
 * 			Description: pulumi.String("Used to schedule builds"),
 * 			Ref:         pulumi.String("master"),
 * 			Cron:        pulumi.String("0 1 * * *"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewPipelineScheduleVariable(ctx, "example", &gitlab.PipelineScheduleVariableArgs{
 * 			Project:            example.Project,
 * 			PipelineScheduleId: example.PipelineScheduleId,
 * 			Key:                pulumi.String("EXAMPLE_KEY"),
 * 			Value:              pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.PipelineSchedule;
 * import com.pulumi.gitlab.PipelineScheduleArgs;
 * import com.pulumi.gitlab.PipelineScheduleVariable;
 * import com.pulumi.gitlab.PipelineScheduleVariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PipelineSchedule("example", PipelineScheduleArgs.builder()
 *             .project("12345")
 *             .description("Used to schedule builds")
 *             .ref("master")
 *             .cron("0 1 * * *")
 *             .build());
 *         var examplePipelineScheduleVariable = new PipelineScheduleVariable("examplePipelineScheduleVariable", PipelineScheduleVariableArgs.builder()
 *             .project(example.project())
 *             .pipelineScheduleId(example.pipelineScheduleId())
 *             .key("EXAMPLE_KEY")
 *             .value("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:PipelineSchedule
 *     properties:
 *       project: '12345'
 *       description: Used to schedule builds
 *       ref: master
 *       cron: 0 1 * * *
 *   examplePipelineScheduleVariable:
 *     type: gitlab:PipelineScheduleVariable
 *     name: example
 *     properties:
 *       project: ${example.project}
 *       pipelineScheduleId: ${example.pipelineScheduleId}
 *       key: EXAMPLE_KEY
 *       value: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Pipeline schedule variables can be imported using an id made up of `project_id:pipeline_schedule_id:key`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/pipelineScheduleVariable:PipelineScheduleVariable example 123456789:13:mykey
 * ```
 */
public class PipelineScheduleVariable internal constructor(
    override val javaResource: com.pulumi.gitlab.PipelineScheduleVariable,
) : KotlinCustomResource(javaResource, PipelineScheduleVariableMapper) {
    /**
     * Name of the variable.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * The id of the pipeline schedule.
     */
    public val pipelineScheduleId: Output<Int>
        get() = javaResource.pipelineScheduleId().applyValue({ args0 -> args0 })

    /**
     * The id of the project to add the schedule to.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Value of the variable.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })

    /**
     * The type of a variable. Available types are: `env_var`, `file`. Default is `env_var`.
     */
    public val variableType: Output<String>
        get() = javaResource.variableType().applyValue({ args0 -> args0 })
}

public object PipelineScheduleVariableMapper : ResourceMapper<PipelineScheduleVariable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.PipelineScheduleVariable::class == javaResource::class

    override fun map(javaResource: Resource): PipelineScheduleVariable =
        PipelineScheduleVariable(javaResource as com.pulumi.gitlab.PipelineScheduleVariable)
}

/**
 * @see [PipelineScheduleVariable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PipelineScheduleVariable].
 */
public suspend fun pipelineScheduleVariable(
    name: String,
    block: suspend PipelineScheduleVariableResourceBuilder.() -> Unit,
): PipelineScheduleVariable {
    val builder = PipelineScheduleVariableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PipelineScheduleVariable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipelineScheduleVariable(name: String): PipelineScheduleVariable {
    val builder = PipelineScheduleVariableResourceBuilder()
    builder.name(name)
    return builder.build()
}
