@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.PipelineScheduleVariableArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.PipelineScheduleVariable` resource allows to manage the lifecycle of a variable for a pipeline schedule.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/pipeline_schedules.html#pipeline-schedule-variables)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.PipelineSchedule("example", {
 *     project: "12345",
 *     description: "Used to schedule builds",
 *     ref: "master",
 *     cron: "0 1 * * *",
 * });
 * const examplePipelineScheduleVariable = new gitlab.PipelineScheduleVariable("example", {
 *     project: example.project,
 *     pipelineScheduleId: example.pipelineScheduleId,
 *     key: "EXAMPLE_KEY",
 *     value: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.PipelineSchedule("example",
 *     project="12345",
 *     description="Used to schedule builds",
 *     ref="master",
 *     cron="0 1 * * *")
 * example_pipeline_schedule_variable = gitlab.PipelineScheduleVariable("example",
 *     project=example.project,
 *     pipeline_schedule_id=example.pipeline_schedule_id,
 *     key="EXAMPLE_KEY",
 *     value="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.PipelineSchedule("example", new()
 *     {
 *         Project = "12345",
 *         Description = "Used to schedule builds",
 *         Ref = "master",
 *         Cron = "0 1 * * *",
 *     });
 *     var examplePipelineScheduleVariable = new GitLab.PipelineScheduleVariable("example", new()
 *     {
 *         Project = example.Project,
 *         PipelineScheduleId = example.PipelineScheduleId,
 *         Key = "EXAMPLE_KEY",
 *         Value = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := gitlab.NewPipelineSchedule(ctx, "example", &gitlab.PipelineScheduleArgs{
 * 			Project:     pulumi.String("12345"),
 * 			Description: pulumi.String("Used to schedule builds"),
 * 			Ref:         pulumi.String("master"),
 * 			Cron:        pulumi.String("0 1 * * *"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewPipelineScheduleVariable(ctx, "example", &gitlab.PipelineScheduleVariableArgs{
 * 			Project:            example.Project,
 * 			PipelineScheduleId: example.PipelineScheduleId,
 * 			Key:                pulumi.String("EXAMPLE_KEY"),
 * 			Value:              pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.PipelineSchedule;
 * import com.pulumi.gitlab.PipelineScheduleArgs;
 * import com.pulumi.gitlab.PipelineScheduleVariable;
 * import com.pulumi.gitlab.PipelineScheduleVariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PipelineSchedule("example", PipelineScheduleArgs.builder()
 *             .project("12345")
 *             .description("Used to schedule builds")
 *             .ref("master")
 *             .cron("0 1 * * *")
 *             .build());
 *         var examplePipelineScheduleVariable = new PipelineScheduleVariable("examplePipelineScheduleVariable", PipelineScheduleVariableArgs.builder()
 *             .project(example.project())
 *             .pipelineScheduleId(example.pipelineScheduleId())
 *             .key("EXAMPLE_KEY")
 *             .value("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:PipelineSchedule
 *     properties:
 *       project: '12345'
 *       description: Used to schedule builds
 *       ref: master
 *       cron: 0 1 * * *
 *   examplePipelineScheduleVariable:
 *     type: gitlab:PipelineScheduleVariable
 *     name: example
 *     properties:
 *       project: ${example.project}
 *       pipelineScheduleId: ${example.pipelineScheduleId}
 *       key: EXAMPLE_KEY
 *       value: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Pipeline schedule variables can be imported using an id made up of `project_id:pipeline_schedule_id:key`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/pipelineScheduleVariable:PipelineScheduleVariable example 123456789:13:mykey
 * ```
 * @property key Name of the variable.
 * @property pipelineScheduleId The id of the pipeline schedule.
 * @property project The id of the project to add the schedule to.
 * @property value Value of the variable.
 * @property variableType The type of a variable. Available types are: `env_var`, `file`. Default is `env_var`.
 */
public data class PipelineScheduleVariableArgs(
    public val key: Output<String>? = null,
    public val pipelineScheduleId: Output<Int>? = null,
    public val project: Output<String>? = null,
    public val `value`: Output<String>? = null,
    public val variableType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.PipelineScheduleVariableArgs> {
    override fun toJava(): com.pulumi.gitlab.PipelineScheduleVariableArgs =
        com.pulumi.gitlab.PipelineScheduleVariableArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .pipelineScheduleId(pipelineScheduleId?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .variableType(variableType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineScheduleVariableArgs].
 */
@PulumiTagMarker
public class PipelineScheduleVariableArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var pipelineScheduleId: Output<Int>? = null

    private var project: Output<String>? = null

    private var `value`: Output<String>? = null

    private var variableType: Output<String>? = null

    /**
     * @param value Name of the variable.
     */
    @JvmName("kawbvmokrpbiyeie")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The id of the pipeline schedule.
     */
    @JvmName("ibaekgyqpxkokolj")
    public suspend fun pipelineScheduleId(`value`: Output<Int>) {
        this.pipelineScheduleId = value
    }

    /**
     * @param value The id of the project to add the schedule to.
     */
    @JvmName("savfnbaolnfvrimg")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Value of the variable.
     */
    @JvmName("hkvguyxdtxnxrupu")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The type of a variable. Available types are: `env_var`, `file`. Default is `env_var`.
     */
    @JvmName("pjloysrmgsvjadvc")
    public suspend fun variableType(`value`: Output<String>) {
        this.variableType = value
    }

    /**
     * @param value Name of the variable.
     */
    @JvmName("dkupvobwgmnhdnpn")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The id of the pipeline schedule.
     */
    @JvmName("hglccqvemboeecvl")
    public suspend fun pipelineScheduleId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineScheduleId = mapped
    }

    /**
     * @param value The id of the project to add the schedule to.
     */
    @JvmName("dvkocfwsvspstsuk")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Value of the variable.
     */
    @JvmName("kafahwijhpfecail")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value The type of a variable. Available types are: `env_var`, `file`. Default is `env_var`.
     */
    @JvmName("ohfuonnjkwdryfrq")
    public suspend fun variableType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variableType = mapped
    }

    internal fun build(): PipelineScheduleVariableArgs = PipelineScheduleVariableArgs(
        key = key,
        pipelineScheduleId = pipelineScheduleId,
        project = project,
        `value` = `value`,
        variableType = variableType,
    )
}
