@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PipelineTrigger].
 */
@PulumiTagMarker
public class PipelineTriggerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineTriggerArgs = PipelineTriggerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineTriggerArgsBuilder.() -> Unit) {
        val builder = PipelineTriggerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PipelineTrigger {
        val builtJavaResource = com.pulumi.gitlab.PipelineTrigger(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PipelineTrigger(builtJavaResource)
    }
}

/**
 * The `gitlab.PipelineTrigger` resource allows to manage the lifecycle of a pipeline trigger.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/pipeline_triggers.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.PipelineTrigger("example", {
 *     project: "12345",
 *     description: "Used to trigger builds",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.PipelineTrigger("example",
 *     project="12345",
 *     description="Used to trigger builds")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.PipelineTrigger("example", new()
 *     {
 *         Project = "12345",
 *         Description = "Used to trigger builds",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewPipelineTrigger(ctx, "example", &gitlab.PipelineTriggerArgs{
 * 			Project:     pulumi.String("12345"),
 * 			Description: pulumi.String("Used to trigger builds"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.PipelineTrigger;
 * import com.pulumi.gitlab.PipelineTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PipelineTrigger("example", PipelineTriggerArgs.builder()
 *             .project("12345")
 *             .description("Used to trigger builds")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:PipelineTrigger
 *     properties:
 *       project: '12345'
 *       description: Used to trigger builds
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab pipeline triggers can be imported using an id made up of `{project_id}:{pipeline_trigger_id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/pipelineTrigger:PipelineTrigger test 1:3
 * ```
 */
public class PipelineTrigger internal constructor(
    override val javaResource: com.pulumi.gitlab.PipelineTrigger,
) : KotlinCustomResource(javaResource, PipelineTriggerMapper) {
    /**
     * The description of the pipeline trigger.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The pipeline trigger id.
     */
    public val pipelineTriggerId: Output<Int>
        get() = javaResource.pipelineTriggerId().applyValue({ args0 -> args0 })

    /**
     * The name or id of the project to add the trigger to.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The pipeline trigger token. This value is not available during import.
     */
    public val token: Output<String>
        get() = javaResource.token().applyValue({ args0 -> args0 })
}

public object PipelineTriggerMapper : ResourceMapper<PipelineTrigger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.PipelineTrigger::class == javaResource::class

    override fun map(javaResource: Resource): PipelineTrigger = PipelineTrigger(
        javaResource as
            com.pulumi.gitlab.PipelineTrigger,
    )
}

/**
 * @see [PipelineTrigger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PipelineTrigger].
 */
public suspend fun pipelineTrigger(
    name: String,
    block: suspend PipelineTriggerResourceBuilder.() -> Unit,
): PipelineTrigger {
    val builder = PipelineTriggerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PipelineTrigger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipelineTrigger(name: String): PipelineTrigger {
    val builder = PipelineTriggerResourceBuilder()
    builder.name(name)
    return builder.build()
}
