@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.PipelineTriggerArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.PipelineTrigger` resource allows to manage the lifecycle of a pipeline trigger.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/pipeline_triggers.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.PipelineTrigger("example", {
 *     project: "12345",
 *     description: "Used to trigger builds",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.PipelineTrigger("example",
 *     project="12345",
 *     description="Used to trigger builds")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.PipelineTrigger("example", new()
 *     {
 *         Project = "12345",
 *         Description = "Used to trigger builds",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewPipelineTrigger(ctx, "example", &gitlab.PipelineTriggerArgs{
 * 			Project:     pulumi.String("12345"),
 * 			Description: pulumi.String("Used to trigger builds"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.PipelineTrigger;
 * import com.pulumi.gitlab.PipelineTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PipelineTrigger("example", PipelineTriggerArgs.builder()
 *             .project("12345")
 *             .description("Used to trigger builds")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:PipelineTrigger
 *     properties:
 *       project: '12345'
 *       description: Used to trigger builds
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab pipeline triggers can be imported using an id made up of `{project_id}:{pipeline_trigger_id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/pipelineTrigger:PipelineTrigger test 1:3
 * ```
 * @property description The description of the pipeline trigger.
 * @property project The name or id of the project to add the trigger to.
 */
public data class PipelineTriggerArgs(
    public val description: Output<String>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.PipelineTriggerArgs> {
    override fun toJava(): com.pulumi.gitlab.PipelineTriggerArgs =
        com.pulumi.gitlab.PipelineTriggerArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineTriggerArgs].
 */
@PulumiTagMarker
public class PipelineTriggerArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value The description of the pipeline trigger.
     */
    @JvmName("quoevkkiqpkjpwko")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name or id of the project to add the trigger to.
     */
    @JvmName("cphrruqcfsehfstj")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The description of the pipeline trigger.
     */
    @JvmName("rcpbykpwjpyksqtr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name or id of the project to add the trigger to.
     */
    @JvmName("lgeuryudhtebvfly")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): PipelineTriggerArgs = PipelineTriggerArgs(
        description = description,
        project = project,
    )
}
