@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.ProjectAccessTokenRotationConfiguration
import com.pulumi.gitlab.kotlin.outputs.ProjectAccessTokenRotationConfiguration.Companion.toKotlin
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ProjectAccessToken].
 */
@PulumiTagMarker
public class ProjectAccessTokenResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectAccessTokenArgs = ProjectAccessTokenArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectAccessTokenArgsBuilder.() -> Unit) {
        val builder = ProjectAccessTokenArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectAccessToken {
        val builtJavaResource = com.pulumi.gitlab.ProjectAccessToken(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectAccessToken(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectAccessToken` resource allows to manage the lifecycle of a project access token.
 * > Observability scopes are in beta and may not work on all instances. See more details in [the documentation](https://docs.gitlab.com/ee/operations/tracing.html)
 * > Use `rotation_configuration` to automatically rotate tokens instead of using `timestamp()` as timestamp will cause changes with every plan. `pulumi up` must still be run to rotate the token.
 * > Due to [Automatic reuse detection](https://docs.gitlab.com/ee/api/project_access_tokens.html#automatic-reuse-detection) it's possible that a new Project Access Token will immediately be revoked. Check if an old process using the old token is running if this happens.
 * **Upstream API**: [GitLab API docs](https://docs.gitlab.com/ee/api/project_access_tokens.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.ProjectAccessToken("example", {
 *     project: "25",
 *     name: "Example project access token",
 *     expiresAt: "2020-03-14",
 *     accessLevel: "reporter",
 *     scopes: ["api"],
 * });
 * const exampleProjectVariable = new gitlab.ProjectVariable("example", {
 *     project: exampleGitlabProject.id,
 *     key: "pat",
 *     value: example.token,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.ProjectAccessToken("example",
 *     project="25",
 *     name="Example project access token",
 *     expires_at="2020-03-14",
 *     access_level="reporter",
 *     scopes=["api"])
 * example_project_variable = gitlab.ProjectVariable("example",
 *     project=example_gitlab_project["id"],
 *     key="pat",
 *     value=example.token)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.ProjectAccessToken("example", new()
 *     {
 *         Project = "25",
 *         Name = "Example project access token",
 *         ExpiresAt = "2020-03-14",
 *         AccessLevel = "reporter",
 *         Scopes = new[]
 *         {
 *             "api",
 *         },
 *     });
 *     var exampleProjectVariable = new GitLab.ProjectVariable("example", new()
 *     {
 *         Project = exampleGitlabProject.Id,
 *         Key = "pat",
 *         Value = example.Token,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := gitlab.NewProjectAccessToken(ctx, "example", &gitlab.ProjectAccessTokenArgs{
 * 			Project:     pulumi.String("25"),
 * 			Name:        pulumi.String("Example project access token"),
 * 			ExpiresAt:   pulumi.String("2020-03-14"),
 * 			AccessLevel: pulumi.String("reporter"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("api"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectVariable(ctx, "example", &gitlab.ProjectVariableArgs{
 * 			Project: pulumi.Any(exampleGitlabProject.Id),
 * 			Key:     pulumi.String("pat"),
 * 			Value:   example.Token,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectAccessToken;
 * import com.pulumi.gitlab.ProjectAccessTokenArgs;
 * import com.pulumi.gitlab.ProjectVariable;
 * import com.pulumi.gitlab.ProjectVariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProjectAccessToken("example", ProjectAccessTokenArgs.builder()
 *             .project("25")
 *             .name("Example project access token")
 *             .expiresAt("2020-03-14")
 *             .accessLevel("reporter")
 *             .scopes("api")
 *             .build());
 *         var exampleProjectVariable = new ProjectVariable("exampleProjectVariable", ProjectVariableArgs.builder()
 *             .project(exampleGitlabProject.id())
 *             .key("pat")
 *             .value(example.token())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:ProjectAccessToken
 *     properties:
 *       project: '25'
 *       name: Example project access token
 *       expiresAt: 2020-03-14
 *       accessLevel: reporter
 *       scopes:
 *         - api
 *   exampleProjectVariable:
 *     type: gitlab:ProjectVariable
 *     name: example
 *     properties:
 *       project: ${exampleGitlabProject.id}
 *       key: pat
 *       value: ${example.token}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * A GitLab Project Access Token can be imported using a key composed of `<project-id>:<token-id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectAccessToken:ProjectAccessToken example "12345:1"
 * ```
 * NOTE: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.
 */
public class ProjectAccessToken internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectAccessToken,
) : KotlinCustomResource(javaResource, ProjectAccessTokenMapper) {
    /**
     * The access level for the project access token. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`. Default is `maintainer`.
     */
    public val accessLevel: Output<String>
        get() = javaResource.accessLevel().applyValue({ args0 -> args0 })

    /**
     * True if the token is active.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * Time the token has been created, RFC3339 format.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * When the token will expire, YYYY-MM-DD format. Is automatically set when `rotation_configuration` is used.
     */
    public val expiresAt: Output<String>
        get() = javaResource.expiresAt().applyValue({ args0 -> args0 })

    /**
     * The name of the project access token.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID or full path of the project.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * True if the token is revoked.
     */
    public val revoked: Output<Boolean>
        get() = javaResource.revoked().applyValue({ args0 -> args0 })

    /**
     * The configuration for when to rotate a token automatically. Will not rotate a token until `pulumi up` is run.
     */
    public val rotationConfiguration: Output<ProjectAccessTokenRotationConfiguration>?
        get() = javaResource.rotationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The scopes of the project access token. valid values are: `api`, `read_api`, `read_registry`, `write_registry`, `read_repository`, `write_repository`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_observability`, `write_observability`
     */
    public val scopes: Output<List<String>>
        get() = javaResource.scopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The token of the project access token. **Note**: the token is not available for imported resources.
     */
    public val token: Output<String>
        get() = javaResource.token().applyValue({ args0 -> args0 })

    /**
     * The user_id associated to the token.
     */
    public val userId: Output<Int>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object ProjectAccessTokenMapper : ResourceMapper<ProjectAccessToken> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectAccessToken::class == javaResource::class

    override fun map(javaResource: Resource): ProjectAccessToken = ProjectAccessToken(
        javaResource as
            com.pulumi.gitlab.ProjectAccessToken,
    )
}

/**
 * @see [ProjectAccessToken].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectAccessToken].
 */
public suspend fun projectAccessToken(
    name: String,
    block: suspend ProjectAccessTokenResourceBuilder.() -> Unit,
): ProjectAccessToken {
    val builder = ProjectAccessTokenResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectAccessToken].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectAccessToken(name: String): ProjectAccessToken {
    val builder = ProjectAccessTokenResourceBuilder()
    builder.name(name)
    return builder.build()
}
