@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ProjectApprovalRule].
 */
@PulumiTagMarker
public class ProjectApprovalRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectApprovalRuleArgs = ProjectApprovalRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectApprovalRuleArgsBuilder.() -> Unit) {
        val builder = ProjectApprovalRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectApprovalRule {
        val builtJavaResource = com.pulumi.gitlab.ProjectApprovalRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectApprovalRule(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ## Import
 * GitLab project approval rules can be imported using a key composed of `<project-id>:<rule-id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectApprovalRule:ProjectApprovalRule example "12345:6"
 * ```
 */
public class ProjectApprovalRule internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectApprovalRule,
) : KotlinCustomResource(javaResource, ProjectApprovalRuleMapper) {
    /**
     * Whether the rule is applied to all protected branches. If set to 'true', the value of `protected_branch_ids` is ignored. Default is 'false'.
     */
    public val appliesToAllProtectedBranches: Output<Boolean>?
        get() = javaResource.appliesToAllProtectedBranches().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of approvals required for this rule.
     */
    public val approvalsRequired: Output<Int>
        get() = javaResource.approvalsRequired().applyValue({ args0 -> args0 })

    /**
     * When this flag is set, the default `any_approver` rule will not be imported if present.
     */
    public val disableImportingDefaultAnyApproverRuleOnCreate: Output<Boolean>?
        get() = javaResource.disableImportingDefaultAnyApproverRuleOnCreate().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * A list of group IDs whose members can approve of the merge request.
     */
    public val groupIds: Output<List<Int>>?
        get() = javaResource.groupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the approval rule.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name or id of the project to add the approval rules.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * A list of protected branch IDs (not branch names) for which the rule applies.
     */
    public val protectedBranchIds: Output<List<Int>>?
        get() = javaResource.protectedBranchIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Report type is required when the rule_type is `report_approver`. Valid values are `code_coverage`.
     */
    public val reportType: Output<String>
        get() = javaResource.reportType().applyValue({ args0 -> args0 })

    /**
     * String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`, `report_approver`.
     */
    public val ruleType: Output<String>
        get() = javaResource.ruleType().applyValue({ args0 -> args0 })

    /**
     * A list of specific User IDs to add to the list of approvers.
     */
    public val userIds: Output<List<Int>>?
        get() = javaResource.userIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object ProjectApprovalRuleMapper : ResourceMapper<ProjectApprovalRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectApprovalRule::class == javaResource::class

    override fun map(javaResource: Resource): ProjectApprovalRule = ProjectApprovalRule(
        javaResource
            as com.pulumi.gitlab.ProjectApprovalRule,
    )
}

/**
 * @see [ProjectApprovalRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectApprovalRule].
 */
public suspend fun projectApprovalRule(
    name: String,
    block: suspend ProjectApprovalRuleResourceBuilder.() -> Unit,
): ProjectApprovalRule {
    val builder = ProjectApprovalRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectApprovalRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectApprovalRule(name: String): ProjectApprovalRule {
    val builder = ProjectApprovalRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
