@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectApprovalRuleArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ## Import
 * GitLab project approval rules can be imported using a key composed of `<project-id>:<rule-id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectApprovalRule:ProjectApprovalRule example "12345:6"
 * ```
 * @property appliesToAllProtectedBranches Whether the rule is applied to all protected branches. If set to 'true', the value of `protected_branch_ids` is ignored. Default is 'false'.
 * @property approvalsRequired The number of approvals required for this rule.
 * @property disableImportingDefaultAnyApproverRuleOnCreate When this flag is set, the default `any_approver` rule will not be imported if present.
 * @property groupIds A list of group IDs whose members can approve of the merge request.
 * @property name The name of the approval rule.
 * @property project The name or id of the project to add the approval rules.
 * @property protectedBranchIds A list of protected branch IDs (not branch names) for which the rule applies.
 * @property reportType Report type is required when the rule_type is `report_approver`. Valid values are `code_coverage`.
 * @property ruleType String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`, `report_approver`.
 * @property userIds A list of specific User IDs to add to the list of approvers.
 */
public data class ProjectApprovalRuleArgs(
    public val appliesToAllProtectedBranches: Output<Boolean>? = null,
    public val approvalsRequired: Output<Int>? = null,
    public val disableImportingDefaultAnyApproverRuleOnCreate: Output<Boolean>? = null,
    public val groupIds: Output<List<Int>>? = null,
    public val name: Output<String>? = null,
    public val project: Output<String>? = null,
    public val protectedBranchIds: Output<List<Int>>? = null,
    public val reportType: Output<String>? = null,
    public val ruleType: Output<String>? = null,
    public val userIds: Output<List<Int>>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectApprovalRuleArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectApprovalRuleArgs =
        com.pulumi.gitlab.ProjectApprovalRuleArgs.builder()
            .appliesToAllProtectedBranches(appliesToAllProtectedBranches?.applyValue({ args0 -> args0 }))
            .approvalsRequired(approvalsRequired?.applyValue({ args0 -> args0 }))
            .disableImportingDefaultAnyApproverRuleOnCreate(
                disableImportingDefaultAnyApproverRuleOnCreate?.applyValue({ args0 ->
                    args0
                }),
            )
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .protectedBranchIds(protectedBranchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .reportType(reportType?.applyValue({ args0 -> args0 }))
            .ruleType(ruleType?.applyValue({ args0 -> args0 }))
            .userIds(userIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProjectApprovalRuleArgs].
 */
@PulumiTagMarker
public class ProjectApprovalRuleArgsBuilder internal constructor() {
    private var appliesToAllProtectedBranches: Output<Boolean>? = null

    private var approvalsRequired: Output<Int>? = null

    private var disableImportingDefaultAnyApproverRuleOnCreate: Output<Boolean>? = null

    private var groupIds: Output<List<Int>>? = null

    private var name: Output<String>? = null

    private var project: Output<String>? = null

    private var protectedBranchIds: Output<List<Int>>? = null

    private var reportType: Output<String>? = null

    private var ruleType: Output<String>? = null

    private var userIds: Output<List<Int>>? = null

    /**
     * @param value Whether the rule is applied to all protected branches. If set to 'true', the value of `protected_branch_ids` is ignored. Default is 'false'.
     */
    @JvmName("iumrykvmvtlcnhgx")
    public suspend fun appliesToAllProtectedBranches(`value`: Output<Boolean>) {
        this.appliesToAllProtectedBranches = value
    }

    /**
     * @param value The number of approvals required for this rule.
     */
    @JvmName("lemncatlagldblcw")
    public suspend fun approvalsRequired(`value`: Output<Int>) {
        this.approvalsRequired = value
    }

    /**
     * @param value When this flag is set, the default `any_approver` rule will not be imported if present.
     */
    @JvmName("euciiueymuoqoujv")
    public suspend fun disableImportingDefaultAnyApproverRuleOnCreate(`value`: Output<Boolean>) {
        this.disableImportingDefaultAnyApproverRuleOnCreate = value
    }

    /**
     * @param value A list of group IDs whose members can approve of the merge request.
     */
    @JvmName("pxqvkgvoriiguwgo")
    public suspend fun groupIds(`value`: Output<List<Int>>) {
        this.groupIds = value
    }

    @JvmName("nlqmkdoycoflkyxy")
    public suspend fun groupIds(vararg values: Output<Int>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of group IDs whose members can approve of the merge request.
     */
    @JvmName("hencjtckrbewafwm")
    public suspend fun groupIds(values: List<Output<Int>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The name of the approval rule.
     */
    @JvmName("shoetdqmxiiwcgoi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name or id of the project to add the approval rules.
     */
    @JvmName("ocgdjxpwrpreetui")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value A list of protected branch IDs (not branch names) for which the rule applies.
     */
    @JvmName("hcbketdxbxilsgxu")
    public suspend fun protectedBranchIds(`value`: Output<List<Int>>) {
        this.protectedBranchIds = value
    }

    @JvmName("mqtnwauvcqvkbsku")
    public suspend fun protectedBranchIds(vararg values: Output<Int>) {
        this.protectedBranchIds = Output.all(values.asList())
    }

    /**
     * @param values A list of protected branch IDs (not branch names) for which the rule applies.
     */
    @JvmName("bpkkbxrxrwlbdjes")
    public suspend fun protectedBranchIds(values: List<Output<Int>>) {
        this.protectedBranchIds = Output.all(values)
    }

    /**
     * @param value Report type is required when the rule_type is `report_approver`. Valid values are `code_coverage`.
     */
    @JvmName("cggldhveqhegulfi")
    public suspend fun reportType(`value`: Output<String>) {
        this.reportType = value
    }

    /**
     * @param value String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`, `report_approver`.
     */
    @JvmName("yxyqpcldkxyldqav")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value A list of specific User IDs to add to the list of approvers.
     */
    @JvmName("cspmuoovoruxexfs")
    public suspend fun userIds(`value`: Output<List<Int>>) {
        this.userIds = value
    }

    @JvmName("umnabbnjisxwbqmm")
    public suspend fun userIds(vararg values: Output<Int>) {
        this.userIds = Output.all(values.asList())
    }

    /**
     * @param values A list of specific User IDs to add to the list of approvers.
     */
    @JvmName("qprnxubgkfjbbmgx")
    public suspend fun userIds(values: List<Output<Int>>) {
        this.userIds = Output.all(values)
    }

    /**
     * @param value Whether the rule is applied to all protected branches. If set to 'true', the value of `protected_branch_ids` is ignored. Default is 'false'.
     */
    @JvmName("batdcflfegbmhirm")
    public suspend fun appliesToAllProtectedBranches(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appliesToAllProtectedBranches = mapped
    }

    /**
     * @param value The number of approvals required for this rule.
     */
    @JvmName("rcjuubljybqrreye")
    public suspend fun approvalsRequired(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvalsRequired = mapped
    }

    /**
     * @param value When this flag is set, the default `any_approver` rule will not be imported if present.
     */
    @JvmName("ubkkocuuavvwurmc")
    public suspend fun disableImportingDefaultAnyApproverRuleOnCreate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableImportingDefaultAnyApproverRuleOnCreate = mapped
    }

    /**
     * @param value A list of group IDs whose members can approve of the merge request.
     */
    @JvmName("pfavrwyrmmlfilnq")
    public suspend fun groupIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values A list of group IDs whose members can approve of the merge request.
     */
    @JvmName("vqwhsmrtrqocwiad")
    public suspend fun groupIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The name of the approval rule.
     */
    @JvmName("hhtfajaxhwbfhgta")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name or id of the project to add the approval rules.
     */
    @JvmName("nvaykuovtltbdbgi")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value A list of protected branch IDs (not branch names) for which the rule applies.
     */
    @JvmName("yconmdhposnfujtv")
    public suspend fun protectedBranchIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedBranchIds = mapped
    }

    /**
     * @param values A list of protected branch IDs (not branch names) for which the rule applies.
     */
    @JvmName("jwanadqiptyvloxo")
    public suspend fun protectedBranchIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedBranchIds = mapped
    }

    /**
     * @param value Report type is required when the rule_type is `report_approver`. Valid values are `code_coverage`.
     */
    @JvmName("vgymarfytncbkisf")
    public suspend fun reportType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportType = mapped
    }

    /**
     * @param value String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`, `report_approver`.
     */
    @JvmName("pxorbjpeqlijcibr")
    public suspend fun ruleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value A list of specific User IDs to add to the list of approvers.
     */
    @JvmName("ptqxhjidvemlsnan")
    public suspend fun userIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    /**
     * @param values A list of specific User IDs to add to the list of approvers.
     */
    @JvmName("nnepcldmxgubmrsy")
    public suspend fun userIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    internal fun build(): ProjectApprovalRuleArgs = ProjectApprovalRuleArgs(
        appliesToAllProtectedBranches = appliesToAllProtectedBranches,
        approvalsRequired = approvalsRequired,
        disableImportingDefaultAnyApproverRuleOnCreate = disableImportingDefaultAnyApproverRuleOnCreate,
        groupIds = groupIds,
        name = name,
        project = project,
        protectedBranchIds = protectedBranchIds,
        reportType = reportType,
        ruleType = ruleType,
        userIds = userIds,
    )
}
