@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectArgs.builder
import com.pulumi.gitlab.kotlin.inputs.ProjectContainerExpirationPolicyArgs
import com.pulumi.gitlab.kotlin.inputs.ProjectContainerExpirationPolicyArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.ProjectPushRulesArgs
import com.pulumi.gitlab.kotlin.inputs.ProjectPushRulesArgsBuilder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ## Import
 * ```sh
 * $ pulumi import gitlab:index/project:Project You can import a project state using `<resource> <id>`. The
 * ```
 * `id` can be whatever the [get single project api][get_single_project] takes for
 * its `:id` value, so for example:
 * ```sh
 * $ pulumi import gitlab:index/project:Project example richardc/example
 * ```
 * NOTE: the `import_url_username` and `import_url_password` cannot be imported.
 * @property allowMergeOnSkippedPipeline Set to true if you want to treat skipped pipelines as if they finished with success.
 * @property analyticsAccessLevel Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
 * @property approvalsBeforeMerge Number of merge request approvals required for merging. Default is 0.
 * This field **does not** work well in combination with the `gitlab.ProjectApprovalRule` resource
 * and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
 * In the meantime we recommend against using this attribute and use `gitlab.ProjectApprovalRule` instead.
 * @property archiveOnDestroy Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
 * @property archived Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
 * @property autoCancelPendingPipelines Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
 * @property autoDevopsDeployStrategy Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
 * @property autoDevopsEnabled Enable Auto DevOps for this project.
 * @property autocloseReferencedIssues Set whether auto-closing referenced issues on default branch.
 * @property avatar A local path to the avatar image to upload. **Note**: not available for imported resources.
 * @property avatarHash The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
 * @property buildCoverageRegex Test coverage parsing for the project. This is deprecated feature in GitLab 15.0.
 * @property buildGitStrategy The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
 * @property buildTimeout The maximum amount of time, in seconds, that a job can run.
 * @property buildsAccessLevel Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
 * @property ciConfigPath Custom Path to CI config file.
 * @property ciDefaultGitDepth Default number of revisions for shallow cloning.
 * @property ciForwardDeploymentEnabled When a new deployment job starts, skip older deployment jobs that are still pending.
 * @property ciRestrictPipelineCancellationRole The role required to cancel a pipeline or job. Introduced in GitLab 16.8. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
 * @property ciSeparatedCaches Use separate caches for protected branches.
 * @property containerExpirationPolicy Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
 * @property containerRegistryAccessLevel Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
 * @property containerRegistryEnabled Enable container registry for the project.
 * @property defaultBranch The default branch for the project.
 * @property description A description of the project.
 * @property emailsEnabled Enable email notifications.
 * @property environmentsAccessLevel Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
 * @property externalAuthorizationClassificationLabel The classification label for the project.
 * @property featureFlagsAccessLevel Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
 * @property forkedFromProjectId The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
 * @property forkingAccessLevel Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
 * @property groupRunnersEnabled Enable group runners for this project.
 * @property groupWithProjectTemplatesId For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
 * @property importUrl Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import. Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using `pulumi import`. See the examples section for how to properly use it.
 * @property importUrlPassword The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`. See the examples section for how to properly use it.
 * @property importUrlUsername The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`.  See the examples section for how to properly use it.
 * @property infrastructureAccessLevel Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
 * @property initializeWithReadme Create main branch with first commit containing a README.md file. Must be set to `true` if importing an uninitialized project with a different `default_branch`.
 * @property issuesAccessLevel Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
 * @property issuesEnabled Enable issue tracking for the project.
 * @property issuesTemplate Sets the template for new issues in the project.
 * @property keepLatestArtifact Disable or enable the ability to keep the latest artifact for this project.
 * @property lfsEnabled Enable LFS for the project.
 * @property mergeCommitTemplate Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
 * @property mergeMethod Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
 * @property mergePipelinesEnabled Enable or disable merge pipelines.
 * @property mergeRequestsAccessLevel Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
 * @property mergeRequestsEnabled Enable merge requests for the project.
 * @property mergeRequestsTemplate Sets the template for new merge requests in the project.
 * @property mergeTrainsEnabled Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
 * @property mirror Enable project pull mirror.
 * @property mirrorOverwritesDivergedBranches Enable overwrite diverged branches for a mirrored project.
 * @property mirrorTriggerBuilds Enable trigger builds on pushes for a mirrored project.
 * @property monitorAccessLevel Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
 * @property mrDefaultTargetSelf For forked projects, target merge requests to this project. If false, the target will be the upstream project.
 * @property name The name of the project.
 * @property namespaceId The namespace (group or user) of the project. Defaults to your user.
 * @property onlyAllowMergeIfAllDiscussionsAreResolved Set to true if you want allow merges only if all discussions are resolved.
 * @property onlyAllowMergeIfPipelineSucceeds Set to true if you want allow merges only if a pipeline succeeds.
 * @property onlyMirrorProtectedBranches Enable only mirror protected branches for a mirrored project.
 * @property packagesEnabled Enable packages repository for the project.
 * @property pagesAccessLevel Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
 * @property path The path of the repository.
 * @property pipelinesEnabled Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
 * @property preReceiveSecretDetectionEnabled Whether Secret Push Detection is enabled. Requires GitLab Ultimate and at least GitLab 17.3.
 * @property printingMergeRequestLinkEnabled Show link to create/view merge request when pushing from the command line
 * @property publicBuilds If true, jobs can be viewed by non-project members.
 * @property publicJobs If true, jobs can be viewed by non-project members.
 * @property pushRules Push rules for the project.
 * @property releasesAccessLevel Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
 * @property removeSourceBranchAfterMerge Enable `Delete source branch` option by default for all new merge requests.
 * @property repositoryAccessLevel Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
 * @property repositoryStorage Which storage shard the repository is on. (administrator only)
 * @property requestAccessEnabled Allow users to request member access.
 * @property requirementsAccessLevel Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
 * @property resolveOutdatedDiffDiscussions Automatically resolve merge request diffs discussions on lines changed with a push.
 * @property restrictUserDefinedVariables Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
 * @property securityAndComplianceAccessLevel Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
 * @property sharedRunnersEnabled Enable shared runners for this project.
 * @property skipWaitForDefaultBranchProtection If `true`, the default behavior to wait for the default branch protection to be created is skipped.
 * This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
 * There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
 * This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
 * @property snippetsAccessLevel Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
 * @property snippetsEnabled Enable snippets for the project.
 * @property squashCommitTemplate Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
 * @property squashOption Squash commits when merge request. Valid values are `never`, `always`, `default_on`, or `default_off`. The default value is `default_off`. [GitLab >= 14&#46;1]
 * @property suggestionCommitMessage The commit message used to apply merge request suggestions.
 * @property tags The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
 * @property templateName When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
 * @property templateProjectId When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `gitlab.GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
 * @property topics The list of topics for the project.
 * @property useCustomTemplate Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
 * 	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting.html#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
 * @property visibilityLevel Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
 * @property wikiAccessLevel Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
 * @property wikiEnabled Enable wiki for the project.
 */
public data class ProjectArgs(
    public val allowMergeOnSkippedPipeline: Output<Boolean>? = null,
    public val analyticsAccessLevel: Output<String>? = null,
    public val approvalsBeforeMerge: Output<Int>? = null,
    public val archiveOnDestroy: Output<Boolean>? = null,
    public val archived: Output<Boolean>? = null,
    public val autoCancelPendingPipelines: Output<String>? = null,
    public val autoDevopsDeployStrategy: Output<String>? = null,
    public val autoDevopsEnabled: Output<Boolean>? = null,
    public val autocloseReferencedIssues: Output<Boolean>? = null,
    public val avatar: Output<String>? = null,
    public val avatarHash: Output<String>? = null,
    @Deprecated(
        message = """
  build_coverage_regex is removed in GitLab 15.0.
  """,
    )
    public val buildCoverageRegex: Output<String>? = null,
    public val buildGitStrategy: Output<String>? = null,
    public val buildTimeout: Output<Int>? = null,
    public val buildsAccessLevel: Output<String>? = null,
    public val ciConfigPath: Output<String>? = null,
    public val ciDefaultGitDepth: Output<Int>? = null,
    public val ciForwardDeploymentEnabled: Output<Boolean>? = null,
    public val ciRestrictPipelineCancellationRole: Output<String>? = null,
    public val ciSeparatedCaches: Output<Boolean>? = null,
    public val containerExpirationPolicy: Output<ProjectContainerExpirationPolicyArgs>? = null,
    public val containerRegistryAccessLevel: Output<String>? = null,
    @Deprecated(
        message = """
  Use `container_registry_access_level` instead.
  """,
    )
    public val containerRegistryEnabled: Output<Boolean>? = null,
    public val defaultBranch: Output<String>? = null,
    public val description: Output<String>? = null,
    public val emailsEnabled: Output<Boolean>? = null,
    public val environmentsAccessLevel: Output<String>? = null,
    public val externalAuthorizationClassificationLabel: Output<String>? = null,
    public val featureFlagsAccessLevel: Output<String>? = null,
    public val forkedFromProjectId: Output<Int>? = null,
    public val forkingAccessLevel: Output<String>? = null,
    public val groupRunnersEnabled: Output<Boolean>? = null,
    public val groupWithProjectTemplatesId: Output<Int>? = null,
    public val importUrl: Output<String>? = null,
    public val importUrlPassword: Output<String>? = null,
    public val importUrlUsername: Output<String>? = null,
    public val infrastructureAccessLevel: Output<String>? = null,
    public val initializeWithReadme: Output<Boolean>? = null,
    public val issuesAccessLevel: Output<String>? = null,
    public val issuesEnabled: Output<Boolean>? = null,
    public val issuesTemplate: Output<String>? = null,
    public val keepLatestArtifact: Output<Boolean>? = null,
    public val lfsEnabled: Output<Boolean>? = null,
    public val mergeCommitTemplate: Output<String>? = null,
    public val mergeMethod: Output<String>? = null,
    public val mergePipelinesEnabled: Output<Boolean>? = null,
    public val mergeRequestsAccessLevel: Output<String>? = null,
    public val mergeRequestsEnabled: Output<Boolean>? = null,
    public val mergeRequestsTemplate: Output<String>? = null,
    public val mergeTrainsEnabled: Output<Boolean>? = null,
    public val mirror: Output<Boolean>? = null,
    public val mirrorOverwritesDivergedBranches: Output<Boolean>? = null,
    public val mirrorTriggerBuilds: Output<Boolean>? = null,
    public val monitorAccessLevel: Output<String>? = null,
    public val mrDefaultTargetSelf: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val namespaceId: Output<Int>? = null,
    public val onlyAllowMergeIfAllDiscussionsAreResolved: Output<Boolean>? = null,
    public val onlyAllowMergeIfPipelineSucceeds: Output<Boolean>? = null,
    public val onlyMirrorProtectedBranches: Output<Boolean>? = null,
    public val packagesEnabled: Output<Boolean>? = null,
    public val pagesAccessLevel: Output<String>? = null,
    public val path: Output<String>? = null,
    @Deprecated(
        message = """
  Deprecated in favor of `builds_access_level`
  """,
    )
    public val pipelinesEnabled: Output<Boolean>? = null,
    public val preReceiveSecretDetectionEnabled: Output<Boolean>? = null,
    public val printingMergeRequestLinkEnabled: Output<Boolean>? = null,
    @Deprecated(
        message = """
  The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in
      the next major version of the provider.
  """,
    )
    public val publicBuilds: Output<Boolean>? = null,
    public val publicJobs: Output<Boolean>? = null,
    public val pushRules: Output<ProjectPushRulesArgs>? = null,
    public val releasesAccessLevel: Output<String>? = null,
    public val removeSourceBranchAfterMerge: Output<Boolean>? = null,
    public val repositoryAccessLevel: Output<String>? = null,
    public val repositoryStorage: Output<String>? = null,
    public val requestAccessEnabled: Output<Boolean>? = null,
    public val requirementsAccessLevel: Output<String>? = null,
    public val resolveOutdatedDiffDiscussions: Output<Boolean>? = null,
    public val restrictUserDefinedVariables: Output<Boolean>? = null,
    public val securityAndComplianceAccessLevel: Output<String>? = null,
    public val sharedRunnersEnabled: Output<Boolean>? = null,
    public val skipWaitForDefaultBranchProtection: Output<Boolean>? = null,
    public val snippetsAccessLevel: Output<String>? = null,
    public val snippetsEnabled: Output<Boolean>? = null,
    public val squashCommitTemplate: Output<String>? = null,
    public val squashOption: Output<String>? = null,
    public val suggestionCommitMessage: Output<String>? = null,
    public val tags: Output<List<String>>? = null,
    public val templateName: Output<String>? = null,
    public val templateProjectId: Output<Int>? = null,
    public val topics: Output<List<String>>? = null,
    public val useCustomTemplate: Output<Boolean>? = null,
    public val visibilityLevel: Output<String>? = null,
    public val wikiAccessLevel: Output<String>? = null,
    public val wikiEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectArgs = com.pulumi.gitlab.ProjectArgs.builder()
        .allowMergeOnSkippedPipeline(allowMergeOnSkippedPipeline?.applyValue({ args0 -> args0 }))
        .analyticsAccessLevel(analyticsAccessLevel?.applyValue({ args0 -> args0 }))
        .approvalsBeforeMerge(approvalsBeforeMerge?.applyValue({ args0 -> args0 }))
        .archiveOnDestroy(archiveOnDestroy?.applyValue({ args0 -> args0 }))
        .archived(archived?.applyValue({ args0 -> args0 }))
        .autoCancelPendingPipelines(autoCancelPendingPipelines?.applyValue({ args0 -> args0 }))
        .autoDevopsDeployStrategy(autoDevopsDeployStrategy?.applyValue({ args0 -> args0 }))
        .autoDevopsEnabled(autoDevopsEnabled?.applyValue({ args0 -> args0 }))
        .autocloseReferencedIssues(autocloseReferencedIssues?.applyValue({ args0 -> args0 }))
        .avatar(avatar?.applyValue({ args0 -> args0 }))
        .avatarHash(avatarHash?.applyValue({ args0 -> args0 }))
        .buildCoverageRegex(buildCoverageRegex?.applyValue({ args0 -> args0 }))
        .buildGitStrategy(buildGitStrategy?.applyValue({ args0 -> args0 }))
        .buildTimeout(buildTimeout?.applyValue({ args0 -> args0 }))
        .buildsAccessLevel(buildsAccessLevel?.applyValue({ args0 -> args0 }))
        .ciConfigPath(ciConfigPath?.applyValue({ args0 -> args0 }))
        .ciDefaultGitDepth(ciDefaultGitDepth?.applyValue({ args0 -> args0 }))
        .ciForwardDeploymentEnabled(ciForwardDeploymentEnabled?.applyValue({ args0 -> args0 }))
        .ciRestrictPipelineCancellationRole(
            ciRestrictPipelineCancellationRole?.applyValue({ args0 ->
                args0
            }),
        )
        .ciSeparatedCaches(ciSeparatedCaches?.applyValue({ args0 -> args0 }))
        .containerExpirationPolicy(
            containerExpirationPolicy?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .containerRegistryAccessLevel(containerRegistryAccessLevel?.applyValue({ args0 -> args0 }))
        .containerRegistryEnabled(containerRegistryEnabled?.applyValue({ args0 -> args0 }))
        .defaultBranch(defaultBranch?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .emailsEnabled(emailsEnabled?.applyValue({ args0 -> args0 }))
        .environmentsAccessLevel(environmentsAccessLevel?.applyValue({ args0 -> args0 }))
        .externalAuthorizationClassificationLabel(
            externalAuthorizationClassificationLabel?.applyValue({ args0 ->
                args0
            }),
        )
        .featureFlagsAccessLevel(featureFlagsAccessLevel?.applyValue({ args0 -> args0 }))
        .forkedFromProjectId(forkedFromProjectId?.applyValue({ args0 -> args0 }))
        .forkingAccessLevel(forkingAccessLevel?.applyValue({ args0 -> args0 }))
        .groupRunnersEnabled(groupRunnersEnabled?.applyValue({ args0 -> args0 }))
        .groupWithProjectTemplatesId(groupWithProjectTemplatesId?.applyValue({ args0 -> args0 }))
        .importUrl(importUrl?.applyValue({ args0 -> args0 }))
        .importUrlPassword(importUrlPassword?.applyValue({ args0 -> args0 }))
        .importUrlUsername(importUrlUsername?.applyValue({ args0 -> args0 }))
        .infrastructureAccessLevel(infrastructureAccessLevel?.applyValue({ args0 -> args0 }))
        .initializeWithReadme(initializeWithReadme?.applyValue({ args0 -> args0 }))
        .issuesAccessLevel(issuesAccessLevel?.applyValue({ args0 -> args0 }))
        .issuesEnabled(issuesEnabled?.applyValue({ args0 -> args0 }))
        .issuesTemplate(issuesTemplate?.applyValue({ args0 -> args0 }))
        .keepLatestArtifact(keepLatestArtifact?.applyValue({ args0 -> args0 }))
        .lfsEnabled(lfsEnabled?.applyValue({ args0 -> args0 }))
        .mergeCommitTemplate(mergeCommitTemplate?.applyValue({ args0 -> args0 }))
        .mergeMethod(mergeMethod?.applyValue({ args0 -> args0 }))
        .mergePipelinesEnabled(mergePipelinesEnabled?.applyValue({ args0 -> args0 }))
        .mergeRequestsAccessLevel(mergeRequestsAccessLevel?.applyValue({ args0 -> args0 }))
        .mergeRequestsEnabled(mergeRequestsEnabled?.applyValue({ args0 -> args0 }))
        .mergeRequestsTemplate(mergeRequestsTemplate?.applyValue({ args0 -> args0 }))
        .mergeTrainsEnabled(mergeTrainsEnabled?.applyValue({ args0 -> args0 }))
        .mirror(mirror?.applyValue({ args0 -> args0 }))
        .mirrorOverwritesDivergedBranches(mirrorOverwritesDivergedBranches?.applyValue({ args0 -> args0 }))
        .mirrorTriggerBuilds(mirrorTriggerBuilds?.applyValue({ args0 -> args0 }))
        .monitorAccessLevel(monitorAccessLevel?.applyValue({ args0 -> args0 }))
        .mrDefaultTargetSelf(mrDefaultTargetSelf?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .namespaceId(namespaceId?.applyValue({ args0 -> args0 }))
        .onlyAllowMergeIfAllDiscussionsAreResolved(
            onlyAllowMergeIfAllDiscussionsAreResolved?.applyValue({ args0 ->
                args0
            }),
        )
        .onlyAllowMergeIfPipelineSucceeds(onlyAllowMergeIfPipelineSucceeds?.applyValue({ args0 -> args0 }))
        .onlyMirrorProtectedBranches(onlyMirrorProtectedBranches?.applyValue({ args0 -> args0 }))
        .packagesEnabled(packagesEnabled?.applyValue({ args0 -> args0 }))
        .pagesAccessLevel(pagesAccessLevel?.applyValue({ args0 -> args0 }))
        .path(path?.applyValue({ args0 -> args0 }))
        .pipelinesEnabled(pipelinesEnabled?.applyValue({ args0 -> args0 }))
        .preReceiveSecretDetectionEnabled(preReceiveSecretDetectionEnabled?.applyValue({ args0 -> args0 }))
        .printingMergeRequestLinkEnabled(printingMergeRequestLinkEnabled?.applyValue({ args0 -> args0 }))
        .publicBuilds(publicBuilds?.applyValue({ args0 -> args0 }))
        .publicJobs(publicJobs?.applyValue({ args0 -> args0 }))
        .pushRules(pushRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .releasesAccessLevel(releasesAccessLevel?.applyValue({ args0 -> args0 }))
        .removeSourceBranchAfterMerge(removeSourceBranchAfterMerge?.applyValue({ args0 -> args0 }))
        .repositoryAccessLevel(repositoryAccessLevel?.applyValue({ args0 -> args0 }))
        .repositoryStorage(repositoryStorage?.applyValue({ args0 -> args0 }))
        .requestAccessEnabled(requestAccessEnabled?.applyValue({ args0 -> args0 }))
        .requirementsAccessLevel(requirementsAccessLevel?.applyValue({ args0 -> args0 }))
        .resolveOutdatedDiffDiscussions(resolveOutdatedDiffDiscussions?.applyValue({ args0 -> args0 }))
        .restrictUserDefinedVariables(restrictUserDefinedVariables?.applyValue({ args0 -> args0 }))
        .securityAndComplianceAccessLevel(securityAndComplianceAccessLevel?.applyValue({ args0 -> args0 }))
        .sharedRunnersEnabled(sharedRunnersEnabled?.applyValue({ args0 -> args0 }))
        .skipWaitForDefaultBranchProtection(
            skipWaitForDefaultBranchProtection?.applyValue({ args0 ->
                args0
            }),
        )
        .snippetsAccessLevel(snippetsAccessLevel?.applyValue({ args0 -> args0 }))
        .snippetsEnabled(snippetsEnabled?.applyValue({ args0 -> args0 }))
        .squashCommitTemplate(squashCommitTemplate?.applyValue({ args0 -> args0 }))
        .squashOption(squashOption?.applyValue({ args0 -> args0 }))
        .suggestionCommitMessage(suggestionCommitMessage?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .templateName(templateName?.applyValue({ args0 -> args0 }))
        .templateProjectId(templateProjectId?.applyValue({ args0 -> args0 }))
        .topics(topics?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .useCustomTemplate(useCustomTemplate?.applyValue({ args0 -> args0 }))
        .visibilityLevel(visibilityLevel?.applyValue({ args0 -> args0 }))
        .wikiAccessLevel(wikiAccessLevel?.applyValue({ args0 -> args0 }))
        .wikiEnabled(wikiEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var allowMergeOnSkippedPipeline: Output<Boolean>? = null

    private var analyticsAccessLevel: Output<String>? = null

    private var approvalsBeforeMerge: Output<Int>? = null

    private var archiveOnDestroy: Output<Boolean>? = null

    private var archived: Output<Boolean>? = null

    private var autoCancelPendingPipelines: Output<String>? = null

    private var autoDevopsDeployStrategy: Output<String>? = null

    private var autoDevopsEnabled: Output<Boolean>? = null

    private var autocloseReferencedIssues: Output<Boolean>? = null

    private var avatar: Output<String>? = null

    private var avatarHash: Output<String>? = null

    private var buildCoverageRegex: Output<String>? = null

    private var buildGitStrategy: Output<String>? = null

    private var buildTimeout: Output<Int>? = null

    private var buildsAccessLevel: Output<String>? = null

    private var ciConfigPath: Output<String>? = null

    private var ciDefaultGitDepth: Output<Int>? = null

    private var ciForwardDeploymentEnabled: Output<Boolean>? = null

    private var ciRestrictPipelineCancellationRole: Output<String>? = null

    private var ciSeparatedCaches: Output<Boolean>? = null

    private var containerExpirationPolicy: Output<ProjectContainerExpirationPolicyArgs>? = null

    private var containerRegistryAccessLevel: Output<String>? = null

    private var containerRegistryEnabled: Output<Boolean>? = null

    private var defaultBranch: Output<String>? = null

    private var description: Output<String>? = null

    private var emailsEnabled: Output<Boolean>? = null

    private var environmentsAccessLevel: Output<String>? = null

    private var externalAuthorizationClassificationLabel: Output<String>? = null

    private var featureFlagsAccessLevel: Output<String>? = null

    private var forkedFromProjectId: Output<Int>? = null

    private var forkingAccessLevel: Output<String>? = null

    private var groupRunnersEnabled: Output<Boolean>? = null

    private var groupWithProjectTemplatesId: Output<Int>? = null

    private var importUrl: Output<String>? = null

    private var importUrlPassword: Output<String>? = null

    private var importUrlUsername: Output<String>? = null

    private var infrastructureAccessLevel: Output<String>? = null

    private var initializeWithReadme: Output<Boolean>? = null

    private var issuesAccessLevel: Output<String>? = null

    private var issuesEnabled: Output<Boolean>? = null

    private var issuesTemplate: Output<String>? = null

    private var keepLatestArtifact: Output<Boolean>? = null

    private var lfsEnabled: Output<Boolean>? = null

    private var mergeCommitTemplate: Output<String>? = null

    private var mergeMethod: Output<String>? = null

    private var mergePipelinesEnabled: Output<Boolean>? = null

    private var mergeRequestsAccessLevel: Output<String>? = null

    private var mergeRequestsEnabled: Output<Boolean>? = null

    private var mergeRequestsTemplate: Output<String>? = null

    private var mergeTrainsEnabled: Output<Boolean>? = null

    private var mirror: Output<Boolean>? = null

    private var mirrorOverwritesDivergedBranches: Output<Boolean>? = null

    private var mirrorTriggerBuilds: Output<Boolean>? = null

    private var monitorAccessLevel: Output<String>? = null

    private var mrDefaultTargetSelf: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var namespaceId: Output<Int>? = null

    private var onlyAllowMergeIfAllDiscussionsAreResolved: Output<Boolean>? = null

    private var onlyAllowMergeIfPipelineSucceeds: Output<Boolean>? = null

    private var onlyMirrorProtectedBranches: Output<Boolean>? = null

    private var packagesEnabled: Output<Boolean>? = null

    private var pagesAccessLevel: Output<String>? = null

    private var path: Output<String>? = null

    private var pipelinesEnabled: Output<Boolean>? = null

    private var preReceiveSecretDetectionEnabled: Output<Boolean>? = null

    private var printingMergeRequestLinkEnabled: Output<Boolean>? = null

    private var publicBuilds: Output<Boolean>? = null

    private var publicJobs: Output<Boolean>? = null

    private var pushRules: Output<ProjectPushRulesArgs>? = null

    private var releasesAccessLevel: Output<String>? = null

    private var removeSourceBranchAfterMerge: Output<Boolean>? = null

    private var repositoryAccessLevel: Output<String>? = null

    private var repositoryStorage: Output<String>? = null

    private var requestAccessEnabled: Output<Boolean>? = null

    private var requirementsAccessLevel: Output<String>? = null

    private var resolveOutdatedDiffDiscussions: Output<Boolean>? = null

    private var restrictUserDefinedVariables: Output<Boolean>? = null

    private var securityAndComplianceAccessLevel: Output<String>? = null

    private var sharedRunnersEnabled: Output<Boolean>? = null

    private var skipWaitForDefaultBranchProtection: Output<Boolean>? = null

    private var snippetsAccessLevel: Output<String>? = null

    private var snippetsEnabled: Output<Boolean>? = null

    private var squashCommitTemplate: Output<String>? = null

    private var squashOption: Output<String>? = null

    private var suggestionCommitMessage: Output<String>? = null

    private var tags: Output<List<String>>? = null

    private var templateName: Output<String>? = null

    private var templateProjectId: Output<Int>? = null

    private var topics: Output<List<String>>? = null

    private var useCustomTemplate: Output<Boolean>? = null

    private var visibilityLevel: Output<String>? = null

    private var wikiAccessLevel: Output<String>? = null

    private var wikiEnabled: Output<Boolean>? = null

    /**
     * @param value Set to true if you want to treat skipped pipelines as if they finished with success.
     */
    @JvmName("lextjanoafyylkia")
    public suspend fun allowMergeOnSkippedPipeline(`value`: Output<Boolean>) {
        this.allowMergeOnSkippedPipeline = value
    }

    /**
     * @param value Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("scgsfofrlvctxbeu")
    public suspend fun analyticsAccessLevel(`value`: Output<String>) {
        this.analyticsAccessLevel = value
    }

    /**
     * @param value Number of merge request approvals required for merging. Default is 0.
     * This field **does not** work well in combination with the `gitlab.ProjectApprovalRule` resource
     * and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
     * In the meantime we recommend against using this attribute and use `gitlab.ProjectApprovalRule` instead.
     */
    @JvmName("yymknmnhnwuwuwgb")
    public suspend fun approvalsBeforeMerge(`value`: Output<Int>) {
        this.approvalsBeforeMerge = value
    }

    /**
     * @param value Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
     */
    @JvmName("fdtuelwjyklhkcmc")
    public suspend fun archiveOnDestroy(`value`: Output<Boolean>) {
        this.archiveOnDestroy = value
    }

    /**
     * @param value Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
     */
    @JvmName("rkbsmicxddotshtf")
    public suspend fun archived(`value`: Output<Boolean>) {
        this.archived = value
    }

    /**
     * @param value Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
     */
    @JvmName("shijkkbpbqlkqfhk")
    public suspend fun autoCancelPendingPipelines(`value`: Output<String>) {
        this.autoCancelPendingPipelines = value
    }

    /**
     * @param value Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
     */
    @JvmName("gerhdlucvpbmkois")
    public suspend fun autoDevopsDeployStrategy(`value`: Output<String>) {
        this.autoDevopsDeployStrategy = value
    }

    /**
     * @param value Enable Auto DevOps for this project.
     */
    @JvmName("bccbnabdbebygtpe")
    public suspend fun autoDevopsEnabled(`value`: Output<Boolean>) {
        this.autoDevopsEnabled = value
    }

    /**
     * @param value Set whether auto-closing referenced issues on default branch.
     */
    @JvmName("tdoaxkpcyfxlsfch")
    public suspend fun autocloseReferencedIssues(`value`: Output<Boolean>) {
        this.autocloseReferencedIssues = value
    }

    /**
     * @param value A local path to the avatar image to upload. **Note**: not available for imported resources.
     */
    @JvmName("jyfyvkfduuvefvig")
    public suspend fun avatar(`value`: Output<String>) {
        this.avatar = value
    }

    /**
     * @param value The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
     */
    @JvmName("qxgfbpslgrhnkdgd")
    public suspend fun avatarHash(`value`: Output<String>) {
        this.avatarHash = value
    }

    /**
     * @param value Test coverage parsing for the project. This is deprecated feature in GitLab 15.0.
     */
    @Deprecated(
        message = """
  build_coverage_regex is removed in GitLab 15.0.
  """,
    )
    @JvmName("wcngngvtfljpksxt")
    public suspend fun buildCoverageRegex(`value`: Output<String>) {
        this.buildCoverageRegex = value
    }

    /**
     * @param value The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
     */
    @JvmName("xbglkctyyjkjbbhb")
    public suspend fun buildGitStrategy(`value`: Output<String>) {
        this.buildGitStrategy = value
    }

    /**
     * @param value The maximum amount of time, in seconds, that a job can run.
     */
    @JvmName("mahbhcoacccfroym")
    public suspend fun buildTimeout(`value`: Output<Int>) {
        this.buildTimeout = value
    }

    /**
     * @param value Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("wtesifrkjupstrbs")
    public suspend fun buildsAccessLevel(`value`: Output<String>) {
        this.buildsAccessLevel = value
    }

    /**
     * @param value Custom Path to CI config file.
     */
    @JvmName("pjfbcseafonuuwpf")
    public suspend fun ciConfigPath(`value`: Output<String>) {
        this.ciConfigPath = value
    }

    /**
     * @param value Default number of revisions for shallow cloning.
     */
    @JvmName("rcwcutrfqwxfvxmc")
    public suspend fun ciDefaultGitDepth(`value`: Output<Int>) {
        this.ciDefaultGitDepth = value
    }

    /**
     * @param value When a new deployment job starts, skip older deployment jobs that are still pending.
     */
    @JvmName("tgduvauqgakqtwjq")
    public suspend fun ciForwardDeploymentEnabled(`value`: Output<Boolean>) {
        this.ciForwardDeploymentEnabled = value
    }

    /**
     * @param value The role required to cancel a pipeline or job. Introduced in GitLab 16.8. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
     */
    @JvmName("cpmshdpkbqavrgbk")
    public suspend fun ciRestrictPipelineCancellationRole(`value`: Output<String>) {
        this.ciRestrictPipelineCancellationRole = value
    }

    /**
     * @param value Use separate caches for protected branches.
     */
    @JvmName("ftadxxtqphgsrwfm")
    public suspend fun ciSeparatedCaches(`value`: Output<Boolean>) {
        this.ciSeparatedCaches = value
    }

    /**
     * @param value Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
     */
    @JvmName("yvyjisfgnvolayae")
    public suspend fun containerExpirationPolicy(`value`: Output<ProjectContainerExpirationPolicyArgs>) {
        this.containerExpirationPolicy = value
    }

    /**
     * @param value Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("ldpnwjljwadokhrc")
    public suspend fun containerRegistryAccessLevel(`value`: Output<String>) {
        this.containerRegistryAccessLevel = value
    }

    /**
     * @param value Enable container registry for the project.
     */
    @Deprecated(
        message = """
  Use `container_registry_access_level` instead.
  """,
    )
    @JvmName("twyxyibsfjkjthkp")
    public suspend fun containerRegistryEnabled(`value`: Output<Boolean>) {
        this.containerRegistryEnabled = value
    }

    /**
     * @param value The default branch for the project.
     */
    @JvmName("pgkxnxofpaakbkqs")
    public suspend fun defaultBranch(`value`: Output<String>) {
        this.defaultBranch = value
    }

    /**
     * @param value A description of the project.
     */
    @JvmName("rahvcucyecrrlohl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Enable email notifications.
     */
    @JvmName("xfkbvvjihvnesrvv")
    public suspend fun emailsEnabled(`value`: Output<Boolean>) {
        this.emailsEnabled = value
    }

    /**
     * @param value Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("pmhxhxtttlgusufh")
    public suspend fun environmentsAccessLevel(`value`: Output<String>) {
        this.environmentsAccessLevel = value
    }

    /**
     * @param value The classification label for the project.
     */
    @JvmName("fpqlaqngwtlfpqih")
    public suspend fun externalAuthorizationClassificationLabel(`value`: Output<String>) {
        this.externalAuthorizationClassificationLabel = value
    }

    /**
     * @param value Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("eagnipsqlfvkjljd")
    public suspend fun featureFlagsAccessLevel(`value`: Output<String>) {
        this.featureFlagsAccessLevel = value
    }

    /**
     * @param value The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
     */
    @JvmName("dcgsngiwyvfelkoj")
    public suspend fun forkedFromProjectId(`value`: Output<Int>) {
        this.forkedFromProjectId = value
    }

    /**
     * @param value Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("fvhwplealmmysqay")
    public suspend fun forkingAccessLevel(`value`: Output<String>) {
        this.forkingAccessLevel = value
    }

    /**
     * @param value Enable group runners for this project.
     */
    @JvmName("wjiphgebxbeexgka")
    public suspend fun groupRunnersEnabled(`value`: Output<Boolean>) {
        this.groupRunnersEnabled = value
    }

    /**
     * @param value For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
     */
    @JvmName("tjmvfdxwvmluofff")
    public suspend fun groupWithProjectTemplatesId(`value`: Output<Int>) {
        this.groupWithProjectTemplatesId = value
    }

    /**
     * @param value Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import. Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using `pulumi import`. See the examples section for how to properly use it.
     */
    @JvmName("xfvxmrgfppspcibd")
    public suspend fun importUrl(`value`: Output<String>) {
        this.importUrl = value
    }

    /**
     * @param value The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`. See the examples section for how to properly use it.
     */
    @JvmName("rayelvgamgrdowoo")
    public suspend fun importUrlPassword(`value`: Output<String>) {
        this.importUrlPassword = value
    }

    /**
     * @param value The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`.  See the examples section for how to properly use it.
     */
    @JvmName("brcaempskpshdfud")
    public suspend fun importUrlUsername(`value`: Output<String>) {
        this.importUrlUsername = value
    }

    /**
     * @param value Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("vxpymkjvwfimbrvq")
    public suspend fun infrastructureAccessLevel(`value`: Output<String>) {
        this.infrastructureAccessLevel = value
    }

    /**
     * @param value Create main branch with first commit containing a README.md file. Must be set to `true` if importing an uninitialized project with a different `default_branch`.
     */
    @JvmName("pxlpjrrohgusflqr")
    public suspend fun initializeWithReadme(`value`: Output<Boolean>) {
        this.initializeWithReadme = value
    }

    /**
     * @param value Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("wwjxigcwbgcaeice")
    public suspend fun issuesAccessLevel(`value`: Output<String>) {
        this.issuesAccessLevel = value
    }

    /**
     * @param value Enable issue tracking for the project.
     */
    @JvmName("bnyjpdotceccbjvy")
    public suspend fun issuesEnabled(`value`: Output<Boolean>) {
        this.issuesEnabled = value
    }

    /**
     * @param value Sets the template for new issues in the project.
     */
    @JvmName("tevtxeiafsejiklh")
    public suspend fun issuesTemplate(`value`: Output<String>) {
        this.issuesTemplate = value
    }

    /**
     * @param value Disable or enable the ability to keep the latest artifact for this project.
     */
    @JvmName("voxahsacqrpavmlv")
    public suspend fun keepLatestArtifact(`value`: Output<Boolean>) {
        this.keepLatestArtifact = value
    }

    /**
     * @param value Enable LFS for the project.
     */
    @JvmName("ofvnotdgmnqobcas")
    public suspend fun lfsEnabled(`value`: Output<Boolean>) {
        this.lfsEnabled = value
    }

    /**
     * @param value Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
     */
    @JvmName("joqljtvowfuqrgic")
    public suspend fun mergeCommitTemplate(`value`: Output<String>) {
        this.mergeCommitTemplate = value
    }

    /**
     * @param value Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
     */
    @JvmName("khpwtxjsultgccvk")
    public suspend fun mergeMethod(`value`: Output<String>) {
        this.mergeMethod = value
    }

    /**
     * @param value Enable or disable merge pipelines.
     */
    @JvmName("qndnnsklydanpcwp")
    public suspend fun mergePipelinesEnabled(`value`: Output<Boolean>) {
        this.mergePipelinesEnabled = value
    }

    /**
     * @param value Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("lsrpsnsplyxfvbcb")
    public suspend fun mergeRequestsAccessLevel(`value`: Output<String>) {
        this.mergeRequestsAccessLevel = value
    }

    /**
     * @param value Enable merge requests for the project.
     */
    @JvmName("klcusrolusckcpcp")
    public suspend fun mergeRequestsEnabled(`value`: Output<Boolean>) {
        this.mergeRequestsEnabled = value
    }

    /**
     * @param value Sets the template for new merge requests in the project.
     */
    @JvmName("swsqucimfnhlwyct")
    public suspend fun mergeRequestsTemplate(`value`: Output<String>) {
        this.mergeRequestsTemplate = value
    }

    /**
     * @param value Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
     */
    @JvmName("sagyhlyjdghwwbsa")
    public suspend fun mergeTrainsEnabled(`value`: Output<Boolean>) {
        this.mergeTrainsEnabled = value
    }

    /**
     * @param value Enable project pull mirror.
     */
    @JvmName("drayaaeuxnhhvbxn")
    public suspend fun mirror(`value`: Output<Boolean>) {
        this.mirror = value
    }

    /**
     * @param value Enable overwrite diverged branches for a mirrored project.
     */
    @JvmName("hgoneexlnsgbujjv")
    public suspend fun mirrorOverwritesDivergedBranches(`value`: Output<Boolean>) {
        this.mirrorOverwritesDivergedBranches = value
    }

    /**
     * @param value Enable trigger builds on pushes for a mirrored project.
     */
    @JvmName("hvpgffvfbjhyotcm")
    public suspend fun mirrorTriggerBuilds(`value`: Output<Boolean>) {
        this.mirrorTriggerBuilds = value
    }

    /**
     * @param value Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("qqqcwmbxxsoguunj")
    public suspend fun monitorAccessLevel(`value`: Output<String>) {
        this.monitorAccessLevel = value
    }

    /**
     * @param value For forked projects, target merge requests to this project. If false, the target will be the upstream project.
     */
    @JvmName("hlyxbfcwganjdlku")
    public suspend fun mrDefaultTargetSelf(`value`: Output<Boolean>) {
        this.mrDefaultTargetSelf = value
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("ierkrcgfyrmuuqae")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The namespace (group or user) of the project. Defaults to your user.
     */
    @JvmName("kboekrsrykuhlprd")
    public suspend fun namespaceId(`value`: Output<Int>) {
        this.namespaceId = value
    }

    /**
     * @param value Set to true if you want allow merges only if all discussions are resolved.
     */
    @JvmName("abhvajowvvxubfgk")
    public suspend fun onlyAllowMergeIfAllDiscussionsAreResolved(`value`: Output<Boolean>) {
        this.onlyAllowMergeIfAllDiscussionsAreResolved = value
    }

    /**
     * @param value Set to true if you want allow merges only if a pipeline succeeds.
     */
    @JvmName("ggcevppkhnqmcydb")
    public suspend fun onlyAllowMergeIfPipelineSucceeds(`value`: Output<Boolean>) {
        this.onlyAllowMergeIfPipelineSucceeds = value
    }

    /**
     * @param value Enable only mirror protected branches for a mirrored project.
     */
    @JvmName("xxiwqeheshhfavgk")
    public suspend fun onlyMirrorProtectedBranches(`value`: Output<Boolean>) {
        this.onlyMirrorProtectedBranches = value
    }

    /**
     * @param value Enable packages repository for the project.
     */
    @JvmName("npxgbtelbetvvgii")
    public suspend fun packagesEnabled(`value`: Output<Boolean>) {
        this.packagesEnabled = value
    }

    /**
     * @param value Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
     */
    @JvmName("nsbdtoijlnngwstg")
    public suspend fun pagesAccessLevel(`value`: Output<String>) {
        this.pagesAccessLevel = value
    }

    /**
     * @param value The path of the repository.
     */
    @JvmName("jvjcvdbfhghodmor")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
     */
    @Deprecated(
        message = """
  Deprecated in favor of `builds_access_level`
  """,
    )
    @JvmName("yblfvxjujkgibjju")
    public suspend fun pipelinesEnabled(`value`: Output<Boolean>) {
        this.pipelinesEnabled = value
    }

    /**
     * @param value Whether Secret Push Detection is enabled. Requires GitLab Ultimate and at least GitLab 17.3.
     */
    @JvmName("labmocwccxjkycvr")
    public suspend fun preReceiveSecretDetectionEnabled(`value`: Output<Boolean>) {
        this.preReceiveSecretDetectionEnabled = value
    }

    /**
     * @param value Show link to create/view merge request when pushing from the command line
     */
    @JvmName("qkiltwxstaomjqnp")
    public suspend fun printingMergeRequestLinkEnabled(`value`: Output<Boolean>) {
        this.printingMergeRequestLinkEnabled = value
    }

    /**
     * @param value If true, jobs can be viewed by non-project members.
     */
    @Deprecated(
        message = """
  The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in
      the next major version of the provider.
  """,
    )
    @JvmName("dbtvucmgjjmetmxd")
    public suspend fun publicBuilds(`value`: Output<Boolean>) {
        this.publicBuilds = value
    }

    /**
     * @param value If true, jobs can be viewed by non-project members.
     */
    @JvmName("etyeovrlcumsgthw")
    public suspend fun publicJobs(`value`: Output<Boolean>) {
        this.publicJobs = value
    }

    /**
     * @param value Push rules for the project.
     */
    @JvmName("ibegjgpbhlubqnig")
    public suspend fun pushRules(`value`: Output<ProjectPushRulesArgs>) {
        this.pushRules = value
    }

    /**
     * @param value Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("ndmpykgkglvrvufe")
    public suspend fun releasesAccessLevel(`value`: Output<String>) {
        this.releasesAccessLevel = value
    }

    /**
     * @param value Enable `Delete source branch` option by default for all new merge requests.
     */
    @JvmName("orbgeydeeafagdyv")
    public suspend fun removeSourceBranchAfterMerge(`value`: Output<Boolean>) {
        this.removeSourceBranchAfterMerge = value
    }

    /**
     * @param value Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("rpiejhihdybuloue")
    public suspend fun repositoryAccessLevel(`value`: Output<String>) {
        this.repositoryAccessLevel = value
    }

    /**
     * @param value Which storage shard the repository is on. (administrator only)
     */
    @JvmName("pnkownpouovrbcay")
    public suspend fun repositoryStorage(`value`: Output<String>) {
        this.repositoryStorage = value
    }

    /**
     * @param value Allow users to request member access.
     */
    @JvmName("qqtxsybblehocdlh")
    public suspend fun requestAccessEnabled(`value`: Output<Boolean>) {
        this.requestAccessEnabled = value
    }

    /**
     * @param value Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("rwwwbpaxwmolbyhb")
    public suspend fun requirementsAccessLevel(`value`: Output<String>) {
        this.requirementsAccessLevel = value
    }

    /**
     * @param value Automatically resolve merge request diffs discussions on lines changed with a push.
     */
    @JvmName("nkynmxdexwemxhpb")
    public suspend fun resolveOutdatedDiffDiscussions(`value`: Output<Boolean>) {
        this.resolveOutdatedDiffDiscussions = value
    }

    /**
     * @param value Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
     */
    @JvmName("lriiamcpkurhwpde")
    public suspend fun restrictUserDefinedVariables(`value`: Output<Boolean>) {
        this.restrictUserDefinedVariables = value
    }

    /**
     * @param value Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("uueoawvvtdtkxidl")
    public suspend fun securityAndComplianceAccessLevel(`value`: Output<String>) {
        this.securityAndComplianceAccessLevel = value
    }

    /**
     * @param value Enable shared runners for this project.
     */
    @JvmName("sycxsbwljrtmxnom")
    public suspend fun sharedRunnersEnabled(`value`: Output<Boolean>) {
        this.sharedRunnersEnabled = value
    }

    /**
     * @param value If `true`, the default behavior to wait for the default branch protection to be created is skipped.
     * This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
     * There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
     * This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
     */
    @JvmName("iyqeqbxvdchgcgyl")
    public suspend fun skipWaitForDefaultBranchProtection(`value`: Output<Boolean>) {
        this.skipWaitForDefaultBranchProtection = value
    }

    /**
     * @param value Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("rivvpgvnsmstjcgp")
    public suspend fun snippetsAccessLevel(`value`: Output<String>) {
        this.snippetsAccessLevel = value
    }

    /**
     * @param value Enable snippets for the project.
     */
    @JvmName("oqlbkfnibsddlajv")
    public suspend fun snippetsEnabled(`value`: Output<Boolean>) {
        this.snippetsEnabled = value
    }

    /**
     * @param value Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
     */
    @JvmName("banitdvebahwafdx")
    public suspend fun squashCommitTemplate(`value`: Output<String>) {
        this.squashCommitTemplate = value
    }

    /**
     * @param value Squash commits when merge request. Valid values are `never`, `always`, `default_on`, or `default_off`. The default value is `default_off`. [GitLab >= 14&#46;1]
     */
    @JvmName("rjoqaeaxamuhghvf")
    public suspend fun squashOption(`value`: Output<String>) {
        this.squashOption = value
    }

    /**
     * @param value The commit message used to apply merge request suggestions.
     */
    @JvmName("ydtiomjictxfvuxh")
    public suspend fun suggestionCommitMessage(`value`: Output<String>) {
        this.suggestionCommitMessage = value
    }

    /**
     * @param value The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
     */
    @JvmName("kgfjcjgdewojoooo")
    public suspend fun tags(`value`: Output<List<String>>) {
        this.tags = value
    }

    @JvmName("esllbctsedpqshbu")
    public suspend fun tags(vararg values: Output<String>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
     */
    @JvmName("othckjpeihhwxywr")
    public suspend fun tags(values: List<Output<String>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
     */
    @JvmName("umpwyuhpbngdneoy")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `gitlab.GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
     */
    @JvmName("wffsuegpcpgeacac")
    public suspend fun templateProjectId(`value`: Output<Int>) {
        this.templateProjectId = value
    }

    /**
     * @param value The list of topics for the project.
     */
    @JvmName("yvirehxsuirjgdmt")
    public suspend fun topics(`value`: Output<List<String>>) {
        this.topics = value
    }

    @JvmName("lgqarufdjyjjkatf")
    public suspend fun topics(vararg values: Output<String>) {
        this.topics = Output.all(values.asList())
    }

    /**
     * @param values The list of topics for the project.
     */
    @JvmName("tucenomtcxwhrelk")
    public suspend fun topics(values: List<Output<String>>) {
        this.topics = Output.all(values)
    }

    /**
     * @param value Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
     * 	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting.html#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
     */
    @JvmName("tngwmpixxmxtrixy")
    public suspend fun useCustomTemplate(`value`: Output<Boolean>) {
        this.useCustomTemplate = value
    }

    /**
     * @param value Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
     */
    @JvmName("cqqramxouklhekru")
    public suspend fun visibilityLevel(`value`: Output<String>) {
        this.visibilityLevel = value
    }

    /**
     * @param value Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("ebujtgymrbnuboij")
    public suspend fun wikiAccessLevel(`value`: Output<String>) {
        this.wikiAccessLevel = value
    }

    /**
     * @param value Enable wiki for the project.
     */
    @JvmName("nrkyeuiwdmoqpyvi")
    public suspend fun wikiEnabled(`value`: Output<Boolean>) {
        this.wikiEnabled = value
    }

    /**
     * @param value Set to true if you want to treat skipped pipelines as if they finished with success.
     */
    @JvmName("mirbbssxaljxykqd")
    public suspend fun allowMergeOnSkippedPipeline(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowMergeOnSkippedPipeline = mapped
    }

    /**
     * @param value Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("rnbcdnctnuskscbg")
    public suspend fun analyticsAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analyticsAccessLevel = mapped
    }

    /**
     * @param value Number of merge request approvals required for merging. Default is 0.
     * This field **does not** work well in combination with the `gitlab.ProjectApprovalRule` resource
     * and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
     * In the meantime we recommend against using this attribute and use `gitlab.ProjectApprovalRule` instead.
     */
    @JvmName("aodyvnlxfsphehdh")
    public suspend fun approvalsBeforeMerge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvalsBeforeMerge = mapped
    }

    /**
     * @param value Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
     */
    @JvmName("sfpqmdouqaeyjcog")
    public suspend fun archiveOnDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveOnDestroy = mapped
    }

    /**
     * @param value Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
     */
    @JvmName("wwtkkoocnbvoykyy")
    public suspend fun archived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archived = mapped
    }

    /**
     * @param value Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
     */
    @JvmName("wpeoskysqydwqiyj")
    public suspend fun autoCancelPendingPipelines(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoCancelPendingPipelines = mapped
    }

    /**
     * @param value Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
     */
    @JvmName("mjtewqtvmuvxgljc")
    public suspend fun autoDevopsDeployStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDevopsDeployStrategy = mapped
    }

    /**
     * @param value Enable Auto DevOps for this project.
     */
    @JvmName("twnngvvnpgupwpux")
    public suspend fun autoDevopsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDevopsEnabled = mapped
    }

    /**
     * @param value Set whether auto-closing referenced issues on default branch.
     */
    @JvmName("rnpwflqrqmhvulbv")
    public suspend fun autocloseReferencedIssues(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autocloseReferencedIssues = mapped
    }

    /**
     * @param value A local path to the avatar image to upload. **Note**: not available for imported resources.
     */
    @JvmName("btfeproybvjnhdva")
    public suspend fun avatar(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.avatar = mapped
    }

    /**
     * @param value The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
     */
    @JvmName("xsnmuvacwoyxwdxs")
    public suspend fun avatarHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.avatarHash = mapped
    }

    /**
     * @param value Test coverage parsing for the project. This is deprecated feature in GitLab 15.0.
     */
    @Deprecated(
        message = """
  build_coverage_regex is removed in GitLab 15.0.
  """,
    )
    @JvmName("nemniafwrropyeju")
    public suspend fun buildCoverageRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildCoverageRegex = mapped
    }

    /**
     * @param value The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
     */
    @JvmName("hhtyuevoatadigfy")
    public suspend fun buildGitStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildGitStrategy = mapped
    }

    /**
     * @param value The maximum amount of time, in seconds, that a job can run.
     */
    @JvmName("tfcqmetmftrlswsu")
    public suspend fun buildTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildTimeout = mapped
    }

    /**
     * @param value Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("uvvcjpsdegdwusag")
    public suspend fun buildsAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildsAccessLevel = mapped
    }

    /**
     * @param value Custom Path to CI config file.
     */
    @JvmName("dxpbiggxwthdjpvo")
    public suspend fun ciConfigPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ciConfigPath = mapped
    }

    /**
     * @param value Default number of revisions for shallow cloning.
     */
    @JvmName("maadipqjpbtsjudg")
    public suspend fun ciDefaultGitDepth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ciDefaultGitDepth = mapped
    }

    /**
     * @param value When a new deployment job starts, skip older deployment jobs that are still pending.
     */
    @JvmName("soxounggcwneabpv")
    public suspend fun ciForwardDeploymentEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ciForwardDeploymentEnabled = mapped
    }

    /**
     * @param value The role required to cancel a pipeline or job. Introduced in GitLab 16.8. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
     */
    @JvmName("jaggleyduboladub")
    public suspend fun ciRestrictPipelineCancellationRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ciRestrictPipelineCancellationRole = mapped
    }

    /**
     * @param value Use separate caches for protected branches.
     */
    @JvmName("epmanewujxqediql")
    public suspend fun ciSeparatedCaches(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ciSeparatedCaches = mapped
    }

    /**
     * @param value Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
     */
    @JvmName("eddfqddjuvihbplj")
    public suspend fun containerExpirationPolicy(`value`: ProjectContainerExpirationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerExpirationPolicy = mapped
    }

    /**
     * @param argument Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
     */
    @JvmName("vsdfrjepngjvtgoy")
    public suspend fun containerExpirationPolicy(argument: suspend ProjectContainerExpirationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectContainerExpirationPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.containerExpirationPolicy = mapped
    }

    /**
     * @param value Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("eqgdpawbflkjpdqw")
    public suspend fun containerRegistryAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistryAccessLevel = mapped
    }

    /**
     * @param value Enable container registry for the project.
     */
    @Deprecated(
        message = """
  Use `container_registry_access_level` instead.
  """,
    )
    @JvmName("clxnyfpvbmaeewis")
    public suspend fun containerRegistryEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistryEnabled = mapped
    }

    /**
     * @param value The default branch for the project.
     */
    @JvmName("roxdhwpmsbywgvkj")
    public suspend fun defaultBranch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultBranch = mapped
    }

    /**
     * @param value A description of the project.
     */
    @JvmName("piynmvmvpjqcdokj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Enable email notifications.
     */
    @JvmName("vwwxsuohxhkfavcp")
    public suspend fun emailsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailsEnabled = mapped
    }

    /**
     * @param value Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("hojbcwqyafklwask")
    public suspend fun environmentsAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentsAccessLevel = mapped
    }

    /**
     * @param value The classification label for the project.
     */
    @JvmName("pglhreebaetriinw")
    public suspend fun externalAuthorizationClassificationLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAuthorizationClassificationLabel = mapped
    }

    /**
     * @param value Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("lghcxhkgfcntkfim")
    public suspend fun featureFlagsAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureFlagsAccessLevel = mapped
    }

    /**
     * @param value The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
     */
    @JvmName("yxolqjmnuimdsncv")
    public suspend fun forkedFromProjectId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forkedFromProjectId = mapped
    }

    /**
     * @param value Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("bnlnrprkryqgmwfp")
    public suspend fun forkingAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forkingAccessLevel = mapped
    }

    /**
     * @param value Enable group runners for this project.
     */
    @JvmName("nnqyjecpmkvlxfme")
    public suspend fun groupRunnersEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupRunnersEnabled = mapped
    }

    /**
     * @param value For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
     */
    @JvmName("rhkbtdoksyfttpos")
    public suspend fun groupWithProjectTemplatesId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupWithProjectTemplatesId = mapped
    }

    /**
     * @param value Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import. Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using `pulumi import`. See the examples section for how to properly use it.
     */
    @JvmName("gnytxpfywibjklpj")
    public suspend fun importUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importUrl = mapped
    }

    /**
     * @param value The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`. See the examples section for how to properly use it.
     */
    @JvmName("hsbmxbvckclbogfq")
    public suspend fun importUrlPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importUrlPassword = mapped
    }

    /**
     * @param value The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`.  See the examples section for how to properly use it.
     */
    @JvmName("bpkumymifbxvcvtg")
    public suspend fun importUrlUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importUrlUsername = mapped
    }

    /**
     * @param value Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("uxswdmnldcqshark")
    public suspend fun infrastructureAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureAccessLevel = mapped
    }

    /**
     * @param value Create main branch with first commit containing a README.md file. Must be set to `true` if importing an uninitialized project with a different `default_branch`.
     */
    @JvmName("dcailgoliatxcnfo")
    public suspend fun initializeWithReadme(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initializeWithReadme = mapped
    }

    /**
     * @param value Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("avxbscadtqvvrfis")
    public suspend fun issuesAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuesAccessLevel = mapped
    }

    /**
     * @param value Enable issue tracking for the project.
     */
    @JvmName("hkorryhylwsofitk")
    public suspend fun issuesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuesEnabled = mapped
    }

    /**
     * @param value Sets the template for new issues in the project.
     */
    @JvmName("qwyksjkqgnooyfjm")
    public suspend fun issuesTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuesTemplate = mapped
    }

    /**
     * @param value Disable or enable the ability to keep the latest artifact for this project.
     */
    @JvmName("gnecugfdfywmdjtg")
    public suspend fun keepLatestArtifact(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keepLatestArtifact = mapped
    }

    /**
     * @param value Enable LFS for the project.
     */
    @JvmName("dliqrtmvpmbbopsv")
    public suspend fun lfsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lfsEnabled = mapped
    }

    /**
     * @param value Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
     */
    @JvmName("pmypekuseuftwbsx")
    public suspend fun mergeCommitTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeCommitTemplate = mapped
    }

    /**
     * @param value Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
     */
    @JvmName("lgpaiglxhnhljcsx")
    public suspend fun mergeMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeMethod = mapped
    }

    /**
     * @param value Enable or disable merge pipelines.
     */
    @JvmName("iqhwouyuivjycgck")
    public suspend fun mergePipelinesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergePipelinesEnabled = mapped
    }

    /**
     * @param value Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("mpkmhpmffnhicmip")
    public suspend fun mergeRequestsAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestsAccessLevel = mapped
    }

    /**
     * @param value Enable merge requests for the project.
     */
    @JvmName("cadeyoncxgflknvw")
    public suspend fun mergeRequestsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestsEnabled = mapped
    }

    /**
     * @param value Sets the template for new merge requests in the project.
     */
    @JvmName("xshaesxuslbsatll")
    public suspend fun mergeRequestsTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestsTemplate = mapped
    }

    /**
     * @param value Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
     */
    @JvmName("hgrwifbeibplwvrt")
    public suspend fun mergeTrainsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeTrainsEnabled = mapped
    }

    /**
     * @param value Enable project pull mirror.
     */
    @JvmName("eifnsqtsquabxiog")
    public suspend fun mirror(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mirror = mapped
    }

    /**
     * @param value Enable overwrite diverged branches for a mirrored project.
     */
    @JvmName("nplbirmxymsrtymd")
    public suspend fun mirrorOverwritesDivergedBranches(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mirrorOverwritesDivergedBranches = mapped
    }

    /**
     * @param value Enable trigger builds on pushes for a mirrored project.
     */
    @JvmName("kieeuuhfapxhglsg")
    public suspend fun mirrorTriggerBuilds(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mirrorTriggerBuilds = mapped
    }

    /**
     * @param value Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("olxcpywtihnfiljh")
    public suspend fun monitorAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorAccessLevel = mapped
    }

    /**
     * @param value For forked projects, target merge requests to this project. If false, the target will be the upstream project.
     */
    @JvmName("viaequpkeobfirek")
    public suspend fun mrDefaultTargetSelf(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mrDefaultTargetSelf = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("wisbrwsrqaevbuch")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The namespace (group or user) of the project. Defaults to your user.
     */
    @JvmName("cplsfucsuspykfyr")
    public suspend fun namespaceId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceId = mapped
    }

    /**
     * @param value Set to true if you want allow merges only if all discussions are resolved.
     */
    @JvmName("xndvfvdvsaqlgrps")
    public suspend fun onlyAllowMergeIfAllDiscussionsAreResolved(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onlyAllowMergeIfAllDiscussionsAreResolved = mapped
    }

    /**
     * @param value Set to true if you want allow merges only if a pipeline succeeds.
     */
    @JvmName("ieirdbobsdynpuib")
    public suspend fun onlyAllowMergeIfPipelineSucceeds(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onlyAllowMergeIfPipelineSucceeds = mapped
    }

    /**
     * @param value Enable only mirror protected branches for a mirrored project.
     */
    @JvmName("hlbamirrknjsjfou")
    public suspend fun onlyMirrorProtectedBranches(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onlyMirrorProtectedBranches = mapped
    }

    /**
     * @param value Enable packages repository for the project.
     */
    @JvmName("plaeekswjwwqjxlp")
    public suspend fun packagesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packagesEnabled = mapped
    }

    /**
     * @param value Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
     */
    @JvmName("vhvhitxuldijsceo")
    public suspend fun pagesAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pagesAccessLevel = mapped
    }

    /**
     * @param value The path of the repository.
     */
    @JvmName("pgdavvpdtnbemghi")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
     */
    @Deprecated(
        message = """
  Deprecated in favor of `builds_access_level`
  """,
    )
    @JvmName("eptsgkbjsmjbqxum")
    public suspend fun pipelinesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelinesEnabled = mapped
    }

    /**
     * @param value Whether Secret Push Detection is enabled. Requires GitLab Ultimate and at least GitLab 17.3.
     */
    @JvmName("ynapvspqsjqapfxj")
    public suspend fun preReceiveSecretDetectionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preReceiveSecretDetectionEnabled = mapped
    }

    /**
     * @param value Show link to create/view merge request when pushing from the command line
     */
    @JvmName("vebblpifhcjjsivu")
    public suspend fun printingMergeRequestLinkEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.printingMergeRequestLinkEnabled = mapped
    }

    /**
     * @param value If true, jobs can be viewed by non-project members.
     */
    @Deprecated(
        message = """
  The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in
      the next major version of the provider.
  """,
    )
    @JvmName("wsbjymeyfnifxllh")
    public suspend fun publicBuilds(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicBuilds = mapped
    }

    /**
     * @param value If true, jobs can be viewed by non-project members.
     */
    @JvmName("bfbnwatvdegdvyoj")
    public suspend fun publicJobs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicJobs = mapped
    }

    /**
     * @param value Push rules for the project.
     */
    @JvmName("fbctvcdpffrrfryo")
    public suspend fun pushRules(`value`: ProjectPushRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushRules = mapped
    }

    /**
     * @param argument Push rules for the project.
     */
    @JvmName("tfmaniovanqkgjuu")
    public suspend fun pushRules(argument: suspend ProjectPushRulesArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectPushRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pushRules = mapped
    }

    /**
     * @param value Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("mfksmvjsocrtrrtl")
    public suspend fun releasesAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releasesAccessLevel = mapped
    }

    /**
     * @param value Enable `Delete source branch` option by default for all new merge requests.
     */
    @JvmName("yrxidusckitfgkvr")
    public suspend fun removeSourceBranchAfterMerge(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.removeSourceBranchAfterMerge = mapped
    }

    /**
     * @param value Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("blsvmqunsslcuplj")
    public suspend fun repositoryAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryAccessLevel = mapped
    }

    /**
     * @param value Which storage shard the repository is on. (administrator only)
     */
    @JvmName("rquwgtdieyqypurc")
    public suspend fun repositoryStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryStorage = mapped
    }

    /**
     * @param value Allow users to request member access.
     */
    @JvmName("vjxqdlyelilvdsds")
    public suspend fun requestAccessEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestAccessEnabled = mapped
    }

    /**
     * @param value Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("niomlsghhaypxmys")
    public suspend fun requirementsAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requirementsAccessLevel = mapped
    }

    /**
     * @param value Automatically resolve merge request diffs discussions on lines changed with a push.
     */
    @JvmName("vcqeiamdadvmjllk")
    public suspend fun resolveOutdatedDiffDiscussions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolveOutdatedDiffDiscussions = mapped
    }

    /**
     * @param value Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
     */
    @JvmName("jaudnlgeojwxrsei")
    public suspend fun restrictUserDefinedVariables(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictUserDefinedVariables = mapped
    }

    /**
     * @param value Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("qfdqiehfvvcunhtb")
    public suspend fun securityAndComplianceAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityAndComplianceAccessLevel = mapped
    }

    /**
     * @param value Enable shared runners for this project.
     */
    @JvmName("ssacvdpyjfnkdkir")
    public suspend fun sharedRunnersEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedRunnersEnabled = mapped
    }

    /**
     * @param value If `true`, the default behavior to wait for the default branch protection to be created is skipped.
     * This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
     * There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
     * This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
     */
    @JvmName("mxybksxjfircibhl")
    public suspend fun skipWaitForDefaultBranchProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipWaitForDefaultBranchProtection = mapped
    }

    /**
     * @param value Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("uudnuhhivkstjqvr")
    public suspend fun snippetsAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snippetsAccessLevel = mapped
    }

    /**
     * @param value Enable snippets for the project.
     */
    @JvmName("hvautuctbvqvhlen")
    public suspend fun snippetsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snippetsEnabled = mapped
    }

    /**
     * @param value Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
     */
    @JvmName("anxfhitdaipemrrt")
    public suspend fun squashCommitTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.squashCommitTemplate = mapped
    }

    /**
     * @param value Squash commits when merge request. Valid values are `never`, `always`, `default_on`, or `default_off`. The default value is `default_off`. [GitLab >= 14&#46;1]
     */
    @JvmName("bkosqqlyhqrrqkhn")
    public suspend fun squashOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.squashOption = mapped
    }

    /**
     * @param value The commit message used to apply merge request suggestions.
     */
    @JvmName("perqxwavobndyjrt")
    public suspend fun suggestionCommitMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suggestionCommitMessage = mapped
    }

    /**
     * @param value The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
     */
    @JvmName("hmacpfgvcqtuwudo")
    public suspend fun tags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
     */
    @JvmName("kmnwvarjxsxyrahs")
    public suspend fun tags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
     */
    @JvmName("gsldaygcpgmvgujh")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    /**
     * @param value When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `gitlab.GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
     */
    @JvmName("baougthwreydybig")
    public suspend fun templateProjectId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateProjectId = mapped
    }

    /**
     * @param value The list of topics for the project.
     */
    @JvmName("ljyrglntscrbwqvu")
    public suspend fun topics(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topics = mapped
    }

    /**
     * @param values The list of topics for the project.
     */
    @JvmName("gkgaudrqicouwxku")
    public suspend fun topics(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topics = mapped
    }

    /**
     * @param value Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
     * 	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting.html#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
     */
    @JvmName("kbtojkubiamopuvu")
    public suspend fun useCustomTemplate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCustomTemplate = mapped
    }

    /**
     * @param value Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
     */
    @JvmName("gupdrreaatiiegqb")
    public suspend fun visibilityLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibilityLevel = mapped
    }

    /**
     * @param value Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
     */
    @JvmName("fhsppmbdkwivctev")
    public suspend fun wikiAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wikiAccessLevel = mapped
    }

    /**
     * @param value Enable wiki for the project.
     */
    @JvmName("smnseqxsigjosoom")
    public suspend fun wikiEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wikiEnabled = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        allowMergeOnSkippedPipeline = allowMergeOnSkippedPipeline,
        analyticsAccessLevel = analyticsAccessLevel,
        approvalsBeforeMerge = approvalsBeforeMerge,
        archiveOnDestroy = archiveOnDestroy,
        archived = archived,
        autoCancelPendingPipelines = autoCancelPendingPipelines,
        autoDevopsDeployStrategy = autoDevopsDeployStrategy,
        autoDevopsEnabled = autoDevopsEnabled,
        autocloseReferencedIssues = autocloseReferencedIssues,
        avatar = avatar,
        avatarHash = avatarHash,
        buildCoverageRegex = buildCoverageRegex,
        buildGitStrategy = buildGitStrategy,
        buildTimeout = buildTimeout,
        buildsAccessLevel = buildsAccessLevel,
        ciConfigPath = ciConfigPath,
        ciDefaultGitDepth = ciDefaultGitDepth,
        ciForwardDeploymentEnabled = ciForwardDeploymentEnabled,
        ciRestrictPipelineCancellationRole = ciRestrictPipelineCancellationRole,
        ciSeparatedCaches = ciSeparatedCaches,
        containerExpirationPolicy = containerExpirationPolicy,
        containerRegistryAccessLevel = containerRegistryAccessLevel,
        containerRegistryEnabled = containerRegistryEnabled,
        defaultBranch = defaultBranch,
        description = description,
        emailsEnabled = emailsEnabled,
        environmentsAccessLevel = environmentsAccessLevel,
        externalAuthorizationClassificationLabel = externalAuthorizationClassificationLabel,
        featureFlagsAccessLevel = featureFlagsAccessLevel,
        forkedFromProjectId = forkedFromProjectId,
        forkingAccessLevel = forkingAccessLevel,
        groupRunnersEnabled = groupRunnersEnabled,
        groupWithProjectTemplatesId = groupWithProjectTemplatesId,
        importUrl = importUrl,
        importUrlPassword = importUrlPassword,
        importUrlUsername = importUrlUsername,
        infrastructureAccessLevel = infrastructureAccessLevel,
        initializeWithReadme = initializeWithReadme,
        issuesAccessLevel = issuesAccessLevel,
        issuesEnabled = issuesEnabled,
        issuesTemplate = issuesTemplate,
        keepLatestArtifact = keepLatestArtifact,
        lfsEnabled = lfsEnabled,
        mergeCommitTemplate = mergeCommitTemplate,
        mergeMethod = mergeMethod,
        mergePipelinesEnabled = mergePipelinesEnabled,
        mergeRequestsAccessLevel = mergeRequestsAccessLevel,
        mergeRequestsEnabled = mergeRequestsEnabled,
        mergeRequestsTemplate = mergeRequestsTemplate,
        mergeTrainsEnabled = mergeTrainsEnabled,
        mirror = mirror,
        mirrorOverwritesDivergedBranches = mirrorOverwritesDivergedBranches,
        mirrorTriggerBuilds = mirrorTriggerBuilds,
        monitorAccessLevel = monitorAccessLevel,
        mrDefaultTargetSelf = mrDefaultTargetSelf,
        name = name,
        namespaceId = namespaceId,
        onlyAllowMergeIfAllDiscussionsAreResolved = onlyAllowMergeIfAllDiscussionsAreResolved,
        onlyAllowMergeIfPipelineSucceeds = onlyAllowMergeIfPipelineSucceeds,
        onlyMirrorProtectedBranches = onlyMirrorProtectedBranches,
        packagesEnabled = packagesEnabled,
        pagesAccessLevel = pagesAccessLevel,
        path = path,
        pipelinesEnabled = pipelinesEnabled,
        preReceiveSecretDetectionEnabled = preReceiveSecretDetectionEnabled,
        printingMergeRequestLinkEnabled = printingMergeRequestLinkEnabled,
        publicBuilds = publicBuilds,
        publicJobs = publicJobs,
        pushRules = pushRules,
        releasesAccessLevel = releasesAccessLevel,
        removeSourceBranchAfterMerge = removeSourceBranchAfterMerge,
        repositoryAccessLevel = repositoryAccessLevel,
        repositoryStorage = repositoryStorage,
        requestAccessEnabled = requestAccessEnabled,
        requirementsAccessLevel = requirementsAccessLevel,
        resolveOutdatedDiffDiscussions = resolveOutdatedDiffDiscussions,
        restrictUserDefinedVariables = restrictUserDefinedVariables,
        securityAndComplianceAccessLevel = securityAndComplianceAccessLevel,
        sharedRunnersEnabled = sharedRunnersEnabled,
        skipWaitForDefaultBranchProtection = skipWaitForDefaultBranchProtection,
        snippetsAccessLevel = snippetsAccessLevel,
        snippetsEnabled = snippetsEnabled,
        squashCommitTemplate = squashCommitTemplate,
        squashOption = squashOption,
        suggestionCommitMessage = suggestionCommitMessage,
        tags = tags,
        templateName = templateName,
        templateProjectId = templateProjectId,
        topics = topics,
        useCustomTemplate = useCustomTemplate,
        visibilityLevel = visibilityLevel,
        wikiAccessLevel = wikiAccessLevel,
        wikiEnabled = wikiEnabled,
    )
}
