@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectBadge].
 */
@PulumiTagMarker
public class ProjectBadgeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectBadgeArgs = ProjectBadgeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectBadgeArgsBuilder.() -> Unit) {
        val builder = ProjectBadgeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectBadge {
        val builtJavaResource = com.pulumi.gitlab.ProjectBadge(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectBadge(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectBadge` resource allows to manage the lifecycle of project badges.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/user/project/badges.html#project-badges)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.Project("foo", {name: "foo-project"});
 * const example = new gitlab.ProjectBadge("example", {
 *     project: foo.id,
 *     linkUrl: "https://example.com/badge-123",
 *     imageUrl: "https://example.com/badge-123.svg",
 *     name: "badge-123",
 * });
 * // Pipeline status badges with placeholders will be enabled
 * const gitlabPipeline = new gitlab.ProjectBadge("gitlab_pipeline", {
 *     project: foo.id,
 *     linkUrl: "https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}",
 *     imageUrl: "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg",
 *     name: "badge-pipeline",
 * });
 * // Test coverage report badges with placeholders will be enabled
 * const gitlabCoverage = new gitlab.ProjectBadge("gitlab_coverage", {
 *     project: foo.id,
 *     linkUrl: "https://gitlab.example.com/%{project_path}/-/jobs",
 *     imageUrl: "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg",
 *     name: "badge-coverage",
 * });
 * // Latest release badges with placeholders will be enabled
 * const gitlabRelease = new gitlab.ProjectBadge("gitlab_release", {
 *     project: foo.id,
 *     linkUrl: "https://gitlab.example.com/%{project_path}/-/releases",
 *     imageUrl: "https://gitlab.example.com/%{project_path}/-/badges/release.svg",
 *     name: "badge-release",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.Project("foo", name="foo-project")
 * example = gitlab.ProjectBadge("example",
 *     project=foo.id,
 *     link_url="https://example.com/badge-123",
 *     image_url="https://example.com/badge-123.svg",
 *     name="badge-123")
 * # Pipeline status badges with placeholders will be enabled
 * gitlab_pipeline = gitlab.ProjectBadge("gitlab_pipeline",
 *     project=foo.id,
 *     link_url="https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}",
 *     image_url="https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg",
 *     name="badge-pipeline")
 * # Test coverage report badges with placeholders will be enabled
 * gitlab_coverage = gitlab.ProjectBadge("gitlab_coverage",
 *     project=foo.id,
 *     link_url="https://gitlab.example.com/%{project_path}/-/jobs",
 *     image_url="https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg",
 *     name="badge-coverage")
 * # Latest release badges with placeholders will be enabled
 * gitlab_release = gitlab.ProjectBadge("gitlab_release",
 *     project=foo.id,
 *     link_url="https://gitlab.example.com/%{project_path}/-/releases",
 *     image_url="https://gitlab.example.com/%{project_path}/-/badges/release.svg",
 *     name="badge-release")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.Project("foo", new()
 *     {
 *         Name = "foo-project",
 *     });
 *     var example = new GitLab.ProjectBadge("example", new()
 *     {
 *         Project = foo.Id,
 *         LinkUrl = "https://example.com/badge-123",
 *         ImageUrl = "https://example.com/badge-123.svg",
 *         Name = "badge-123",
 *     });
 *     // Pipeline status badges with placeholders will be enabled
 *     var gitlabPipeline = new GitLab.ProjectBadge("gitlab_pipeline", new()
 *     {
 *         Project = foo.Id,
 *         LinkUrl = "https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}",
 *         ImageUrl = "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg",
 *         Name = "badge-pipeline",
 *     });
 *     // Test coverage report badges with placeholders will be enabled
 *     var gitlabCoverage = new GitLab.ProjectBadge("gitlab_coverage", new()
 *     {
 *         Project = foo.Id,
 *         LinkUrl = "https://gitlab.example.com/%{project_path}/-/jobs",
 *         ImageUrl = "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg",
 *         Name = "badge-coverage",
 *     });
 *     // Latest release badges with placeholders will be enabled
 *     var gitlabRelease = new GitLab.ProjectBadge("gitlab_release", new()
 *     {
 *         Project = foo.Id,
 *         LinkUrl = "https://gitlab.example.com/%{project_path}/-/releases",
 *         ImageUrl = "https://gitlab.example.com/%{project_path}/-/badges/release.svg",
 *         Name = "badge-release",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := gitlab.NewProject(ctx, "foo", &gitlab.ProjectArgs{
 * 			Name: pulumi.String("foo-project"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectBadge(ctx, "example", &gitlab.ProjectBadgeArgs{
 * 			Project:  foo.ID(),
 * 			LinkUrl:  pulumi.String("https://example.com/badge-123"),
 * 			ImageUrl: pulumi.String("https://example.com/badge-123.svg"),
 * 			Name:     pulumi.String("badge-123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Pipeline status badges with placeholders will be enabled
 * 		_, err = gitlab.NewProjectBadge(ctx, "gitlab_pipeline", &gitlab.ProjectBadgeArgs{
 * 			Project:  foo.ID(),
 * 			LinkUrl:  pulumi.String("https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}"),
 * 			ImageUrl: pulumi.String("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg"),
 * 			Name:     pulumi.String("badge-pipeline"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Test coverage report badges with placeholders will be enabled
 * 		_, err = gitlab.NewProjectBadge(ctx, "gitlab_coverage", &gitlab.ProjectBadgeArgs{
 * 			Project:  foo.ID(),
 * 			LinkUrl:  pulumi.String("https://gitlab.example.com/%{project_path}/-/jobs"),
 * 			ImageUrl: pulumi.String("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg"),
 * 			Name:     pulumi.String("badge-coverage"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Latest release badges with placeholders will be enabled
 * 		_, err = gitlab.NewProjectBadge(ctx, "gitlab_release", &gitlab.ProjectBadgeArgs{
 * 			Project:  foo.ID(),
 * 			LinkUrl:  pulumi.String("https://gitlab.example.com/%{project_path}/-/releases"),
 * 			ImageUrl: pulumi.String("https://gitlab.example.com/%{project_path}/-/badges/release.svg"),
 * 			Name:     pulumi.String("badge-release"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ProjectBadge;
 * import com.pulumi.gitlab.ProjectBadgeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Project("foo", ProjectArgs.builder()
 *             .name("foo-project")
 *             .build());
 *         var example = new ProjectBadge("example", ProjectBadgeArgs.builder()
 *             .project(foo.id())
 *             .linkUrl("https://example.com/badge-123")
 *             .imageUrl("https://example.com/badge-123.svg")
 *             .name("badge-123")
 *             .build());
 *         // Pipeline status badges with placeholders will be enabled
 *         var gitlabPipeline = new ProjectBadge("gitlabPipeline", ProjectBadgeArgs.builder()
 *             .project(foo.id())
 *             .linkUrl("https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}")
 *             .imageUrl("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg")
 *             .name("badge-pipeline")
 *             .build());
 *         // Test coverage report badges with placeholders will be enabled
 *         var gitlabCoverage = new ProjectBadge("gitlabCoverage", ProjectBadgeArgs.builder()
 *             .project(foo.id())
 *             .linkUrl("https://gitlab.example.com/%{project_path}/-/jobs")
 *             .imageUrl("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg")
 *             .name("badge-coverage")
 *             .build());
 *         // Latest release badges with placeholders will be enabled
 *         var gitlabRelease = new ProjectBadge("gitlabRelease", ProjectBadgeArgs.builder()
 *             .project(foo.id())
 *             .linkUrl("https://gitlab.example.com/%{project_path}/-/releases")
 *             .imageUrl("https://gitlab.example.com/%{project_path}/-/badges/release.svg")
 *             .name("badge-release")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:Project
 *     properties:
 *       name: foo-project
 *   example:
 *     type: gitlab:ProjectBadge
 *     properties:
 *       project: ${foo.id}
 *       linkUrl: https://example.com/badge-123
 *       imageUrl: https://example.com/badge-123.svg
 *       name: badge-123
 *   # Pipeline status badges with placeholders will be enabled
 *   gitlabPipeline:
 *     type: gitlab:ProjectBadge
 *     name: gitlab_pipeline
 *     properties:
 *       project: ${foo.id}
 *       linkUrl: https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}
 *       imageUrl: https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg
 *       name: badge-pipeline
 *   # Test coverage report badges with placeholders will be enabled
 *   gitlabCoverage:
 *     type: gitlab:ProjectBadge
 *     name: gitlab_coverage
 *     properties:
 *       project: ${foo.id}
 *       linkUrl: https://gitlab.example.com/%{project_path}/-/jobs
 *       imageUrl: https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg
 *       name: badge-coverage
 *   # Latest release badges with placeholders will be enabled
 *   gitlabRelease:
 *     type: gitlab:ProjectBadge
 *     name: gitlab_release
 *     properties:
 *       project: ${foo.id}
 *       linkUrl: https://gitlab.example.com/%{project_path}/-/releases
 *       imageUrl: https://gitlab.example.com/%{project_path}/-/badges/release.svg
 *       name: badge-release
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project badges can be imported using an id made up of `{project_id}:{badge_id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectBadge:ProjectBadge foo 1:3
 * ```
 */
public class ProjectBadge internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectBadge,
) : KotlinCustomResource(javaResource, ProjectBadgeMapper) {
    /**
     * The image url which will be presented on project overview.
     */
    public val imageUrl: Output<String>
        get() = javaResource.imageUrl().applyValue({ args0 -> args0 })

    /**
     * The url linked with the badge.
     */
    public val linkUrl: Output<String>
        get() = javaResource.linkUrl().applyValue({ args0 -> args0 })

    /**
     * The name of the badge.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The id of the project to add the badge to.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The image_url argument rendered (in case of use of placeholders).
     */
    public val renderedImageUrl: Output<String>
        get() = javaResource.renderedImageUrl().applyValue({ args0 -> args0 })

    /**
     * The link_url argument rendered (in case of use of placeholders).
     */
    public val renderedLinkUrl: Output<String>
        get() = javaResource.renderedLinkUrl().applyValue({ args0 -> args0 })
}

public object ProjectBadgeMapper : ResourceMapper<ProjectBadge> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectBadge::class == javaResource::class

    override fun map(javaResource: Resource): ProjectBadge = ProjectBadge(
        javaResource as
            com.pulumi.gitlab.ProjectBadge,
    )
}

/**
 * @see [ProjectBadge].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectBadge].
 */
public suspend fun projectBadge(
    name: String,
    block: suspend ProjectBadgeResourceBuilder.() -> Unit,
): ProjectBadge {
    val builder = ProjectBadgeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectBadge].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectBadge(name: String): ProjectBadge {
    val builder = ProjectBadgeResourceBuilder()
    builder.name(name)
    return builder.build()
}
