@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectBadgeArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectBadge` resource allows to manage the lifecycle of project badges.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/user/project/badges.html#project-badges)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.Project("foo", {name: "foo-project"});
 * const example = new gitlab.ProjectBadge("example", {
 *     project: foo.id,
 *     linkUrl: "https://example.com/badge-123",
 *     imageUrl: "https://example.com/badge-123.svg",
 *     name: "badge-123",
 * });
 * // Pipeline status badges with placeholders will be enabled
 * const gitlabPipeline = new gitlab.ProjectBadge("gitlab_pipeline", {
 *     project: foo.id,
 *     linkUrl: "https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}",
 *     imageUrl: "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg",
 *     name: "badge-pipeline",
 * });
 * // Test coverage report badges with placeholders will be enabled
 * const gitlabCoverage = new gitlab.ProjectBadge("gitlab_coverage", {
 *     project: foo.id,
 *     linkUrl: "https://gitlab.example.com/%{project_path}/-/jobs",
 *     imageUrl: "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg",
 *     name: "badge-coverage",
 * });
 * // Latest release badges with placeholders will be enabled
 * const gitlabRelease = new gitlab.ProjectBadge("gitlab_release", {
 *     project: foo.id,
 *     linkUrl: "https://gitlab.example.com/%{project_path}/-/releases",
 *     imageUrl: "https://gitlab.example.com/%{project_path}/-/badges/release.svg",
 *     name: "badge-release",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.Project("foo", name="foo-project")
 * example = gitlab.ProjectBadge("example",
 *     project=foo.id,
 *     link_url="https://example.com/badge-123",
 *     image_url="https://example.com/badge-123.svg",
 *     name="badge-123")
 * # Pipeline status badges with placeholders will be enabled
 * gitlab_pipeline = gitlab.ProjectBadge("gitlab_pipeline",
 *     project=foo.id,
 *     link_url="https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}",
 *     image_url="https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg",
 *     name="badge-pipeline")
 * # Test coverage report badges with placeholders will be enabled
 * gitlab_coverage = gitlab.ProjectBadge("gitlab_coverage",
 *     project=foo.id,
 *     link_url="https://gitlab.example.com/%{project_path}/-/jobs",
 *     image_url="https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg",
 *     name="badge-coverage")
 * # Latest release badges with placeholders will be enabled
 * gitlab_release = gitlab.ProjectBadge("gitlab_release",
 *     project=foo.id,
 *     link_url="https://gitlab.example.com/%{project_path}/-/releases",
 *     image_url="https://gitlab.example.com/%{project_path}/-/badges/release.svg",
 *     name="badge-release")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.Project("foo", new()
 *     {
 *         Name = "foo-project",
 *     });
 *     var example = new GitLab.ProjectBadge("example", new()
 *     {
 *         Project = foo.Id,
 *         LinkUrl = "https://example.com/badge-123",
 *         ImageUrl = "https://example.com/badge-123.svg",
 *         Name = "badge-123",
 *     });
 *     // Pipeline status badges with placeholders will be enabled
 *     var gitlabPipeline = new GitLab.ProjectBadge("gitlab_pipeline", new()
 *     {
 *         Project = foo.Id,
 *         LinkUrl = "https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}",
 *         ImageUrl = "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg",
 *         Name = "badge-pipeline",
 *     });
 *     // Test coverage report badges with placeholders will be enabled
 *     var gitlabCoverage = new GitLab.ProjectBadge("gitlab_coverage", new()
 *     {
 *         Project = foo.Id,
 *         LinkUrl = "https://gitlab.example.com/%{project_path}/-/jobs",
 *         ImageUrl = "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg",
 *         Name = "badge-coverage",
 *     });
 *     // Latest release badges with placeholders will be enabled
 *     var gitlabRelease = new GitLab.ProjectBadge("gitlab_release", new()
 *     {
 *         Project = foo.Id,
 *         LinkUrl = "https://gitlab.example.com/%{project_path}/-/releases",
 *         ImageUrl = "https://gitlab.example.com/%{project_path}/-/badges/release.svg",
 *         Name = "badge-release",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := gitlab.NewProject(ctx, "foo", &gitlab.ProjectArgs{
 * 			Name: pulumi.String("foo-project"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectBadge(ctx, "example", &gitlab.ProjectBadgeArgs{
 * 			Project:  foo.ID(),
 * 			LinkUrl:  pulumi.String("https://example.com/badge-123"),
 * 			ImageUrl: pulumi.String("https://example.com/badge-123.svg"),
 * 			Name:     pulumi.String("badge-123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Pipeline status badges with placeholders will be enabled
 * 		_, err = gitlab.NewProjectBadge(ctx, "gitlab_pipeline", &gitlab.ProjectBadgeArgs{
 * 			Project:  foo.ID(),
 * 			LinkUrl:  pulumi.String("https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}"),
 * 			ImageUrl: pulumi.String("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg"),
 * 			Name:     pulumi.String("badge-pipeline"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Test coverage report badges with placeholders will be enabled
 * 		_, err = gitlab.NewProjectBadge(ctx, "gitlab_coverage", &gitlab.ProjectBadgeArgs{
 * 			Project:  foo.ID(),
 * 			LinkUrl:  pulumi.String("https://gitlab.example.com/%{project_path}/-/jobs"),
 * 			ImageUrl: pulumi.String("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg"),
 * 			Name:     pulumi.String("badge-coverage"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Latest release badges with placeholders will be enabled
 * 		_, err = gitlab.NewProjectBadge(ctx, "gitlab_release", &gitlab.ProjectBadgeArgs{
 * 			Project:  foo.ID(),
 * 			LinkUrl:  pulumi.String("https://gitlab.example.com/%{project_path}/-/releases"),
 * 			ImageUrl: pulumi.String("https://gitlab.example.com/%{project_path}/-/badges/release.svg"),
 * 			Name:     pulumi.String("badge-release"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ProjectBadge;
 * import com.pulumi.gitlab.ProjectBadgeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Project("foo", ProjectArgs.builder()
 *             .name("foo-project")
 *             .build());
 *         var example = new ProjectBadge("example", ProjectBadgeArgs.builder()
 *             .project(foo.id())
 *             .linkUrl("https://example.com/badge-123")
 *             .imageUrl("https://example.com/badge-123.svg")
 *             .name("badge-123")
 *             .build());
 *         // Pipeline status badges with placeholders will be enabled
 *         var gitlabPipeline = new ProjectBadge("gitlabPipeline", ProjectBadgeArgs.builder()
 *             .project(foo.id())
 *             .linkUrl("https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}")
 *             .imageUrl("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg")
 *             .name("badge-pipeline")
 *             .build());
 *         // Test coverage report badges with placeholders will be enabled
 *         var gitlabCoverage = new ProjectBadge("gitlabCoverage", ProjectBadgeArgs.builder()
 *             .project(foo.id())
 *             .linkUrl("https://gitlab.example.com/%{project_path}/-/jobs")
 *             .imageUrl("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg")
 *             .name("badge-coverage")
 *             .build());
 *         // Latest release badges with placeholders will be enabled
 *         var gitlabRelease = new ProjectBadge("gitlabRelease", ProjectBadgeArgs.builder()
 *             .project(foo.id())
 *             .linkUrl("https://gitlab.example.com/%{project_path}/-/releases")
 *             .imageUrl("https://gitlab.example.com/%{project_path}/-/badges/release.svg")
 *             .name("badge-release")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:Project
 *     properties:
 *       name: foo-project
 *   example:
 *     type: gitlab:ProjectBadge
 *     properties:
 *       project: ${foo.id}
 *       linkUrl: https://example.com/badge-123
 *       imageUrl: https://example.com/badge-123.svg
 *       name: badge-123
 *   # Pipeline status badges with placeholders will be enabled
 *   gitlabPipeline:
 *     type: gitlab:ProjectBadge
 *     name: gitlab_pipeline
 *     properties:
 *       project: ${foo.id}
 *       linkUrl: https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}
 *       imageUrl: https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg
 *       name: badge-pipeline
 *   # Test coverage report badges with placeholders will be enabled
 *   gitlabCoverage:
 *     type: gitlab:ProjectBadge
 *     name: gitlab_coverage
 *     properties:
 *       project: ${foo.id}
 *       linkUrl: https://gitlab.example.com/%{project_path}/-/jobs
 *       imageUrl: https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg
 *       name: badge-coverage
 *   # Latest release badges with placeholders will be enabled
 *   gitlabRelease:
 *     type: gitlab:ProjectBadge
 *     name: gitlab_release
 *     properties:
 *       project: ${foo.id}
 *       linkUrl: https://gitlab.example.com/%{project_path}/-/releases
 *       imageUrl: https://gitlab.example.com/%{project_path}/-/badges/release.svg
 *       name: badge-release
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project badges can be imported using an id made up of `{project_id}:{badge_id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectBadge:ProjectBadge foo 1:3
 * ```
 * @property imageUrl The image url which will be presented on project overview.
 * @property linkUrl The url linked with the badge.
 * @property name The name of the badge.
 * @property project The id of the project to add the badge to.
 */
public data class ProjectBadgeArgs(
    public val imageUrl: Output<String>? = null,
    public val linkUrl: Output<String>? = null,
    public val name: Output<String>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectBadgeArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectBadgeArgs =
        com.pulumi.gitlab.ProjectBadgeArgs.builder()
            .imageUrl(imageUrl?.applyValue({ args0 -> args0 }))
            .linkUrl(linkUrl?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectBadgeArgs].
 */
@PulumiTagMarker
public class ProjectBadgeArgsBuilder internal constructor() {
    private var imageUrl: Output<String>? = null

    private var linkUrl: Output<String>? = null

    private var name: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value The image url which will be presented on project overview.
     */
    @JvmName("hvkbiuanwogwlbmm")
    public suspend fun imageUrl(`value`: Output<String>) {
        this.imageUrl = value
    }

    /**
     * @param value The url linked with the badge.
     */
    @JvmName("sjqfxaxijdvnhsxv")
    public suspend fun linkUrl(`value`: Output<String>) {
        this.linkUrl = value
    }

    /**
     * @param value The name of the badge.
     */
    @JvmName("shcolcleudmtrqrm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The id of the project to add the badge to.
     */
    @JvmName("tmnsfnpoogjrglix")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The image url which will be presented on project overview.
     */
    @JvmName("qggywpphxlaiukuj")
    public suspend fun imageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageUrl = mapped
    }

    /**
     * @param value The url linked with the badge.
     */
    @JvmName("ulqbcbdiddftamwg")
    public suspend fun linkUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkUrl = mapped
    }

    /**
     * @param value The name of the badge.
     */
    @JvmName("hyobpgdrlltxmxac")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The id of the project to add the badge to.
     */
    @JvmName("lfxnfvvvcxwlcqlq")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): ProjectBadgeArgs = ProjectBadgeArgs(
        imageUrl = imageUrl,
        linkUrl = linkUrl,
        name = name,
        project = project,
    )
}
