@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectComplianceFramework].
 */
@PulumiTagMarker
public class ProjectComplianceFrameworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectComplianceFrameworkArgs = ProjectComplianceFrameworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectComplianceFrameworkArgsBuilder.() -> Unit) {
        val builder = ProjectComplianceFrameworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectComplianceFramework {
        val builtJavaResource = com.pulumi.gitlab.ProjectComplianceFramework(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectComplianceFramework(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectComplianceFramework` resource allows to manage the lifecycle of a compliance framework on a project.
 * > This resource requires a GitLab Enterprise instance with a Premium license to set the compliance framework on a project.
 * **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#mutationprojectsetcomplianceframework)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const sample = new gitlab.ComplianceFramework("sample", {
 *     namespacePath: "top-level-group",
 *     name: "HIPAA",
 *     description: "A HIPAA Compliance Framework",
 *     color: "#87BEEF",
 *     "default": false,
 *     pipelineConfigurationFullPath: ".hipaa.yml@top-level-group/compliance-frameworks",
 * });
 * const sampleProjectComplianceFramework = new gitlab.ProjectComplianceFramework("sample", {
 *     complianceFrameworkId: sample.frameworkId,
 *     project: "12345678",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * sample = gitlab.ComplianceFramework("sample",
 *     namespace_path="top-level-group",
 *     name="HIPAA",
 *     description="A HIPAA Compliance Framework",
 *     color="#87BEEF",
 *     default=False,
 *     pipeline_configuration_full_path=".hipaa.yml@top-level-group/compliance-frameworks")
 * sample_project_compliance_framework = gitlab.ProjectComplianceFramework("sample",
 *     compliance_framework_id=sample.framework_id,
 *     project="12345678")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sample = new GitLab.ComplianceFramework("sample", new()
 *     {
 *         NamespacePath = "top-level-group",
 *         Name = "HIPAA",
 *         Description = "A HIPAA Compliance Framework",
 *         Color = "#87BEEF",
 *         Default = false,
 *         PipelineConfigurationFullPath = ".hipaa.yml@top-level-group/compliance-frameworks",
 *     });
 *     var sampleProjectComplianceFramework = new GitLab.ProjectComplianceFramework("sample", new()
 *     {
 *         ComplianceFrameworkId = sample.FrameworkId,
 *         Project = "12345678",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		sample, err := gitlab.NewComplianceFramework(ctx, "sample", &gitlab.ComplianceFrameworkArgs{
 * 			NamespacePath:                 pulumi.String("top-level-group"),
 * 			Name:                          pulumi.String("HIPAA"),
 * 			Description:                   pulumi.String("A HIPAA Compliance Framework"),
 * 			Color:                         pulumi.String("#87BEEF"),
 * 			Default:                       pulumi.Bool(false),
 * 			PipelineConfigurationFullPath: pulumi.String(".hipaa.yml@top-level-group/compliance-frameworks"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectComplianceFramework(ctx, "sample", &gitlab.ProjectComplianceFrameworkArgs{
 * 			ComplianceFrameworkId: sample.FrameworkId,
 * 			Project:               pulumi.String("12345678"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ComplianceFramework;
 * import com.pulumi.gitlab.ComplianceFrameworkArgs;
 * import com.pulumi.gitlab.ProjectComplianceFramework;
 * import com.pulumi.gitlab.ProjectComplianceFrameworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sample = new ComplianceFramework("sample", ComplianceFrameworkArgs.builder()
 *             .namespacePath("top-level-group")
 *             .name("HIPAA")
 *             .description("A HIPAA Compliance Framework")
 *             .color("#87BEEF")
 *             .default_(false)
 *             .pipelineConfigurationFullPath(".hipaa.yml@top-level-group/compliance-frameworks")
 *             .build());
 *         var sampleProjectComplianceFramework = new ProjectComplianceFramework("sampleProjectComplianceFramework", ProjectComplianceFrameworkArgs.builder()
 *             .complianceFrameworkId(sample.frameworkId())
 *             .project("12345678")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sample:
 *     type: gitlab:ComplianceFramework
 *     properties:
 *       namespacePath: top-level-group
 *       name: HIPAA
 *       description: A HIPAA Compliance Framework
 *       color: '#87BEEF'
 *       default: false
 *       pipelineConfigurationFullPath: .hipaa.yml@top-level-group/compliance-frameworks
 *   sampleProjectComplianceFramework:
 *     type: gitlab:ProjectComplianceFramework
 *     name: sample
 *     properties:
 *       complianceFrameworkId: ${sample.frameworkId}
 *       project: '12345678'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Gitlab project compliance frameworks can be imported with a key composed of `<project_id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectComplianceFramework:ProjectComplianceFramework sample "42"
 * ```
 */
public class ProjectComplianceFramework internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectComplianceFramework,
) : KotlinCustomResource(javaResource, ProjectComplianceFrameworkMapper) {
    /**
     * Globally unique ID of the compliance framework to assign to the project.
     */
    public val complianceFrameworkId: Output<String>
        get() = javaResource.complianceFrameworkId().applyValue({ args0 -> args0 })

    /**
     * The ID or full path of the project to change the compliance framework of.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })
}

public object ProjectComplianceFrameworkMapper : ResourceMapper<ProjectComplianceFramework> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectComplianceFramework::class == javaResource::class

    override fun map(javaResource: Resource): ProjectComplianceFramework =
        ProjectComplianceFramework(javaResource as com.pulumi.gitlab.ProjectComplianceFramework)
}

/**
 * @see [ProjectComplianceFramework].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectComplianceFramework].
 */
public suspend fun projectComplianceFramework(
    name: String,
    block: suspend ProjectComplianceFrameworkResourceBuilder.() -> Unit,
): ProjectComplianceFramework {
    val builder = ProjectComplianceFrameworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectComplianceFramework].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectComplianceFramework(name: String): ProjectComplianceFramework {
    val builder = ProjectComplianceFrameworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
