@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectCustomAttribute].
 */
@PulumiTagMarker
public class ProjectCustomAttributeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectCustomAttributeArgs = ProjectCustomAttributeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectCustomAttributeArgsBuilder.() -> Unit) {
        val builder = ProjectCustomAttributeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectCustomAttribute {
        val builtJavaResource = com.pulumi.gitlab.ProjectCustomAttribute(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectCustomAttribute(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectCustomAttribute` resource allows to manage custom attributes for a project.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/custom_attributes.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const attr = new gitlab.ProjectCustomAttribute("attr", {
 *     project: 42,
 *     key: "location",
 *     value: "Greenland",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * attr = gitlab.ProjectCustomAttribute("attr",
 *     project=42,
 *     key="location",
 *     value="Greenland")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attr = new GitLab.ProjectCustomAttribute("attr", new()
 *     {
 *         Project = 42,
 *         Key = "location",
 *         Value = "Greenland",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectCustomAttribute(ctx, "attr", &gitlab.ProjectCustomAttributeArgs{
 * 			Project: pulumi.Int(42),
 * 			Key:     pulumi.String("location"),
 * 			Value:   pulumi.String("Greenland"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectCustomAttribute;
 * import com.pulumi.gitlab.ProjectCustomAttributeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attr = new ProjectCustomAttribute("attr", ProjectCustomAttributeArgs.builder()
 *             .project("42")
 *             .key("location")
 *             .value("Greenland")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   attr:
 *     type: gitlab:ProjectCustomAttribute
 *     properties:
 *       project: '42'
 *       key: location
 *       value: Greenland
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a project custom attribute using an id made up of `{project-id}:{key}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectCustomAttribute:ProjectCustomAttribute attr 42:location
 * ```
 */
public class ProjectCustomAttribute internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectCustomAttribute,
) : KotlinCustomResource(javaResource, ProjectCustomAttributeMapper) {
    /**
     * Key for the Custom Attribute.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * The id of the project.
     */
    public val project: Output<Int>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Value for the Custom Attribute.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object ProjectCustomAttributeMapper : ResourceMapper<ProjectCustomAttribute> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectCustomAttribute::class == javaResource::class

    override fun map(javaResource: Resource): ProjectCustomAttribute =
        ProjectCustomAttribute(javaResource as com.pulumi.gitlab.ProjectCustomAttribute)
}

/**
 * @see [ProjectCustomAttribute].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectCustomAttribute].
 */
public suspend fun projectCustomAttribute(
    name: String,
    block: suspend ProjectCustomAttributeResourceBuilder.() -> Unit,
): ProjectCustomAttribute {
    val builder = ProjectCustomAttributeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectCustomAttribute].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectCustomAttribute(name: String): ProjectCustomAttribute {
    val builder = ProjectCustomAttributeResourceBuilder()
    builder.name(name)
    return builder.build()
}
