@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectCustomAttributeArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectCustomAttribute` resource allows to manage custom attributes for a project.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/custom_attributes.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const attr = new gitlab.ProjectCustomAttribute("attr", {
 *     project: 42,
 *     key: "location",
 *     value: "Greenland",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * attr = gitlab.ProjectCustomAttribute("attr",
 *     project=42,
 *     key="location",
 *     value="Greenland")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attr = new GitLab.ProjectCustomAttribute("attr", new()
 *     {
 *         Project = 42,
 *         Key = "location",
 *         Value = "Greenland",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectCustomAttribute(ctx, "attr", &gitlab.ProjectCustomAttributeArgs{
 * 			Project: pulumi.Int(42),
 * 			Key:     pulumi.String("location"),
 * 			Value:   pulumi.String("Greenland"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectCustomAttribute;
 * import com.pulumi.gitlab.ProjectCustomAttributeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attr = new ProjectCustomAttribute("attr", ProjectCustomAttributeArgs.builder()
 *             .project("42")
 *             .key("location")
 *             .value("Greenland")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   attr:
 *     type: gitlab:ProjectCustomAttribute
 *     properties:
 *       project: '42'
 *       key: location
 *       value: Greenland
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a project custom attribute using an id made up of `{project-id}:{key}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectCustomAttribute:ProjectCustomAttribute attr 42:location
 * ```
 * @property key Key for the Custom Attribute.
 * @property project The id of the project.
 * @property value Value for the Custom Attribute.
 */
public data class ProjectCustomAttributeArgs(
    public val key: Output<String>? = null,
    public val project: Output<Int>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectCustomAttributeArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectCustomAttributeArgs =
        com.pulumi.gitlab.ProjectCustomAttributeArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectCustomAttributeArgs].
 */
@PulumiTagMarker
public class ProjectCustomAttributeArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var project: Output<Int>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Key for the Custom Attribute.
     */
    @JvmName("vfjnmqlsskptuwqx")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The id of the project.
     */
    @JvmName("fkjofsytntyrrvly")
    public suspend fun project(`value`: Output<Int>) {
        this.project = value
    }

    /**
     * @param value Value for the Custom Attribute.
     */
    @JvmName("kilfmrrpjqgnkwbp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Key for the Custom Attribute.
     */
    @JvmName("cdaocfhytvmvffdb")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The id of the project.
     */
    @JvmName("tgimvcskioilarrp")
    public suspend fun project(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Value for the Custom Attribute.
     */
    @JvmName("xkwtntucdksiucsy")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ProjectCustomAttributeArgs = ProjectCustomAttributeArgs(
        key = key,
        project = project,
        `value` = `value`,
    )
}
