@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectEnvironment].
 */
@PulumiTagMarker
public class ProjectEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectEnvironmentArgs = ProjectEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectEnvironmentArgsBuilder.() -> Unit) {
        val builder = ProjectEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectEnvironment {
        val builtJavaResource = com.pulumi.gitlab.ProjectEnvironment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectEnvironment(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const _this = new gitlab.Group("this", {
 *     name: "example",
 *     path: "example",
 *     description: "An example group",
 * });
 * const thisProject = new gitlab.Project("this", {
 *     name: "example",
 *     namespaceId: _this.id,
 *     initializeWithReadme: true,
 * });
 * const thisProjectEnvironment = new gitlab.ProjectEnvironment("this", {
 *     project: thisProject.id,
 *     name: "example",
 *     externalUrl: "www.example.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * this = gitlab.Group("this",
 *     name="example",
 *     path="example",
 *     description="An example group")
 * this_project = gitlab.Project("this",
 *     name="example",
 *     namespace_id=this.id,
 *     initialize_with_readme=True)
 * this_project_environment = gitlab.ProjectEnvironment("this",
 *     project=this_project.id,
 *     name="example",
 *     external_url="www.example.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @this = new GitLab.Group("this", new()
 *     {
 *         Name = "example",
 *         Path = "example",
 *         Description = "An example group",
 *     });
 *     var thisProject = new GitLab.Project("this", new()
 *     {
 *         Name = "example",
 *         NamespaceId = @this.Id,
 *         InitializeWithReadme = true,
 *     });
 *     var thisProjectEnvironment = new GitLab.ProjectEnvironment("this", new()
 *     {
 *         Project = thisProject.Id,
 *         Name = "example",
 *         ExternalUrl = "www.example.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		this, err := gitlab.NewGroup(ctx, "this", &gitlab.GroupArgs{
 * 			Name:        pulumi.String("example"),
 * 			Path:        pulumi.String("example"),
 * 			Description: pulumi.String("An example group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		thisProject, err := gitlab.NewProject(ctx, "this", &gitlab.ProjectArgs{
 * 			Name:                 pulumi.String("example"),
 * 			NamespaceId:          this.ID(),
 * 			InitializeWithReadme: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectEnvironment(ctx, "this", &gitlab.ProjectEnvironmentArgs{
 * 			Project:     thisProject.ID(),
 * 			Name:        pulumi.String("example"),
 * 			ExternalUrl: pulumi.String("www.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Group;
 * import com.pulumi.gitlab.GroupArgs;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ProjectEnvironment;
 * import com.pulumi.gitlab.ProjectEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var this_ = new Group("this", GroupArgs.builder()
 *             .name("example")
 *             .path("example")
 *             .description("An example group")
 *             .build());
 *         var thisProject = new Project("thisProject", ProjectArgs.builder()
 *             .name("example")
 *             .namespaceId(this_.id())
 *             .initializeWithReadme(true)
 *             .build());
 *         var thisProjectEnvironment = new ProjectEnvironment("thisProjectEnvironment", ProjectEnvironmentArgs.builder()
 *             .project(thisProject.id())
 *             .name("example")
 *             .externalUrl("www.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   this:
 *     type: gitlab:Group
 *     properties:
 *       name: example
 *       path: example
 *       description: An example group
 *   thisProject:
 *     type: gitlab:Project
 *     name: this
 *     properties:
 *       name: example
 *       namespaceId: ${this.id}
 *       initializeWithReadme: true
 *   thisProjectEnvironment:
 *     type: gitlab:ProjectEnvironment
 *     name: this
 *     properties:
 *       project: ${thisProject.id}
 *       name: example
 *       externalUrl: www.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project environments can be imported using an id made up of `projectId:environmenId`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectEnvironment:ProjectEnvironment bar 123:321
 * ```
 */
public class ProjectEnvironment internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectEnvironment,
) : KotlinCustomResource(javaResource, ProjectEnvironmentMapper) {
    /**
     * The ISO8601 date/time that this environment was created at in UTC.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Place to link to for this environment.
     */
    public val externalUrl: Output<String>?
        get() = javaResource.externalUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the environment.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID or full path of the project to environment is created for.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The name of the environment in lowercase, shortened to 63 bytes, and with everything except 0-9 and a-z replaced with -. No leading / trailing -. Use in URLs, host names and domain names.
     */
    public val slug: Output<String>
        get() = javaResource.slug().applyValue({ args0 -> args0 })

    /**
     * State the environment is in. Valid values are `available`, `stopped`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Determines whether the environment is attempted to be stopped before the environment is deleted.
     */
    public val stopBeforeDestroy: Output<Boolean>?
        get() = javaResource.stopBeforeDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ISO8601 date/time that this environment was last updated at in UTC.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object ProjectEnvironmentMapper : ResourceMapper<ProjectEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): ProjectEnvironment = ProjectEnvironment(
        javaResource as
            com.pulumi.gitlab.ProjectEnvironment,
    )
}

/**
 * @see [ProjectEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectEnvironment].
 */
public suspend fun projectEnvironment(
    name: String,
    block: suspend ProjectEnvironmentResourceBuilder.() -> Unit,
): ProjectEnvironment {
    val builder = ProjectEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectEnvironment(name: String): ProjectEnvironment {
    val builder = ProjectEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
