@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectEnvironmentArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const _this = new gitlab.Group("this", {
 *     name: "example",
 *     path: "example",
 *     description: "An example group",
 * });
 * const thisProject = new gitlab.Project("this", {
 *     name: "example",
 *     namespaceId: _this.id,
 *     initializeWithReadme: true,
 * });
 * const thisProjectEnvironment = new gitlab.ProjectEnvironment("this", {
 *     project: thisProject.id,
 *     name: "example",
 *     externalUrl: "www.example.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * this = gitlab.Group("this",
 *     name="example",
 *     path="example",
 *     description="An example group")
 * this_project = gitlab.Project("this",
 *     name="example",
 *     namespace_id=this.id,
 *     initialize_with_readme=True)
 * this_project_environment = gitlab.ProjectEnvironment("this",
 *     project=this_project.id,
 *     name="example",
 *     external_url="www.example.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @this = new GitLab.Group("this", new()
 *     {
 *         Name = "example",
 *         Path = "example",
 *         Description = "An example group",
 *     });
 *     var thisProject = new GitLab.Project("this", new()
 *     {
 *         Name = "example",
 *         NamespaceId = @this.Id,
 *         InitializeWithReadme = true,
 *     });
 *     var thisProjectEnvironment = new GitLab.ProjectEnvironment("this", new()
 *     {
 *         Project = thisProject.Id,
 *         Name = "example",
 *         ExternalUrl = "www.example.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		this, err := gitlab.NewGroup(ctx, "this", &gitlab.GroupArgs{
 * 			Name:        pulumi.String("example"),
 * 			Path:        pulumi.String("example"),
 * 			Description: pulumi.String("An example group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		thisProject, err := gitlab.NewProject(ctx, "this", &gitlab.ProjectArgs{
 * 			Name:                 pulumi.String("example"),
 * 			NamespaceId:          this.ID(),
 * 			InitializeWithReadme: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectEnvironment(ctx, "this", &gitlab.ProjectEnvironmentArgs{
 * 			Project:     thisProject.ID(),
 * 			Name:        pulumi.String("example"),
 * 			ExternalUrl: pulumi.String("www.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Group;
 * import com.pulumi.gitlab.GroupArgs;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ProjectEnvironment;
 * import com.pulumi.gitlab.ProjectEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var this_ = new Group("this", GroupArgs.builder()
 *             .name("example")
 *             .path("example")
 *             .description("An example group")
 *             .build());
 *         var thisProject = new Project("thisProject", ProjectArgs.builder()
 *             .name("example")
 *             .namespaceId(this_.id())
 *             .initializeWithReadme(true)
 *             .build());
 *         var thisProjectEnvironment = new ProjectEnvironment("thisProjectEnvironment", ProjectEnvironmentArgs.builder()
 *             .project(thisProject.id())
 *             .name("example")
 *             .externalUrl("www.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   this:
 *     type: gitlab:Group
 *     properties:
 *       name: example
 *       path: example
 *       description: An example group
 *   thisProject:
 *     type: gitlab:Project
 *     name: this
 *     properties:
 *       name: example
 *       namespaceId: ${this.id}
 *       initializeWithReadme: true
 *   thisProjectEnvironment:
 *     type: gitlab:ProjectEnvironment
 *     name: this
 *     properties:
 *       project: ${thisProject.id}
 *       name: example
 *       externalUrl: www.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project environments can be imported using an id made up of `projectId:environmenId`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectEnvironment:ProjectEnvironment bar 123:321
 * ```
 * @property externalUrl Place to link to for this environment.
 * @property name The name of the environment.
 * @property project The ID or full path of the project to environment is created for.
 * @property stopBeforeDestroy Determines whether the environment is attempted to be stopped before the environment is deleted.
 */
public data class ProjectEnvironmentArgs(
    public val externalUrl: Output<String>? = null,
    public val name: Output<String>? = null,
    public val project: Output<String>? = null,
    public val stopBeforeDestroy: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectEnvironmentArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectEnvironmentArgs =
        com.pulumi.gitlab.ProjectEnvironmentArgs.builder()
            .externalUrl(externalUrl?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .stopBeforeDestroy(stopBeforeDestroy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectEnvironmentArgs].
 */
@PulumiTagMarker
public class ProjectEnvironmentArgsBuilder internal constructor() {
    private var externalUrl: Output<String>? = null

    private var name: Output<String>? = null

    private var project: Output<String>? = null

    private var stopBeforeDestroy: Output<Boolean>? = null

    /**
     * @param value Place to link to for this environment.
     */
    @JvmName("ahvyufrdewmfplbb")
    public suspend fun externalUrl(`value`: Output<String>) {
        this.externalUrl = value
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("ihgadpgjavqjkeey")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID or full path of the project to environment is created for.
     */
    @JvmName("obpfwgoncoenjjvi")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Determines whether the environment is attempted to be stopped before the environment is deleted.
     */
    @JvmName("wknfkeiihrlrhggq")
    public suspend fun stopBeforeDestroy(`value`: Output<Boolean>) {
        this.stopBeforeDestroy = value
    }

    /**
     * @param value Place to link to for this environment.
     */
    @JvmName("ovwdhojqcemmcrcr")
    public suspend fun externalUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalUrl = mapped
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("nijkhjucxqcndwhv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID or full path of the project to environment is created for.
     */
    @JvmName("lncisdxueudogobd")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Determines whether the environment is attempted to be stopped before the environment is deleted.
     */
    @JvmName("kxyxpkgwnittobft")
    public suspend fun stopBeforeDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stopBeforeDestroy = mapped
    }

    internal fun build(): ProjectEnvironmentArgs = ProjectEnvironmentArgs(
        externalUrl = externalUrl,
        name = name,
        project = project,
        stopBeforeDestroy = stopBeforeDestroy,
    )
}
