@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectFreezePeriod].
 */
@PulumiTagMarker
public class ProjectFreezePeriodResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectFreezePeriodArgs = ProjectFreezePeriodArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectFreezePeriodArgsBuilder.() -> Unit) {
        val builder = ProjectFreezePeriodArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectFreezePeriod {
        val builtJavaResource = com.pulumi.gitlab.ProjectFreezePeriod(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectFreezePeriod(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectFreezePeriod` resource allows to manage the lifecycle of a freeze period for a project.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/freeze_periods.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const schedule = new gitlab.ProjectFreezePeriod("schedule", {
 *     project: foo.id,
 *     freezeStart: "0 23 * * 5",
 *     freezeEnd: "0 7 * * 1",
 *     cronTimezone: "UTC",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * schedule = gitlab.ProjectFreezePeriod("schedule",
 *     project=foo["id"],
 *     freeze_start="0 23 * * 5",
 *     freeze_end="0 7 * * 1",
 *     cron_timezone="UTC")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new GitLab.ProjectFreezePeriod("schedule", new()
 *     {
 *         Project = foo.Id,
 *         FreezeStart = "0 23 * * 5",
 *         FreezeEnd = "0 7 * * 1",
 *         CronTimezone = "UTC",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectFreezePeriod(ctx, "schedule", &gitlab.ProjectFreezePeriodArgs{
 * 			Project:      pulumi.Any(foo.Id),
 * 			FreezeStart:  pulumi.String("0 23 * * 5"),
 * 			FreezeEnd:    pulumi.String("0 7 * * 1"),
 * 			CronTimezone: pulumi.String("UTC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectFreezePeriod;
 * import com.pulumi.gitlab.ProjectFreezePeriodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new ProjectFreezePeriod("schedule", ProjectFreezePeriodArgs.builder()
 *             .project(foo.id())
 *             .freezeStart("0 23 * * 5")
 *             .freezeEnd("0 7 * * 1")
 *             .cronTimezone("UTC")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   schedule:
 *     type: gitlab:ProjectFreezePeriod
 *     properties:
 *       project: ${foo.id}
 *       freezeStart: 0 23 * * 5
 *       freezeEnd: 0 7 * * 1
 *       cronTimezone: UTC
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project freeze periods can be imported using an id made up of `project_id:freeze_period_id`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectFreezePeriod:ProjectFreezePeriod schedule "12345:1337"
 * ```
 */
public class ProjectFreezePeriod internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectFreezePeriod,
) : KotlinCustomResource(javaResource, ProjectFreezePeriodMapper) {
    /**
     * The timezone.
     */
    public val cronTimezone: Output<String>?
        get() = javaResource.cronTimezone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * End of the Freeze Period in cron format (e.g. `0 2 * * *`).
     */
    public val freezeEnd: Output<String>
        get() = javaResource.freezeEnd().applyValue({ args0 -> args0 })

    /**
     * Start of the Freeze Period in cron format (e.g. `0 1 * * *`).
     */
    public val freezeStart: Output<String>
        get() = javaResource.freezeStart().applyValue({ args0 -> args0 })

    /**
     * The ID or URL-encoded path of the project to add the schedule to.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })
}

public object ProjectFreezePeriodMapper : ResourceMapper<ProjectFreezePeriod> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectFreezePeriod::class == javaResource::class

    override fun map(javaResource: Resource): ProjectFreezePeriod = ProjectFreezePeriod(
        javaResource
            as com.pulumi.gitlab.ProjectFreezePeriod,
    )
}

/**
 * @see [ProjectFreezePeriod].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectFreezePeriod].
 */
public suspend fun projectFreezePeriod(
    name: String,
    block: suspend ProjectFreezePeriodResourceBuilder.() -> Unit,
): ProjectFreezePeriod {
    val builder = ProjectFreezePeriodResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectFreezePeriod].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectFreezePeriod(name: String): ProjectFreezePeriod {
    val builder = ProjectFreezePeriodResourceBuilder()
    builder.name(name)
    return builder.build()
}
