@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectFreezePeriodArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectFreezePeriod` resource allows to manage the lifecycle of a freeze period for a project.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/freeze_periods.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const schedule = new gitlab.ProjectFreezePeriod("schedule", {
 *     project: foo.id,
 *     freezeStart: "0 23 * * 5",
 *     freezeEnd: "0 7 * * 1",
 *     cronTimezone: "UTC",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * schedule = gitlab.ProjectFreezePeriod("schedule",
 *     project=foo["id"],
 *     freeze_start="0 23 * * 5",
 *     freeze_end="0 7 * * 1",
 *     cron_timezone="UTC")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new GitLab.ProjectFreezePeriod("schedule", new()
 *     {
 *         Project = foo.Id,
 *         FreezeStart = "0 23 * * 5",
 *         FreezeEnd = "0 7 * * 1",
 *         CronTimezone = "UTC",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectFreezePeriod(ctx, "schedule", &gitlab.ProjectFreezePeriodArgs{
 * 			Project:      pulumi.Any(foo.Id),
 * 			FreezeStart:  pulumi.String("0 23 * * 5"),
 * 			FreezeEnd:    pulumi.String("0 7 * * 1"),
 * 			CronTimezone: pulumi.String("UTC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectFreezePeriod;
 * import com.pulumi.gitlab.ProjectFreezePeriodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new ProjectFreezePeriod("schedule", ProjectFreezePeriodArgs.builder()
 *             .project(foo.id())
 *             .freezeStart("0 23 * * 5")
 *             .freezeEnd("0 7 * * 1")
 *             .cronTimezone("UTC")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   schedule:
 *     type: gitlab:ProjectFreezePeriod
 *     properties:
 *       project: ${foo.id}
 *       freezeStart: 0 23 * * 5
 *       freezeEnd: 0 7 * * 1
 *       cronTimezone: UTC
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project freeze periods can be imported using an id made up of `project_id:freeze_period_id`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectFreezePeriod:ProjectFreezePeriod schedule "12345:1337"
 * ```
 * @property cronTimezone The timezone.
 * @property freezeEnd End of the Freeze Period in cron format (e.g. `0 2 * * *`).
 * @property freezeStart Start of the Freeze Period in cron format (e.g. `0 1 * * *`).
 * @property project The ID or URL-encoded path of the project to add the schedule to.
 */
public data class ProjectFreezePeriodArgs(
    public val cronTimezone: Output<String>? = null,
    public val freezeEnd: Output<String>? = null,
    public val freezeStart: Output<String>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectFreezePeriodArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectFreezePeriodArgs =
        com.pulumi.gitlab.ProjectFreezePeriodArgs.builder()
            .cronTimezone(cronTimezone?.applyValue({ args0 -> args0 }))
            .freezeEnd(freezeEnd?.applyValue({ args0 -> args0 }))
            .freezeStart(freezeStart?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectFreezePeriodArgs].
 */
@PulumiTagMarker
public class ProjectFreezePeriodArgsBuilder internal constructor() {
    private var cronTimezone: Output<String>? = null

    private var freezeEnd: Output<String>? = null

    private var freezeStart: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value The timezone.
     */
    @JvmName("bemfirdapjgehjum")
    public suspend fun cronTimezone(`value`: Output<String>) {
        this.cronTimezone = value
    }

    /**
     * @param value End of the Freeze Period in cron format (e.g. `0 2 * * *`).
     */
    @JvmName("yrtmwhsmeeqxtwqm")
    public suspend fun freezeEnd(`value`: Output<String>) {
        this.freezeEnd = value
    }

    /**
     * @param value Start of the Freeze Period in cron format (e.g. `0 1 * * *`).
     */
    @JvmName("qmbukqbkqbgvvacm")
    public suspend fun freezeStart(`value`: Output<String>) {
        this.freezeStart = value
    }

    /**
     * @param value The ID or URL-encoded path of the project to add the schedule to.
     */
    @JvmName("apfrecgblsbldswi")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The timezone.
     */
    @JvmName("txddcbmdeenoroim")
    public suspend fun cronTimezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cronTimezone = mapped
    }

    /**
     * @param value End of the Freeze Period in cron format (e.g. `0 2 * * *`).
     */
    @JvmName("gctalwfijoyohpmd")
    public suspend fun freezeEnd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.freezeEnd = mapped
    }

    /**
     * @param value Start of the Freeze Period in cron format (e.g. `0 1 * * *`).
     */
    @JvmName("mvurkubejrntquap")
    public suspend fun freezeStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.freezeStart = mapped
    }

    /**
     * @param value The ID or URL-encoded path of the project to add the schedule to.
     */
    @JvmName("djcqiwhwofaoclpl")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): ProjectFreezePeriodArgs = ProjectFreezePeriodArgs(
        cronTimezone = cronTimezone,
        freezeEnd = freezeEnd,
        freezeStart = freezeStart,
        project = project,
    )
}
