@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectHook].
 */
@PulumiTagMarker
public class ProjectHookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectHookArgs = ProjectHookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectHookArgsBuilder.() -> Unit) {
        val builder = ProjectHookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectHook {
        val builtJavaResource = com.pulumi.gitlab.ProjectHook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectHook(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectHook` resource allows to manage the lifecycle of a project hook.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/projects.html#hooks)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.ProjectHook("example", {
 *     project: "example/hooked",
 *     url: "https://example.com/hook/example",
 *     mergeRequestsEvents: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.ProjectHook("example",
 *     project="example/hooked",
 *     url="https://example.com/hook/example",
 *     merge_requests_events=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.ProjectHook("example", new()
 *     {
 *         Project = "example/hooked",
 *         Url = "https://example.com/hook/example",
 *         MergeRequestsEvents = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectHook(ctx, "example", &gitlab.ProjectHookArgs{
 * 			Project:             pulumi.String("example/hooked"),
 * 			Url:                 pulumi.String("https://example.com/hook/example"),
 * 			MergeRequestsEvents: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectHook;
 * import com.pulumi.gitlab.ProjectHookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProjectHook("example", ProjectHookArgs.builder()
 *             .project("example/hooked")
 *             .url("https://example.com/hook/example")
 *             .mergeRequestsEvents(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:ProjectHook
 *     properties:
 *       project: example/hooked
 *       url: https://example.com/hook/example
 *       mergeRequestsEvents: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * A GitLab Project Hook can be imported using a key composed of `<project-id>:<hook-id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectHook:ProjectHook example "12345:1"
 * ```
 * NOTE: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.
 */
public class ProjectHook internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectHook,
) : KotlinCustomResource(javaResource, ProjectHookMapper) {
    /**
     * Invoke the hook for confidential issues events.
     */
    public val confidentialIssuesEvents: Output<Boolean>?
        get() = javaResource.confidentialIssuesEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for confidential notes events.
     */
    public val confidentialNoteEvents: Output<Boolean>?
        get() = javaResource.confidentialNoteEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set a custom webhook template.
     */
    public val customWebhookTemplate: Output<String>?
        get() = javaResource.customWebhookTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for deployment events.
     */
    public val deploymentEvents: Output<Boolean>?
        get() = javaResource.deploymentEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable ssl verification when invoking the hook.
     */
    public val enableSslVerification: Output<Boolean>?
        get() = javaResource.enableSslVerification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of the project hook.
     */
    public val hookId: Output<Int>
        get() = javaResource.hookId().applyValue({ args0 -> args0 })

    /**
     * Invoke the hook for issues events.
     */
    public val issuesEvents: Output<Boolean>?
        get() = javaResource.issuesEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for job events.
     */
    public val jobEvents: Output<Boolean>?
        get() = javaResource.jobEvents().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Invoke the hook for merge requests.
     */
    public val mergeRequestsEvents: Output<Boolean>?
        get() = javaResource.mergeRequestsEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for notes events.
     */
    public val noteEvents: Output<Boolean>?
        get() = javaResource.noteEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for pipeline events.
     */
    public val pipelineEvents: Output<Boolean>?
        get() = javaResource.pipelineEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name or id of the project to add the hook to.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The id of the project for the hook.
     */
    public val projectId: Output<Int>
        get() = javaResource.projectId().applyValue({ args0 -> args0 })

    /**
     * Invoke the hook for push events.
     */
    public val pushEvents: Output<Boolean>?
        get() = javaResource.pushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for push events on matching branches only.
     */
    public val pushEventsBranchFilter: Output<String>?
        get() = javaResource.pushEventsBranchFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for releases events.
     */
    public val releasesEvents: Output<Boolean>?
        get() = javaResource.releasesEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for tag push events.
     */
    public val tagPushEvents: Output<Boolean>?
        get() = javaResource.tagPushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A token to present when invoking the hook. The token is not available for imported resources.
     */
    public val token: Output<String>?
        get() = javaResource.token().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The url of the hook to invoke. Forces re-creation to preserve `token`.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })

    /**
     * Invoke the hook for wiki page events.
     */
    public val wikiPageEvents: Output<Boolean>?
        get() = javaResource.wikiPageEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ProjectHookMapper : ResourceMapper<ProjectHook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectHook::class == javaResource::class

    override fun map(javaResource: Resource): ProjectHook = ProjectHook(
        javaResource as
            com.pulumi.gitlab.ProjectHook,
    )
}

/**
 * @see [ProjectHook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectHook].
 */
public suspend fun projectHook(name: String, block: suspend ProjectHookResourceBuilder.() -> Unit): ProjectHook {
    val builder = ProjectHookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectHook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectHook(name: String): ProjectHook {
    val builder = ProjectHookResourceBuilder()
    builder.name(name)
    return builder.build()
}
