@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectHookArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectHook` resource allows to manage the lifecycle of a project hook.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/projects.html#hooks)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.ProjectHook("example", {
 *     project: "example/hooked",
 *     url: "https://example.com/hook/example",
 *     mergeRequestsEvents: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.ProjectHook("example",
 *     project="example/hooked",
 *     url="https://example.com/hook/example",
 *     merge_requests_events=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.ProjectHook("example", new()
 *     {
 *         Project = "example/hooked",
 *         Url = "https://example.com/hook/example",
 *         MergeRequestsEvents = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectHook(ctx, "example", &gitlab.ProjectHookArgs{
 * 			Project:             pulumi.String("example/hooked"),
 * 			Url:                 pulumi.String("https://example.com/hook/example"),
 * 			MergeRequestsEvents: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectHook;
 * import com.pulumi.gitlab.ProjectHookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProjectHook("example", ProjectHookArgs.builder()
 *             .project("example/hooked")
 *             .url("https://example.com/hook/example")
 *             .mergeRequestsEvents(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:ProjectHook
 *     properties:
 *       project: example/hooked
 *       url: https://example.com/hook/example
 *       mergeRequestsEvents: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * A GitLab Project Hook can be imported using a key composed of `<project-id>:<hook-id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectHook:ProjectHook example "12345:1"
 * ```
 * NOTE: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.
 * @property confidentialIssuesEvents Invoke the hook for confidential issues events.
 * @property confidentialNoteEvents Invoke the hook for confidential notes events.
 * @property customWebhookTemplate Set a custom webhook template.
 * @property deploymentEvents Invoke the hook for deployment events.
 * @property enableSslVerification Enable ssl verification when invoking the hook.
 * @property issuesEvents Invoke the hook for issues events.
 * @property jobEvents Invoke the hook for job events.
 * @property mergeRequestsEvents Invoke the hook for merge requests.
 * @property noteEvents Invoke the hook for notes events.
 * @property pipelineEvents Invoke the hook for pipeline events.
 * @property project The name or id of the project to add the hook to.
 * @property pushEvents Invoke the hook for push events.
 * @property pushEventsBranchFilter Invoke the hook for push events on matching branches only.
 * @property releasesEvents Invoke the hook for releases events.
 * @property tagPushEvents Invoke the hook for tag push events.
 * @property token A token to present when invoking the hook. The token is not available for imported resources.
 * @property url The url of the hook to invoke. Forces re-creation to preserve `token`.
 * @property wikiPageEvents Invoke the hook for wiki page events.
 */
public data class ProjectHookArgs(
    public val confidentialIssuesEvents: Output<Boolean>? = null,
    public val confidentialNoteEvents: Output<Boolean>? = null,
    public val customWebhookTemplate: Output<String>? = null,
    public val deploymentEvents: Output<Boolean>? = null,
    public val enableSslVerification: Output<Boolean>? = null,
    public val issuesEvents: Output<Boolean>? = null,
    public val jobEvents: Output<Boolean>? = null,
    public val mergeRequestsEvents: Output<Boolean>? = null,
    public val noteEvents: Output<Boolean>? = null,
    public val pipelineEvents: Output<Boolean>? = null,
    public val project: Output<String>? = null,
    public val pushEvents: Output<Boolean>? = null,
    public val pushEventsBranchFilter: Output<String>? = null,
    public val releasesEvents: Output<Boolean>? = null,
    public val tagPushEvents: Output<Boolean>? = null,
    public val token: Output<String>? = null,
    public val url: Output<String>? = null,
    public val wikiPageEvents: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectHookArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectHookArgs =
        com.pulumi.gitlab.ProjectHookArgs.builder()
            .confidentialIssuesEvents(confidentialIssuesEvents?.applyValue({ args0 -> args0 }))
            .confidentialNoteEvents(confidentialNoteEvents?.applyValue({ args0 -> args0 }))
            .customWebhookTemplate(customWebhookTemplate?.applyValue({ args0 -> args0 }))
            .deploymentEvents(deploymentEvents?.applyValue({ args0 -> args0 }))
            .enableSslVerification(enableSslVerification?.applyValue({ args0 -> args0 }))
            .issuesEvents(issuesEvents?.applyValue({ args0 -> args0 }))
            .jobEvents(jobEvents?.applyValue({ args0 -> args0 }))
            .mergeRequestsEvents(mergeRequestsEvents?.applyValue({ args0 -> args0 }))
            .noteEvents(noteEvents?.applyValue({ args0 -> args0 }))
            .pipelineEvents(pipelineEvents?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .pushEvents(pushEvents?.applyValue({ args0 -> args0 }))
            .pushEventsBranchFilter(pushEventsBranchFilter?.applyValue({ args0 -> args0 }))
            .releasesEvents(releasesEvents?.applyValue({ args0 -> args0 }))
            .tagPushEvents(tagPushEvents?.applyValue({ args0 -> args0 }))
            .token(token?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 }))
            .wikiPageEvents(wikiPageEvents?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectHookArgs].
 */
@PulumiTagMarker
public class ProjectHookArgsBuilder internal constructor() {
    private var confidentialIssuesEvents: Output<Boolean>? = null

    private var confidentialNoteEvents: Output<Boolean>? = null

    private var customWebhookTemplate: Output<String>? = null

    private var deploymentEvents: Output<Boolean>? = null

    private var enableSslVerification: Output<Boolean>? = null

    private var issuesEvents: Output<Boolean>? = null

    private var jobEvents: Output<Boolean>? = null

    private var mergeRequestsEvents: Output<Boolean>? = null

    private var noteEvents: Output<Boolean>? = null

    private var pipelineEvents: Output<Boolean>? = null

    private var project: Output<String>? = null

    private var pushEvents: Output<Boolean>? = null

    private var pushEventsBranchFilter: Output<String>? = null

    private var releasesEvents: Output<Boolean>? = null

    private var tagPushEvents: Output<Boolean>? = null

    private var token: Output<String>? = null

    private var url: Output<String>? = null

    private var wikiPageEvents: Output<Boolean>? = null

    /**
     * @param value Invoke the hook for confidential issues events.
     */
    @JvmName("jhtxwuxyiycqbxua")
    public suspend fun confidentialIssuesEvents(`value`: Output<Boolean>) {
        this.confidentialIssuesEvents = value
    }

    /**
     * @param value Invoke the hook for confidential notes events.
     */
    @JvmName("fmkwgwygjvxijaxa")
    public suspend fun confidentialNoteEvents(`value`: Output<Boolean>) {
        this.confidentialNoteEvents = value
    }

    /**
     * @param value Set a custom webhook template.
     */
    @JvmName("mrqwbddpsdqhfxix")
    public suspend fun customWebhookTemplate(`value`: Output<String>) {
        this.customWebhookTemplate = value
    }

    /**
     * @param value Invoke the hook for deployment events.
     */
    @JvmName("eivgdebqjuqdpihp")
    public suspend fun deploymentEvents(`value`: Output<Boolean>) {
        this.deploymentEvents = value
    }

    /**
     * @param value Enable ssl verification when invoking the hook.
     */
    @JvmName("iwfxlnmrgnxismho")
    public suspend fun enableSslVerification(`value`: Output<Boolean>) {
        this.enableSslVerification = value
    }

    /**
     * @param value Invoke the hook for issues events.
     */
    @JvmName("yriefteyquaauqsd")
    public suspend fun issuesEvents(`value`: Output<Boolean>) {
        this.issuesEvents = value
    }

    /**
     * @param value Invoke the hook for job events.
     */
    @JvmName("frrtnwjcjdsckmqu")
    public suspend fun jobEvents(`value`: Output<Boolean>) {
        this.jobEvents = value
    }

    /**
     * @param value Invoke the hook for merge requests.
     */
    @JvmName("nsmoedkofnivuqyt")
    public suspend fun mergeRequestsEvents(`value`: Output<Boolean>) {
        this.mergeRequestsEvents = value
    }

    /**
     * @param value Invoke the hook for notes events.
     */
    @JvmName("dhkiipfaqlvlsarp")
    public suspend fun noteEvents(`value`: Output<Boolean>) {
        this.noteEvents = value
    }

    /**
     * @param value Invoke the hook for pipeline events.
     */
    @JvmName("sborvpiupbowfdol")
    public suspend fun pipelineEvents(`value`: Output<Boolean>) {
        this.pipelineEvents = value
    }

    /**
     * @param value The name or id of the project to add the hook to.
     */
    @JvmName("dbpdbdupxjaqluej")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Invoke the hook for push events.
     */
    @JvmName("eytjwvvjakeyvyeg")
    public suspend fun pushEvents(`value`: Output<Boolean>) {
        this.pushEvents = value
    }

    /**
     * @param value Invoke the hook for push events on matching branches only.
     */
    @JvmName("jvgvmolmdgbljsek")
    public suspend fun pushEventsBranchFilter(`value`: Output<String>) {
        this.pushEventsBranchFilter = value
    }

    /**
     * @param value Invoke the hook for releases events.
     */
    @JvmName("hehenrgiiamibbjo")
    public suspend fun releasesEvents(`value`: Output<Boolean>) {
        this.releasesEvents = value
    }

    /**
     * @param value Invoke the hook for tag push events.
     */
    @JvmName("axnqkfsgdnungctl")
    public suspend fun tagPushEvents(`value`: Output<Boolean>) {
        this.tagPushEvents = value
    }

    /**
     * @param value A token to present when invoking the hook. The token is not available for imported resources.
     */
    @JvmName("hlqymmpjhuuioktv")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value The url of the hook to invoke. Forces re-creation to preserve `token`.
     */
    @JvmName("vkbqmlrkpaqunfov")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Invoke the hook for wiki page events.
     */
    @JvmName("eigphwxdnnidotnc")
    public suspend fun wikiPageEvents(`value`: Output<Boolean>) {
        this.wikiPageEvents = value
    }

    /**
     * @param value Invoke the hook for confidential issues events.
     */
    @JvmName("jpjmvnqdricrodxe")
    public suspend fun confidentialIssuesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialIssuesEvents = mapped
    }

    /**
     * @param value Invoke the hook for confidential notes events.
     */
    @JvmName("imchosdnthtkhcso")
    public suspend fun confidentialNoteEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialNoteEvents = mapped
    }

    /**
     * @param value Set a custom webhook template.
     */
    @JvmName("cusqxocgsxsorbwb")
    public suspend fun customWebhookTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customWebhookTemplate = mapped
    }

    /**
     * @param value Invoke the hook for deployment events.
     */
    @JvmName("caqtvykygvuibvmy")
    public suspend fun deploymentEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentEvents = mapped
    }

    /**
     * @param value Enable ssl verification when invoking the hook.
     */
    @JvmName("gtneoqscqcykkfuo")
    public suspend fun enableSslVerification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSslVerification = mapped
    }

    /**
     * @param value Invoke the hook for issues events.
     */
    @JvmName("ngkausqpbasxpqsm")
    public suspend fun issuesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuesEvents = mapped
    }

    /**
     * @param value Invoke the hook for job events.
     */
    @JvmName("onfgwtpckpqloopa")
    public suspend fun jobEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobEvents = mapped
    }

    /**
     * @param value Invoke the hook for merge requests.
     */
    @JvmName("agnptxrodogxjyyb")
    public suspend fun mergeRequestsEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestsEvents = mapped
    }

    /**
     * @param value Invoke the hook for notes events.
     */
    @JvmName("fhrcijdgjeoymhta")
    public suspend fun noteEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteEvents = mapped
    }

    /**
     * @param value Invoke the hook for pipeline events.
     */
    @JvmName("lvcjtkaxkvmouirh")
    public suspend fun pipelineEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineEvents = mapped
    }

    /**
     * @param value The name or id of the project to add the hook to.
     */
    @JvmName("lfriddcaoonhujjt")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Invoke the hook for push events.
     */
    @JvmName("loqyotyiqsixichj")
    public suspend fun pushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEvents = mapped
    }

    /**
     * @param value Invoke the hook for push events on matching branches only.
     */
    @JvmName("yvgkupmthsxadtnp")
    public suspend fun pushEventsBranchFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEventsBranchFilter = mapped
    }

    /**
     * @param value Invoke the hook for releases events.
     */
    @JvmName("opblnelghxaxcjob")
    public suspend fun releasesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releasesEvents = mapped
    }

    /**
     * @param value Invoke the hook for tag push events.
     */
    @JvmName("jqivoicltfuserew")
    public suspend fun tagPushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagPushEvents = mapped
    }

    /**
     * @param value A token to present when invoking the hook. The token is not available for imported resources.
     */
    @JvmName("tdlxagxhqxpbomjw")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    /**
     * @param value The url of the hook to invoke. Forces re-creation to preserve `token`.
     */
    @JvmName("aekwjhfvviywfmkh")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value Invoke the hook for wiki page events.
     */
    @JvmName("twagjniueerxeqbq")
    public suspend fun wikiPageEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wikiPageEvents = mapped
    }

    internal fun build(): ProjectHookArgs = ProjectHookArgs(
        confidentialIssuesEvents = confidentialIssuesEvents,
        confidentialNoteEvents = confidentialNoteEvents,
        customWebhookTemplate = customWebhookTemplate,
        deploymentEvents = deploymentEvents,
        enableSslVerification = enableSslVerification,
        issuesEvents = issuesEvents,
        jobEvents = jobEvents,
        mergeRequestsEvents = mergeRequestsEvents,
        noteEvents = noteEvents,
        pipelineEvents = pipelineEvents,
        project = project,
        pushEvents = pushEvents,
        pushEventsBranchFilter = pushEventsBranchFilter,
        releasesEvents = releasesEvents,
        tagPushEvents = tagPushEvents,
        token = token,
        url = url,
        wikiPageEvents = wikiPageEvents,
    )
}
