@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.ProjectIssueTaskCompletionStatus
import com.pulumi.gitlab.kotlin.outputs.ProjectIssueTaskCompletionStatus.Companion.toKotlin
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ProjectIssue].
 */
@PulumiTagMarker
public class ProjectIssueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectIssueArgs = ProjectIssueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectIssueArgsBuilder.() -> Unit) {
        val builder = ProjectIssueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectIssue {
        val builtJavaResource = com.pulumi.gitlab.ProjectIssue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectIssue(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.Project("foo", {
 *     name: "example project",
 *     description: "Lorem Ipsum",
 *     visibilityLevel: "public",
 * });
 * const welcomeIssue = new gitlab.ProjectIssue("welcome_issue", {
 *     project: foo.id,
 *     title: "Welcome!",
 *     description: pulumi.interpolate`  Welcome to the ${foo.name} project!
 * `,
 *     discussionLocked: true,
 * });
 * export const welcomeIssueWebUrl = webUrl;
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.Project("foo",
 *     name="example project",
 *     description="Lorem Ipsum",
 *     visibility_level="public")
 * welcome_issue = gitlab.ProjectIssue("welcome_issue",
 *     project=foo.id,
 *     title="Welcome!",
 *     description=foo.name.apply(lambda name: f"""  Welcome to the {name} project!
 * """),
 *     discussion_locked=True)
 * pulumi.export("welcomeIssueWebUrl", web_url)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.Project("foo", new()
 *     {
 *         Name = "example project",
 *         Description = "Lorem Ipsum",
 *         VisibilityLevel = "public",
 *     });
 *     var welcomeIssue = new GitLab.ProjectIssue("welcome_issue", new()
 *     {
 *         Project = foo.Id,
 *         Title = "Welcome!",
 *         Description = foo.Name.Apply(name => @$"  Welcome to the {name} project!
 * "),
 *         DiscussionLocked = true,
 *     });
 *     return new Dictionary<string, object?>
 *     {
 *         ["welcomeIssueWebUrl"] = webUrl,
 *     };
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := gitlab.NewProject(ctx, "foo", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("example project"),
 * 			Description:     pulumi.String("Lorem Ipsum"),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectIssue(ctx, "welcome_issue", &gitlab.ProjectIssueArgs{
 * 			Project: foo.ID(),
 * 			Title:   pulumi.String("Welcome!"),
 * 			Description: foo.Name.ApplyT(func(name string) (string, error) {
 * 				return fmt.Sprintf("  Welcome to the %v project!\n\n", name), nil
 * 			}).(pulumi.StringOutput),
 * 			DiscussionLocked: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ctx.Export("welcomeIssueWebUrl", webUrl)
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ProjectIssue;
 * import com.pulumi.gitlab.ProjectIssueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Project("foo", ProjectArgs.builder()
 *             .name("example project")
 *             .description("Lorem Ipsum")
 *             .visibilityLevel("public")
 *             .build());
 *         var welcomeIssue = new ProjectIssue("welcomeIssue", ProjectIssueArgs.builder()
 *             .project(foo.id())
 *             .title("Welcome!")
 *             .description(foo.name().applyValue(name -> """
 *   Welcome to the %s project!
 * ", name)))
 *             .discussionLocked(true)
 *             .build());
 *         ctx.export("welcomeIssueWebUrl", webUrl);
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:Project
 *     properties:
 *       name: example project
 *       description: Lorem Ipsum
 *       visibilityLevel: public
 *   welcomeIssue:
 *     type: gitlab:ProjectIssue
 *     name: welcome_issue
 *     properties:
 *       project: ${foo.id}
 *       title: Welcome!
 *       description: |2+
 *           Welcome to the ${foo.name} project!
 *       discussionLocked: true
 * outputs:
 *   welcomeIssueWebUrl: ${webUrl}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import this resource with an id made up of `{project-id}:{issue-id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectIssue:ProjectIssue welcome_issue 42:1
 * ```
 */
public class ProjectIssue internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectIssue,
) : KotlinCustomResource(javaResource, ProjectIssueMapper) {
    /**
     * The IDs of the users to assign the issue to.
     */
    public val assigneeIds: Output<List<Int>>?
        get() = javaResource.assigneeIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The ID of the author of the issue. Use `gitlab.User` data source to get more information about the user.
     */
    public val authorId: Output<Int>
        get() = javaResource.authorId().applyValue({ args0 -> args0 })

    /**
     * When the issue was closed. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
     */
    public val closedAt: Output<String>
        get() = javaResource.closedAt().applyValue({ args0 -> args0 })

    /**
     * The ID of the user that closed the issue. Use `gitlab.User` data source to get more information about the user.
     */
    public val closedByUserId: Output<Int>
        get() = javaResource.closedByUserId().applyValue({ args0 -> args0 })

    /**
     * Set an issue to be confidential.
     */
    public val confidential: Output<Boolean>?
        get() = javaResource.confidential().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Whether the issue is deleted instead of closed during destroy.
     */
    public val deleteOnDestroy: Output<Boolean>?
        get() = javaResource.deleteOnDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of an issue. Limited to 1,048,576 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the issue is locked for discussions or not.
     */
    public val discussionLocked: Output<Boolean>?
        get() = javaResource.discussionLocked().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
     */
    public val discussionToResolve: Output<String>?
        get() = javaResource.discussionToResolve().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of downvotes the issue has received.
     */
    public val downvotes: Output<Int>
        get() = javaResource.downvotes().applyValue({ args0 -> args0 })

    /**
     * The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
     */
    public val dueDate: Output<String>?
        get() = javaResource.dueDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ID of the epic to add the issue to. Valid values are greater than or equal to 0.
     */
    public val epicId: Output<Int>
        get() = javaResource.epicId().applyValue({ args0 -> args0 })

    /**
     * The ID of the epic issue.
     */
    public val epicIssueId: Output<Int>
        get() = javaResource.epicIssueId().applyValue({ args0 -> args0 })

    /**
     * The external ID of the issue.
     */
    public val externalId: Output<String>
        get() = javaResource.externalId().applyValue({ args0 -> args0 })

    /**
     * The human-readable time estimate of the issue.
     */
    public val humanTimeEstimate: Output<String>
        get() = javaResource.humanTimeEstimate().applyValue({ args0 -> args0 })

    /**
     * The human-readable total time spent of the issue.
     */
    public val humanTotalTimeSpent: Output<String>
        get() = javaResource.humanTotalTimeSpent().applyValue({ args0 -> args0 })

    /**
     * The internal ID of the project's issue.
     */
    public val iid: Output<Int>
        get() = javaResource.iid().applyValue({ args0 -> args0 })

    /**
     * The instance-wide ID of the issue.
     */
    public val issueId: Output<Int>
        get() = javaResource.issueId().applyValue({ args0 -> args0 })

    /**
     * The ID of the issue link.
     */
    public val issueLinkId: Output<Int>
        get() = javaResource.issueLinkId().applyValue({ args0 -> args0 })

    /**
     * The type of issue. Valid values are: `issue`, `incident`, `test_case`.
     */
    public val issueType: Output<String>?
        get() = javaResource.issueType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The labels of an issue.
     */
    public val labels: Output<List<String>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The links of the issue.
     */
    public val links: Output<Map<String, String>>
        get() = javaResource.links().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
     */
    public val mergeRequestToResolveDiscussionsOf: Output<Int>?
        get() = javaResource.mergeRequestToResolveDiscussionsOf().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The number of merge requests associated with the issue.
     */
    public val mergeRequestsCount: Output<Int>
        get() = javaResource.mergeRequestsCount().applyValue({ args0 -> args0 })

    /**
     * The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
     */
    public val milestoneId: Output<Int>?
        get() = javaResource.milestoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the issue that was moved to.
     */
    public val movedToId: Output<Int>
        get() = javaResource.movedToId().applyValue({ args0 -> args0 })

    /**
     * The name or ID of the project.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The references of the issue.
     */
    public val references: Output<Map<String, String>>
        get() = javaResource.references().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The state of the issue. Valid values are: `opened`, `closed`.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether the authenticated user is subscribed to the issue or not.
     */
    public val subscribed: Output<Boolean>
        get() = javaResource.subscribed().applyValue({ args0 -> args0 })

    /**
     * The task completion status. It's always a one element list.
     */
    public val taskCompletionStatuses: Output<List<ProjectIssueTaskCompletionStatus>>
        get() = javaResource.taskCompletionStatuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The time estimate of the issue.
     */
    public val timeEstimate: Output<Int>
        get() = javaResource.timeEstimate().applyValue({ args0 -> args0 })

    /**
     * The title of the issue.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The total time spent of the issue.
     */
    public val totalTimeSpent: Output<Int>
        get() = javaResource.totalTimeSpent().applyValue({ args0 -> args0 })

    /**
     * When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })

    /**
     * The number of upvotes the issue has received.
     */
    public val upvotes: Output<Int>
        get() = javaResource.upvotes().applyValue({ args0 -> args0 })

    /**
     * The number of user notes on the issue.
     */
    public val userNotesCount: Output<Int>
        get() = javaResource.userNotesCount().applyValue({ args0 -> args0 })

    /**
     * The web URL of the issue.
     */
    public val webUrl: Output<String>
        get() = javaResource.webUrl().applyValue({ args0 -> args0 })

    /**
     * The weight of the issue. Valid values are greater than or equal to 0.
     */
    public val weight: Output<Int>
        get() = javaResource.weight().applyValue({ args0 -> args0 })
}

public object ProjectIssueMapper : ResourceMapper<ProjectIssue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectIssue::class == javaResource::class

    override fun map(javaResource: Resource): ProjectIssue = ProjectIssue(
        javaResource as
            com.pulumi.gitlab.ProjectIssue,
    )
}

/**
 * @see [ProjectIssue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectIssue].
 */
public suspend fun projectIssue(
    name: String,
    block: suspend ProjectIssueResourceBuilder.() -> Unit,
): ProjectIssue {
    val builder = ProjectIssueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectIssue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectIssue(name: String): ProjectIssue {
    val builder = ProjectIssueResourceBuilder()
    builder.name(name)
    return builder.build()
}
